/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.archive;

import javax.xml.namespace.QName;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.shell.api.AbstractShellCommand;

public class RemoveEntryArchiveCommand
extends AbstractShellCommand {
    public void printUsage() {
        this.print("archive:removeEntry <archivePath>", new Object[0]);
    }

    public void printHelp() {
        this.print("The 'removeEntry' command will remove a single entry from the", new Object[0]);
        this.print("currently open S-RAMP batch archive.  The path to the entry", new Object[0]);
        this.print("must be specified.", new Object[0]);
    }

    public void execute() throws Exception {
        String archivePathArg = this.requiredArgument(0, "Please include an entry path (relative archive path).");
        QName varName = new QName("archive", "active-archive");
        SrampArchive archive = (SrampArchive)this.getContext().getVariable(varName);
        if (archive == null) {
            this.print("No S-RAMP archive is currently open.", new Object[0]);
        } else {
            boolean success = archive.removeEntry(archivePathArg);
            if (success) {
                this.print("The S-RAMP archive entry was successfully delete.", new Object[0]);
            } else {
                this.print("No S-RAMP archive entry could be found at path: " + archivePathArg, new Object[0]);
            }
        }
    }
}

