/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.core;

import java.util.List;
import javax.xml.namespace.QName;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.shell.api.AbstractShellCommand;

public class ConnectCommand
extends AbstractShellCommand {
    public void printUsage() {
        this.print("s-ramp:connect <endpointUrl> [username password] [--disableValidation]", new Object[0]);
    }

    public void printHelp() {
        this.print("The 'connect' command creates a connection to a remote", new Object[0]);
        this.print("S-RAMP repository at its Atom endpoint.  The connection", new Object[0]);
        this.print("to the repository will be validated unless the ", new Object[0]);
        this.print("'--disableValidation' option is set.", new Object[0]);
        this.print("", new Object[0]);
        this.print("Example usage:", new Object[0]);
        this.print(">  s-ramp:connect http://localhost:8080/s-ramp-server", new Object[0]);
        this.print(">  s-ramp:connect http://example.org/s-ramp --disableValidation", new Object[0]);
        this.print(">  s-ramp:connect http://localhost:8080/s-ramp-server admin password", new Object[0]);
    }

    public void execute() throws Exception {
        boolean validating;
        String endpointUrlArg = this.requiredArgument(0, "Please specify a valid s-ramp URL.");
        String opt1 = this.optionalArgument(1);
        String opt2 = this.optionalArgument(2);
        String opt3 = this.optionalArgument(3);
        String username = null;
        String password = null;
        String disableValidationOptionArg = null;
        boolean hasCreds = false;
        if (opt3 != null) {
            username = opt1;
            password = opt2;
            disableValidationOptionArg = opt3;
            hasCreds = true;
        } else if (opt2 != null) {
            username = opt1;
            password = opt2;
            hasCreds = true;
        } else {
            disableValidationOptionArg = opt1;
        }
        boolean bl = validating = !"--disableValidation".equals(disableValidationOptionArg);
        if (!endpointUrlArg.startsWith("http")) {
            endpointUrlArg = "http://" + endpointUrlArg;
        }
        QName varName = new QName("s-ramp", "client");
        try {
            SrampAtomApiClient client = null;
            client = hasCreds ? new SrampAtomApiClient(endpointUrlArg, username, password, validating) : new SrampAtomApiClient(endpointUrlArg, validating);
            this.getContext().setVariable(varName, (Object)client);
            this.print("Successfully connected to S-RAMP endpoint: " + endpointUrlArg, new Object[0]);
        }
        catch (Exception e) {
            this.print("FAILED to connect to S-RAMP endpoint: " + endpointUrlArg, new Object[0]);
            this.print("\t" + e.getMessage(), new Object[0]);
        }
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        if (this.getArguments().isEmpty()) {
            candidates.add("http://localhost:8080/s-ramp-server");
            return 0;
        }
        return -1;
    }
}

