/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.core;

import javax.xml.namespace.QName;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.common.visitors.ArtifactVisitor;
import org.overlord.sramp.common.visitors.ArtifactVisitorHelper;
import org.overlord.sramp.shell.api.AbstractShellCommand;
import org.overlord.sramp.shell.util.PrintArtifactMetaDataVisitor;

public class ShowMetaDataCommand
extends AbstractShellCommand {
    public void printUsage() {
        this.print("s-ramp:showMetaData", new Object[0]);
    }

    public void printHelp() {
        this.print("The 'showMetaData' command prints out the meta-data for the", new Object[0]);
        this.print("artifact currently active in the session.", new Object[0]);
        this.print("", new Object[0]);
        this.print("Example usage:", new Object[0]);
        this.print(">  s-ramp:showMetaData", new Object[0]);
    }

    public void execute() throws Exception {
        QName artifactVarName = new QName("s-ramp", "artifact");
        BaseArtifactType artifact = (BaseArtifactType)this.getContext().getVariable(artifactVarName);
        if (artifact == null) {
            this.print("No active S-RAMP artifact exists.  Use s-ramp:getMetaData.", new Object[0]);
            return;
        }
        this.print("Meta Data for: " + artifact.getUuid(), new Object[0]);
        this.print("--------------", new Object[0]);
        PrintArtifactMetaDataVisitor visitor = new PrintArtifactMetaDataVisitor();
        ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
    }
}

