/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.ontology;

import java.util.List;
import javax.xml.namespace.QName;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.ontology.OntologySummary;
import org.overlord.sramp.shell.api.AbstractShellCommand;
import org.overlord.sramp.shell.api.InvalidCommandArgumentException;

public class DeleteOntologyCommand
extends AbstractShellCommand {
    public void printUsage() {
        this.print("ontology:delete <ontologyId>", new Object[0]);
        this.print("\tValid formats for ontologyId:", new Object[0]);
        this.print("\t  feed:<feedIndex> - an index into the most recent list of ontologies", new Object[0]);
        this.print("\t  uuid:<ontologyUUID> - the UUID of an ontology", new Object[0]);
    }

    public void printHelp() {
        this.print("The 'delete' command removes a single ontology from the S-RAMP", new Object[0]);
        this.print("repository.", new Object[0]);
        this.print("", new Object[0]);
        this.print("Example usage:", new Object[0]);
        this.print("> ontology:delete feed:2", new Object[0]);
        this.print("> ontology:delete uuid:2763-2382-39293-382873", new Object[0]);
    }

    public void execute() throws Exception {
        String ontologyIdArg = this.requiredArgument(0, "Please specify a valid ontology identifier.");
        QName feedVarName = new QName("ontology", "feed");
        QName clientVarName = new QName("s-ramp", "client");
        SrampAtomApiClient client = (SrampAtomApiClient)this.getContext().getVariable(clientVarName);
        if (client == null) {
            this.print("No S-RAMP repository connection is currently open.", new Object[0]);
            return;
        }
        if (!ontologyIdArg.contains(":") || ontologyIdArg.endsWith(":")) {
            throw new InvalidCommandArgumentException(0, "Invalid artifact id format.");
        }
        String ontologyUuid = null;
        int colonIdx = ontologyIdArg.indexOf(58);
        String idType = ontologyIdArg.substring(0, colonIdx);
        String idValue = ontologyIdArg.substring(colonIdx + 1);
        if ("feed".equals(idType)) {
            List ontologies = (List)this.getContext().getVariable(feedVarName);
            if (ontologies == null) {
                throw new InvalidCommandArgumentException(0, "There is no ontology feed available, try 'ontology:list' first.");
            }
            int feedIdx = Integer.parseInt(idValue) - 1;
            if (feedIdx < 0 || feedIdx >= ontologies.size()) {
                throw new InvalidCommandArgumentException(0, "Feed index out of range.");
            }
            OntologySummary summary = (OntologySummary)ontologies.get(feedIdx);
            ontologyUuid = summary.getUuid();
        } else if ("uuid".equals(idType)) {
            ontologyUuid = idValue;
        } else {
            throw new InvalidCommandArgumentException(0, "Invalid artifact id format.");
        }
        try {
            client.deleteOntology(ontologyUuid);
            this.print("Successfully deleted the ontology.", new Object[0]);
        }
        catch (Exception e) {
            this.print("FAILED to get the list of ontologies.", new Object[0]);
            this.print("\t" + e.getMessage(), new Object[0]);
        }
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        if (this.getArguments().isEmpty() && (lastArgument == null || "feed:".startsWith(lastArgument))) {
            QName feedVarName = new QName("ontology", "feed");
            List ontologies = (List)this.getContext().getVariable(feedVarName);
            if (ontologies != null) {
                for (int idx = 0; idx < ontologies.size(); ++idx) {
                    String candidate = "feed:" + (idx + 1);
                    if (lastArgument == null) {
                        candidates.add(candidate);
                    }
                    if (lastArgument == null || !candidate.startsWith(lastArgument)) continue;
                    candidates.add(candidate);
                }
            }
            return 0;
        }
        return -1;
    }
}

