/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.archive;

import java.util.Collection;
import javax.xml.namespace.QName;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.atom.archive.SrampArchiveEntry;
import org.overlord.sramp.shell.api.AbstractShellCommand;

public class ListArchiveCommand
extends AbstractShellCommand {
    public void printUsage() {
        this.print("archive:list", new Object[0]);
    }

    public void printHelp() {
        this.print("This command display a list of the entries in the currently", new Object[0]);
        this.print("open S-RAMP archive.", new Object[0]);
    }

    public void execute() throws Exception {
        QName varName = new QName("archive", "active-archive");
        SrampArchive archive = (SrampArchive)this.getContext().getVariable(varName);
        if (archive == null) {
            this.print("No S-RAMP archive is currently open.", new Object[0]);
        } else {
            Collection entries = archive.getEntries();
            this.print("  Entry Path", new Object[0]);
            this.print("  ----------", new Object[0]);
            for (SrampArchiveEntry entry : entries) {
                String modifier = null;
                modifier = entry.hasContent() ? "  C " : "  E ";
                this.print(modifier + entry.getPath(), new Object[0]);
            }
            this.print("  ----------", new Object[0]);
            this.print("  " + entries.size() + " entries", new Object[0]);
        }
    }
}

