/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.archive;

import javax.xml.namespace.QName;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.shell.AbstractShellContextVariableLifecycleHandler;
import org.overlord.sramp.shell.api.AbstractShellCommand;
import org.overlord.sramp.shell.api.ShellContextVariableLifecycleHandler;

public class NewArchiveCommand
extends AbstractShellCommand {
    public void printUsage() {
        this.print("archive:new", new Object[0]);
    }

    public void printHelp() {
        this.print("The 'new' operation creates and opens an empty S-RAMP archive.", new Object[0]);
    }

    public void execute() throws Exception {
        SrampArchive archive = null;
        QName varName = new QName("archive", "active-archive");
        archive = (SrampArchive)this.getContext().getVariable(varName);
        if (archive != null) {
            this.print("An S-RAMP archive is already open.  Please archive:close it before creating a new one.", new Object[0]);
            return;
        }
        archive = new SrampArchive();
        this.getContext().setVariable(varName, (Object)archive, (ShellContextVariableLifecycleHandler)new AbstractShellContextVariableLifecycleHandler(){

            @Override
            public void onRemove(Object object) {
                SrampArchive.closeQuietly((SrampArchive)((SrampArchive)object));
            }

            @Override
            public void onContextDestroyed(Object object) {
                SrampArchive.closeQuietly((SrampArchive)((SrampArchive)object));
            }
        });
        this.print("New S-RAMP batch archive opened.", new Object[0]);
    }
}

