/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.core;

import java.util.List;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.ArtifactTypeEnum;
import org.overlord.sramp.shell.api.AbstractShellCommand;
import org.overlord.sramp.shell.api.InvalidCommandArgumentException;

public class QueryCommand
extends AbstractShellCommand {
    public void printUsage() {
        this.print("s-ramp:query <srampQuery>", new Object[0]);
    }

    public void printHelp() {
        this.print("The 'query' command issues a standard S-RAMP formatted", new Object[0]);
        this.print("query against the S-RAMP server.  The query will result", new Object[0]);
        this.print("in a Feed of entries.", new Object[0]);
        this.print("", new Object[0]);
        this.print("Example usage:", new Object[0]);
        this.print(">  s-ramp:query /s-ramp/wsdl/WsdlDocument", new Object[0]);
        this.print(">  s-ramp:query \"/s-ramp/wsdl[@name = 'find']\"", new Object[0]);
    }

    public void execute() throws Exception {
        String queryArg = this.requiredArgument(0, "Please specify a valid S-RAMP query.");
        String tooManyArgs = this.optionalArgument(1);
        if (tooManyArgs != null) {
            throw new InvalidCommandArgumentException(1, "Too many arguments: did you perhaps forget to surround your S-RAMP query in quotes?");
        }
        QName varName = new QName("s-ramp", "client");
        SrampAtomApiClient client = (SrampAtomApiClient)this.getContext().getVariable(varName);
        if (client == null) {
            this.print("No S-RAMP repository connection is currently open.", new Object[0]);
            return;
        }
        if (queryArg.endsWith("/")) {
            queryArg = queryArg.substring(0, queryArg.length() - 1);
        }
        this.print("Querying the S-RAMP repository:", new Object[0]);
        this.print("\t" + queryArg, new Object[0]);
        try {
            QueryResultSet rset = client.query(queryArg, 0, 100, "uuid", true);
            int entryIndex = 1;
            this.print("Atom Feed (%1$d entries)", new Object[]{rset.size()});
            this.print("  Idx                    Type Name", new Object[0]);
            this.print("  ---                    ---- ----", new Object[0]);
            for (ArtifactSummary summary : rset) {
                ArtifactType type = summary.getType();
                String displayType = type.getArtifactType().getType().toString();
                if (type.isExtendedType() && type.getExtendedType() != null) {
                    displayType = type.getExtendedType();
                }
                this.print("  %1$3d %2$23s %3$-40s", new Object[]{entryIndex++, displayType, summary.getName()});
            }
            this.getContext().setVariable(new QName("s-ramp", "feed"), (Object)rset);
        }
        catch (Exception e) {
            this.print("FAILED to query the repository.", new Object[0]);
            this.print("\t" + e.getMessage(), new Object[0]);
        }
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        if (this.getArguments().isEmpty()) {
            if (lastArgument == null) {
                candidates.add("\"/s-ramp/");
                return 0;
            }
            String[] split = lastArgument.split("/");
            if (split.length == 0 || split.length == 1 || split.length == 2 && !lastArgument.endsWith("/")) {
                candidates.add("\"/s-ramp/");
                return 0;
            }
            if (lastArgument.equals("/s-ramp/")) {
                TreeSet<String> modelCandidates = new TreeSet<String>();
                for (ArtifactTypeEnum t : ArtifactTypeEnum.values()) {
                    modelCandidates.add(t.getModel());
                }
                candidates.addAll(modelCandidates);
                return lastArgument.length();
            }
            if (split.length == 3 && !lastArgument.endsWith("/") && lastArgument.startsWith("/s-ramp/")) {
                String partialModel = split[2];
                TreeSet<String> modelCandidates = new TreeSet<String>();
                for (ArtifactTypeEnum t : ArtifactTypeEnum.values()) {
                    if (!t.getModel().startsWith(partialModel)) continue;
                    modelCandidates.add(t.getModel());
                }
                if (modelCandidates.size() == 1) {
                    candidates.add((String)modelCandidates.iterator().next() + "/");
                } else {
                    candidates.addAll(modelCandidates);
                }
                return lastArgument.length() - partialModel.length();
            }
            if (split.length == 3 && lastArgument.endsWith("/") && lastArgument.startsWith("/s-ramp/")) {
                String model = split[2];
                TreeSet<String> typeCandidates = new TreeSet<String>();
                for (ArtifactTypeEnum t : ArtifactTypeEnum.values()) {
                    if (!t.getModel().equals(model)) continue;
                    typeCandidates.add(t.getType());
                }
                candidates.addAll(typeCandidates);
                return lastArgument.length();
            }
            if (split.length == 4 && !lastArgument.endsWith("/") && lastArgument.startsWith("/s-ramp/")) {
                String model = split[2];
                String partialType = split[3];
                TreeSet<String> typeCandidates = new TreeSet<String>();
                for (ArtifactTypeEnum t : ArtifactTypeEnum.values()) {
                    if (!t.getModel().equals(model) || !t.getType().startsWith(partialType)) continue;
                    typeCandidates.add(t.getType());
                }
                candidates.addAll(typeCandidates);
                return lastArgument.length() - partialType.length();
            }
        }
        return -1;
    }
}

