/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.util;

import java.util.List;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DerivedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.NamedWsdlDerivedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Property;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Relationship;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Target;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XmlDocument;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.visitors.HierarchicalArtifactVisitorAdapter;

public class PrintArtifactMetaDataVisitor
extends HierarchicalArtifactVisitorAdapter {
    protected void visitBase(BaseArtifactType artifact) {
        ArtifactType artifactType = ArtifactType.valueOf((BaseArtifactType)artifact);
        System.out.println("  -- Core S-RAMP Info --");
        if (artifactType.isExtendedType()) {
            PrintArtifactMetaDataVisitor.printProperty("Type", artifactType.getExtendedType());
        } else {
            PrintArtifactMetaDataVisitor.printProperty("Type", artifactType.getArtifactType().getType());
        }
        PrintArtifactMetaDataVisitor.printProperty("Model", artifactType.getArtifactType().getModel());
        PrintArtifactMetaDataVisitor.printProperty("UUID", artifact.getUuid());
        PrintArtifactMetaDataVisitor.printProperty("Name", artifact.getName());
        PrintArtifactMetaDataVisitor.printProperty("Version", artifact.getVersion());
        PrintArtifactMetaDataVisitor.printProperty("Derived", String.valueOf(artifactType.isDerived()));
        PrintArtifactMetaDataVisitor.printProperty("Created By", artifact.getCreatedBy());
        if (artifact.getCreatedTimestamp() != null) {
            PrintArtifactMetaDataVisitor.printProperty("Created On", artifact.getCreatedTimestamp().toXMLFormat());
        }
        PrintArtifactMetaDataVisitor.printProperty("Modified By", artifact.getLastModifiedBy());
        if (artifact.getLastModifiedTimestamp() != null) {
            PrintArtifactMetaDataVisitor.printProperty("Modified On", artifact.getLastModifiedTimestamp().toXMLFormat());
        }
        if (artifact.getDescription() != null) {
            System.out.println("  -- Description --");
            System.out.println(artifact.getDescription());
        }
        if (artifact.getClassifiedBy().size() > 0) {
            System.out.println("  -- Classifications --");
            for (String classification : artifact.getClassifiedBy()) {
                PrintArtifactMetaDataVisitor.printProperty("Classified By", classification);
            }
        }
        if (artifact.getProperty().size() > 0) {
            System.out.println("  -- Custom Properties --");
            for (Property property : artifact.getProperty()) {
                PrintArtifactMetaDataVisitor.printProperty(property.getPropertyName(), property.getPropertyValue());
            }
        }
        if (artifact.getRelationship().size() > 0) {
            System.out.println("  -- Generic Relationships --");
            for (Relationship relationship : artifact.getRelationship()) {
                List targets = relationship.getRelationshipTarget();
                PrintArtifactMetaDataVisitor.printRelationship(relationship.getRelationshipType(), targets);
            }
        }
    }

    protected void visitDerived(DerivedArtifactType artifact) {
        System.out.println("  -- Derived Artifact Info --");
        DocumentArtifactTarget relatedDocument = artifact.getRelatedDocument();
        PrintArtifactMetaDataVisitor.printRelationship("Related Document", (Target)relatedDocument);
    }

    protected void visitDocument(DocumentArtifactType artifact) {
        System.out.println("  -- Document Info --");
        PrintArtifactMetaDataVisitor.printProperty("Content Type", artifact.getContentType());
        PrintArtifactMetaDataVisitor.printProperty("Content Size", String.valueOf(artifact.getContentSize()));
    }

    protected void visitXmlDocument(XmlDocument artifact) {
        System.out.println("  -- XML Document Info --");
        PrintArtifactMetaDataVisitor.printProperty("Content Encoding", artifact.getContentEncoding());
    }

    protected void visitNamedWsdlDerived(NamedWsdlDerivedArtifactType artifact) {
        System.out.println("  -- Named WSDL Info --");
        PrintArtifactMetaDataVisitor.printProperty("NCName", artifact.getNCName());
    }

    private static void printProperty(String propertyName, String propertyValue) {
        if (propertyValue != null) {
            System.out.printf("  %1$s: %2$s\n", propertyName, propertyValue);
        }
    }

    private static void printRelationship(String name, Target target) {
        String targetStr = target.getValue();
        PrintArtifactMetaDataVisitor.printProperty(name, targetStr);
    }

    private static void printRelationship(String name, List<? extends Target> targets) {
        String targetStr = "";
        boolean first = true;
        for (Target target : targets) {
            if (!first) {
                targetStr = targetStr + ", ";
            } else {
                first = false;
            }
            targetStr = targetStr + target.getValue();
        }
        PrintArtifactMetaDataVisitor.printProperty(name, targetStr);
    }
}

