/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell;

import java.io.IOException;
import java.util.Locale;
import org.overlord.sramp.shell.AbstractShellCommandReader;
import org.overlord.sramp.shell.ConsoleShellCommandReader;
import org.overlord.sramp.shell.FileShellCommandReader;
import org.overlord.sramp.shell.InteractiveShellCommandReader;
import org.overlord.sramp.shell.ShellCommandFactory;
import org.overlord.sramp.shell.ShellCommandReader;
import org.overlord.sramp.shell.ShellContextImpl;
import org.overlord.sramp.shell.StdInShellCommandReader;
import org.overlord.sramp.shell.api.InvalidCommandArgumentException;
import org.overlord.sramp.shell.api.ShellCommand;
import org.overlord.sramp.shell.i18n.Messages;

public class SrampShell {
    private static final String LOCALE_PROPERTY = "s-ramp.shell.locale";
    private ShellCommandFactory factory = new ShellCommandFactory();
    private ShellContextImpl context = new ShellContextImpl();
    private ShellCommandReader reader;

    public static void main(String[] args) {
        String locale_str = System.getProperty(LOCALE_PROPERTY);
        if (locale_str != null) {
            String lang = null;
            String region = null;
            String[] lsplit = locale_str.split("_");
            if (lsplit.length > 0) {
                lang = lsplit[0];
            }
            if (lsplit.length > 1) {
                region = lsplit[1];
            }
            if (lang != null && region != null) {
                Locale.setDefault(new Locale(lang, region));
            } else if (lang != null) {
                Locale.setDefault(new Locale(lang));
            }
        }
        final SrampShell shell = new SrampShell();
        Thread shutdownHook = new Thread(new Runnable(){

            @Override
            public void run() {
                shell.shutdown();
            }
        });
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        try {
            shell.run(args);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.out.println(Messages.i18n.format("Shell.EXITING", new Object[0]));
        }
    }

    public void run(String[] args) throws Exception {
        this.reader = this.createCommandReader(args);
        this.displayWelcomeMessage();
        boolean done = false;
        while (!done) {
            ShellCommand command = null;
            try {
                command = this.reader.read();
                if (command == null) {
                    done = true;
                    continue;
                }
                boolean success = command.execute();
                if (success || !this.reader.isBatch()) continue;
                System.exit(1);
            }
            catch (InvalidCommandArgumentException e) {
                System.out.println(Messages.i18n.format("Shell.INVALID_ARG", new Object[]{e.getMessage()}));
                if (command != null) {
                    System.out.println(Messages.i18n.format("Shell.USAGE", new Object[0]));
                    command.printUsage();
                }
                if (!this.reader.isBatch()) continue;
                System.exit(1);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                if (!this.reader.isBatch()) continue;
                System.exit(1);
            }
        }
    }

    protected ShellCommandReader createCommandReader(String[] args) throws IOException {
        AbstractShellCommandReader commandReader = null;
        if (args.length >= 2 && "-f".equals(args[0])) {
            String filePath = args[1];
            commandReader = new FileShellCommandReader(this.factory, this.context, filePath);
        } else {
            commandReader = args.length == 1 && "-simple".equals(args[0]) ? (System.console() != null ? new ConsoleShellCommandReader(this.factory, this.context) : new StdInShellCommandReader(this.factory, this.context)) : (System.console() != null ? new InteractiveShellCommandReader(this.factory, this.context) : new StdInShellCommandReader(this.factory, this.context));
        }
        this.context.setReader(commandReader);
        commandReader.open();
        return commandReader;
    }

    public void shutdown() {
        System.out.print(Messages.i18n.format("Shell.SHUTTING_DOWN", new Object[0]));
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.context.destroy();
        System.out.println(Messages.i18n.format("Shell.DONE", new Object[0]));
    }

    private void displayWelcomeMessage() {
        System.out.println("**********************************************************************\n           _____       ______  ___ ___  ________  \n          /  ___|      | ___ \\/ _ \\|  \\/  | ___ \\ \n          \\ `--. ______| |_/ / /_\\ \\ .  . | |_/ / \n           `--. \\______|    /|  _  | |\\/| |  __/  \n          /\\__/ /      | |\\ \\| | | | |  | | |     \n          \\____/       \\_| \\_\\_| |_|_|  |_|_|     \n                                                  \n  JBoss S-RAMP Kurt Stam and Eric Wittmann, Licensed under the\n  Apache License, V2.0, Copyright 2012\n  Locale: " + Locale.getDefault().toString().trim() + "\n" + "**********************************************************************");
    }
}

