/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.atom.archive.SrampArchiveEntry;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.api.InvalidCommandArgumentException;
import org.overlord.sramp.shell.api.ShellContext;
import org.overlord.sramp.shell.i18n.Messages;

public class UpdateEntryArchiveCommand
extends BuiltInShellCommand {
    public boolean execute() throws Exception {
        String archivePathArg = this.requiredArgument(0, Messages.i18n.format("InvalidArgMsg.EntryPath", new Object[0]));
        String subCommandArg = this.requiredArgument(1, Messages.i18n.format("UpdateEntry.InvalidArgMsg.SubCommand", new Object[0]));
        QName varName = new QName("archive", "active-archive");
        SrampArchive archive = (SrampArchive)this.getContext().getVariable(varName);
        if (archive == null) {
            this.print(Messages.i18n.format("NO_ARCHIVE_OPEN", new Object[0]), new Object[0]);
            return false;
        }
        if (!archive.containsEntry(archivePathArg)) {
            throw new InvalidCommandArgumentException(0, Messages.i18n.format("UpdateEntry.EntryNotFound", new Object[]{archivePathArg}));
        }
        if ("setContent".equals(subCommandArg)) {
            this.executeSetContent(archive, archivePathArg, this.getContext());
        }
        if ("setProperty".equals(subCommandArg)) {
            this.executeSetProperty(archive, archivePathArg, this.getContext());
        }
        if ("setRelationship".equals(subCommandArg)) {
            this.executeSetRelationship(archive, archivePathArg, this.getContext());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSetContent(SrampArchive archive, String entryPath, ShellContext context) throws Exception {
        String pathToContentArg = this.requiredArgument(2, Messages.i18n.format("UpdateEntry.InvalidArgMsg.MissingPath", new Object[0]));
        File file = new File(pathToContentArg);
        if (!file.isFile()) {
            throw new InvalidCommandArgumentException(2, Messages.i18n.format("UpdateEntry.FileNotFound", new Object[]{pathToContentArg}));
        }
        FileInputStream contentStream = null;
        try {
            contentStream = FileUtils.openInputStream((File)file);
            SrampArchiveEntry entry = archive.getEntry(entryPath);
            archive.updateEntry(entry, (InputStream)contentStream);
            this.print(Messages.i18n.format("UpdateEntry.SuccessMsg", new Object[0]), new Object[0]);
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
    }

    private void executeSetProperty(SrampArchive archive, String entryPath, ShellContext context) throws Exception {
        String propNameArg = this.requiredArgument(2, Messages.i18n.format("UpdateEntry.InvalidArgMsg.PropertyName", new Object[0]));
        String propValArg = this.requiredArgument(3, Messages.i18n.format("UpdateEntry.InvalidArgMsg.PropertyValue", new Object[0]));
        SrampArchiveEntry entry = archive.getEntry(entryPath);
        BaseArtifactType metaData = entry.getMetaData();
        if ("name".equals(propNameArg)) {
            metaData.setName(propValArg);
        } else if ("description".equals(propNameArg)) {
            metaData.setDescription(propValArg);
        } else if ("version".equals(propNameArg)) {
            metaData.setVersion(propValArg);
        } else if ("createdBy".equals(propNameArg)) {
            metaData.setCreatedBy(propValArg);
        } else if ("lastModifiedBy".equals(propNameArg)) {
            metaData.setLastModifiedBy(propValArg);
        } else if ("uuid".equals(propNameArg)) {
            metaData.setUuid(propValArg);
        } else if ("createdTimestamp".equals(propNameArg) || "lastModifiedTimestamp".equals(propNameArg)) {
            // empty if block
        }
        SrampModelUtils.setCustomProperty((BaseArtifactType)metaData, (String)propNameArg, (String)propValArg);
        archive.updateEntry(entry, null);
        this.print(Messages.i18n.format("UpdateEntry.MetaDataSuccessMsg", new Object[0]), new Object[0]);
    }

    private void executeSetRelationship(SrampArchive archive, String entryPath, ShellContext context) throws Exception {
        throw new InvalidCommandArgumentException(0, Messages.i18n.format("UpdateEntry.NotYetImplemented.Relationships", new Object[0]));
    }
}

