/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.maven;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.atom.archive.expand.ZipToSrampArchive;
import org.overlord.sramp.atom.archive.expand.registry.ZipToSrampArchiveRegistry;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.ArtifactTypeEnum;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.common.visitors.ArtifactVisitor;
import org.overlord.sramp.common.visitors.ArtifactVisitorHelper;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.i18n.Messages;
import org.overlord.sramp.shell.util.FileNameCompleter;
import org.overlord.sramp.shell.util.PrintArtifactMetaDataVisitor;

public class DeployCommand
extends BuiltInShellCommand {
    public boolean execute() throws Exception {
        String filePathArg = this.requiredArgument(0, Messages.i18n.format("DeployCommand.InvalidArgMsg.LocalFile", new Object[0]));
        String gavArg = this.requiredArgument(1, Messages.i18n.format("DeployCommand.InvalidArgMsg.GAVInfo", new Object[0]));
        String artifactTypeArg = this.optionalArgument(2);
        QName clientVarName = new QName("s-ramp", "client");
        SrampAtomApiClient client = (SrampAtomApiClient)this.getContext().getVariable(clientVarName);
        if (client == null) {
            this.print(Messages.i18n.format("MissingSRAMPConnection", new Object[0]), new Object[0]);
            return false;
        }
        File file = new File(filePathArg);
        if (!file.isFile()) {
            this.print(Messages.i18n.format("DeployCommand.FileNotFound", new Object[]{filePathArg}), new Object[0]);
            return false;
        }
        FileInputStream content = null;
        ZipToSrampArchive expander = null;
        SrampArchive archive = null;
        try {
            ArtifactType artifactType = null;
            if (artifactTypeArg != null) {
                artifactType = ArtifactType.valueOf((String)artifactTypeArg);
                if (artifactType.isExtendedType()) {
                    artifactType = ArtifactType.ExtendedDocument((String)artifactType.getExtendedType());
                }
            } else {
                artifactType = this.determineArtifactType(file);
            }
            content = FileUtils.openInputStream((File)file);
            BaseArtifactType artifact = client.uploadArtifact(artifactType, (InputStream)content, file.getName());
            IOUtils.closeQuietly((InputStream)content);
            MavenMetaData mmd = new MavenMetaData(gavArg, file);
            String artifactName = mmd.artifactId + '-' + mmd.version;
            String pomName = mmd.artifactId + '-' + mmd.version + ".pom";
            SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.groupId", (String)mmd.groupId);
            SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.artifactId", (String)mmd.artifactId);
            SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.version", (String)mmd.version);
            SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.hash.md5", (String)mmd.md5);
            SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.hash.sha1", (String)mmd.sha1);
            if (mmd.classifier != null) {
                SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.classifier", (String)mmd.classifier);
                artifactName = artifactName + '-' + mmd.classifier;
            }
            if (mmd.type != null) {
                SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.type", (String)mmd.type);
                artifactName = artifactName + '.' + mmd.type;
            }
            artifact.setName(artifactName);
            client.updateArtifactMetaData(artifact);
            expander = ZipToSrampArchiveRegistry.createExpander((ArtifactType)artifactType, (File)file);
            if (expander != null) {
                expander.setContextParam("parent.uuid", (Object)artifact.getUuid());
                archive = expander.createSrampArchive();
                client.uploadBatch(archive);
            }
            String pom = this.generatePom(mmd);
            ByteArrayInputStream pomContent = new ByteArrayInputStream(pom.getBytes("UTF-8"));
            BaseArtifactType pomArtifact = ArtifactType.ExtendedDocument((String)"MavenPom").newArtifactInstance();
            pomArtifact.setName(pomName);
            SrampModelUtils.setCustomProperty((BaseArtifactType)pomArtifact, (String)"maven.type", (String)"pom");
            SrampModelUtils.setCustomProperty((BaseArtifactType)pomArtifact, (String)"maven.hash.md5", (String)DigestUtils.md5Hex((String)pom));
            SrampModelUtils.setCustomProperty((BaseArtifactType)pomArtifact, (String)"maven.hash.sha1", (String)DigestUtils.shaHex((String)pom));
            client.uploadArtifact(pomArtifact, (InputStream)pomContent);
            QName artifactVarName = new QName("s-ramp", "artifact");
            this.getContext().setVariable(artifactVarName, (Object)artifact);
            this.print(Messages.i18n.format("DeployCommand.Success", new Object[0]), new Object[0]);
            PrintArtifactMetaDataVisitor visitor = new PrintArtifactMetaDataVisitor();
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
        }
        catch (Exception e) {
            this.print(Messages.i18n.format("DeployCommand.Failure", new Object[0]), new Object[0]);
            this.print("\t" + e.getMessage(), new Object[0]);
            IOUtils.closeQuietly((InputStream)content);
            return false;
        }
        return true;
    }

    private String generatePom(MavenMetaData mmd) {
        StringBuilder builder = new StringBuilder();
        builder.append("<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n");
        builder.append("  xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\r\n");
        builder.append("  <modelVersion>4.0.0</modelVersion>\r\n");
        builder.append("  <groupId>" + mmd.groupId + "</groupId>\r\n");
        builder.append("  <artifactId>" + mmd.artifactId + "</artifactId>\r\n");
        builder.append("  <version>" + mmd.version + "</version>\r\n");
        if (mmd.type != null) {
            builder.append("  <packaging>" + mmd.type + "</packaging>\r\n");
        }
        if (mmd.classifier != null) {
            builder.append("  <classifier>" + mmd.classifier + "</classifier>\r\n");
        }
        builder.append("</project>");
        return builder.toString();
    }

    private ArtifactType determineArtifactType(File file) {
        ArtifactType type = null;
        String extension = FilenameUtils.getExtension((String)file.getName());
        type = "jar".equals(extension) ? ArtifactType.ExtendedDocument((String)"JavaArchive") : ("war".equals(extension) ? ArtifactType.ExtendedDocument((String)"JavaWebApplication") : ("ear".equals(extension) ? ArtifactType.ExtendedDocument((String)"JavaEnterpriseApplication") : ArtifactType.Document()));
        return type;
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        if (this.getArguments().isEmpty()) {
            if (lastArgument == null) {
                lastArgument = "";
            }
            FileNameCompleter delegate = new FileNameCompleter();
            return delegate.complete(lastArgument, lastArgument.length(), candidates);
        }
        if (this.getArguments().size() == 1) {
            return -1;
        }
        if (this.getArguments().size() == 2) {
            for (ArtifactTypeEnum t : ArtifactTypeEnum.values()) {
                String candidate = t.getType();
                if (lastArgument != null && !candidate.startsWith(lastArgument)) continue;
                candidates.add(candidate);
            }
            return 0;
        }
        return -1;
    }

    private static final class MavenMetaData {
        public String groupId;
        public String artifactId;
        public String version;
        public String type;
        public String classifier;
        public String md5;
        public String sha1;

        public MavenMetaData(String gavArg, File file) throws Exception {
            String[] split = gavArg.split(":");
            if (split.length < 3) {
                throw new Exception(Messages.i18n.format("DeployCommand.InvalidArgMsg.GavFormat", new Object[0]));
            }
            this.groupId = split[0];
            this.artifactId = split[1];
            this.version = split[2];
            if (split.length >= 4) {
                this.type = split[3];
            }
            if (split.length >= 5) {
                this.classifier = split[5];
            }
            FileInputStream is = new FileInputStream(file);
            this.md5 = DigestUtils.md5Hex((InputStream)is);
            IOUtils.closeQuietly((InputStream)is);
            is = new FileInputStream(file);
            this.sha1 = DigestUtils.shaHex((InputStream)is);
            IOUtils.closeQuietly((InputStream)is);
        }
    }
}

