/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.ontology;

import java.util.List;
import javax.xml.namespace.QName;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.ontology.OntologySummary;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.i18n.Messages;

public class ListOntologiesCommand
extends BuiltInShellCommand {
    public boolean execute() throws Exception {
        QName clientVarName = new QName("s-ramp", "client");
        QName feedVarName = new QName("ontology", "feed");
        SrampAtomApiClient client = (SrampAtomApiClient)this.getContext().getVariable(clientVarName);
        if (client == null) {
            this.print(Messages.i18n.format("MissingSRAMPConnection", new Object[0]), new Object[0]);
            return false;
        }
        try {
            List ontologies = client.getOntologies();
            this.print(Messages.i18n.format("ListOntologies.Summary", new Object[]{ontologies.size()}), new Object[0]);
            this.print("  Idx  " + Messages.i18n.format("ListOntologies.Base", new Object[0]), new Object[0]);
            this.print("  ---  ----", new Object[0]);
            int idx = 1;
            for (OntologySummary ontology : ontologies) {
                String base = ontology.getBase();
                this.print("  %1$3d  %2$s", new Object[]{idx++, base});
            }
            this.getContext().setVariable(feedVarName, (Object)ontologies);
        }
        catch (Exception e) {
            this.print(Messages.i18n.format("ListOntologies.Failed", new Object[0]), new Object[0]);
            this.print("\t" + e.getMessage(), new Object[0]);
            return false;
        }
        return true;
    }
}

