/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.util;

import java.util.List;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DerivedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.NamedWsdlDerivedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Property;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Relationship;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Target;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XmlDocument;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.visitors.HierarchicalArtifactVisitorAdapter;
import org.overlord.sramp.shell.i18n.Messages;

public class PrintArtifactMetaDataVisitor
extends HierarchicalArtifactVisitorAdapter {
    protected void visitBase(BaseArtifactType artifact) {
        ArtifactType artifactType = ArtifactType.valueOf((BaseArtifactType)artifact);
        System.out.println(Messages.i18n.format("PrintArtifact.CoreHeading", new Object[0]));
        if (artifactType.isExtendedType()) {
            PrintArtifactMetaDataVisitor.printProperty(Messages.i18n.format("PrintArtifact.Type", new Object[0]), artifactType.getExtendedType());
        } else {
            PrintArtifactMetaDataVisitor.printProperty(Messages.i18n.format("PrintArtifact.Type", new Object[0]), artifactType.getArtifactType().getType());
        }
        PrintArtifactMetaDataVisitor.printProperty(Messages.i18n.format("PrintArtifact.Model", new Object[0]), artifactType.getArtifactType().getModel());
        PrintArtifactMetaDataVisitor.printProperty(Messages.i18n.format("PrintArtifact.UUID", new Object[0]), artifact.getUuid());
        PrintArtifactMetaDataVisitor.printProperty(Messages.i18n.format("PrintArtifact.Name", new Object[0]), artifact.getName());
        PrintArtifactMetaDataVisitor.printProperty(Messages.i18n.format("PrintArtifact.Version", new Object[0]), artifact.getVersion());
        PrintArtifactMetaDataVisitor.printProperty(Messages.i18n.format("PrintArtifact.Derived", new Object[0]), String.valueOf(artifactType.isDerived()));
        PrintArtifactMetaDataVisitor.printProperty(Messages.i18n.format("PrintArtifact.CreatedBy", new Object[0]), artifact.getCreatedBy());
        if (artifact.getCreatedTimestamp() != null) {
            PrintArtifactMetaDataVisitor.printProperty(Messages.i18n.format("PrintArtifact.CreatedOn", new Object[0]), artifact.getCreatedTimestamp().toXMLFormat());
        }
        PrintArtifactMetaDataVisitor.printProperty(Messages.i18n.format("PrintArtifact.ModifiedBy", new Object[0]), artifact.getLastModifiedBy());
        if (artifact.getLastModifiedTimestamp() != null) {
            PrintArtifactMetaDataVisitor.printProperty(Messages.i18n.format("PrintArtifact.ModifiedOn", new Object[0]), artifact.getLastModifiedTimestamp().toXMLFormat());
        }
        if (artifact.getDescription() != null) {
            System.out.println(Messages.i18n.format("PrintArtifact.DescriptionHeading", new Object[0]));
            System.out.println(artifact.getDescription());
        }
        if (artifact.getClassifiedBy().size() > 0) {
            System.out.println(Messages.i18n.format("PrintArtifact.ClassifiersHeading", new Object[0]));
            for (String classification : artifact.getClassifiedBy()) {
                PrintArtifactMetaDataVisitor.printProperty(Messages.i18n.format("PrintArtifact.ClassifiedBy", new Object[0]), classification);
            }
        }
        if (artifact.getProperty().size() > 0) {
            System.out.println(Messages.i18n.format("PrintArtifact.CustomPropsHeading", new Object[0]));
            for (Property property : artifact.getProperty()) {
                PrintArtifactMetaDataVisitor.printProperty(property.getPropertyName(), property.getPropertyValue());
            }
        }
        if (artifact.getRelationship().size() > 0) {
            System.out.println(Messages.i18n.format("PrintArtifact.GenericRelationshipsHeading", new Object[0]));
            for (Relationship relationship : artifact.getRelationship()) {
                List targets = relationship.getRelationshipTarget();
                PrintArtifactMetaDataVisitor.printRelationship(relationship.getRelationshipType(), targets);
            }
        }
    }

    protected void visitDerived(DerivedArtifactType artifact) {
        System.out.println(Messages.i18n.format("PrintArtifact.DerivedArtifactInfoHeading", new Object[0]));
        DocumentArtifactTarget relatedDocument = artifact.getRelatedDocument();
        PrintArtifactMetaDataVisitor.printRelationship(Messages.i18n.format("PrintArtifact.RelatedDoc", new Object[0]), (Target)relatedDocument);
    }

    protected void visitDocument(DocumentArtifactType artifact) {
        System.out.println(Messages.i18n.format("PrintArtifact.DocumentInfoHeading", new Object[0]));
        PrintArtifactMetaDataVisitor.printProperty(Messages.i18n.format("PrintArtifact.ContentType", new Object[0]), artifact.getContentType());
        PrintArtifactMetaDataVisitor.printProperty(Messages.i18n.format("PrintArtifact.ContentSize", new Object[0]), String.valueOf(artifact.getContentSize()));
    }

    protected void visitXmlDocument(XmlDocument artifact) {
        System.out.println(Messages.i18n.format("PrintArtifact.XmlDocumentHeading", new Object[0]));
        PrintArtifactMetaDataVisitor.printProperty(Messages.i18n.format("PrintArtifact.ContentEncoding", new Object[0]), artifact.getContentEncoding());
    }

    protected void visitNamedWsdlDerived(NamedWsdlDerivedArtifactType artifact) {
        System.out.println(Messages.i18n.format("PrintArtifact.NamedWsdlHeading", new Object[0]));
        PrintArtifactMetaDataVisitor.printProperty(Messages.i18n.format("PrintArtifact.NCName", new Object[0]), artifact.getNCName());
    }

    private static void printProperty(String propertyName, String propertyValue) {
        if (propertyValue != null) {
            System.out.printf("  %1$s: %2$s\n", propertyName, propertyValue);
        }
    }

    private static void printRelationship(String name, Target target) {
        String targetStr = target.getValue();
        PrintArtifactMetaDataVisitor.printProperty(name, targetStr);
    }

    private static void printRelationship(String name, List<? extends Target> targets) {
        String targetStr = "";
        boolean first = true;
        for (Target target : targets) {
            if (!first) {
                targetStr = targetStr + ", ";
            } else {
                first = false;
            }
            targetStr = targetStr + target.getValue();
        }
        PrintArtifactMetaDataVisitor.printProperty(name, targetStr);
    }
}

