/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.overlord.sramp.shell.AbstractShellCommandReader;
import org.overlord.sramp.shell.ConsoleShellCommandReader;
import org.overlord.sramp.shell.FileShellCommandReader;
import org.overlord.sramp.shell.InteractiveShellCommandReader;
import org.overlord.sramp.shell.ShellArgumentException;
import org.overlord.sramp.shell.ShellCommandFactory;
import org.overlord.sramp.shell.ShellCommandReader;
import org.overlord.sramp.shell.ShellContextImpl;
import org.overlord.sramp.shell.StdInShellCommandReader;
import org.overlord.sramp.shell.i18n.Messages;

public class ShellCommandReaderFactory {
    public static ShellCommandReader createCommandReader(String[] args, ShellCommandFactory factory, ShellContextImpl context) throws IOException {
        AbstractShellCommandReader commandReader = null;
        if (args.length > 0) {
            HashMap<String, String> properties = new HashMap();
            if (args[0].equals("-simple")) {
                properties = ShellCommandReaderFactory.getProperties(1, args);
                commandReader = System.console() != null ? new ConsoleShellCommandReader(factory, context, properties) : new StdInShellCommandReader(factory, context, (Map<String, String>)properties);
            } else if (args.length >= 2 && "-f".equals(args[0])) {
                String filePath = args[1];
                properties = ShellCommandReaderFactory.getProperties(2, args);
                commandReader = new FileShellCommandReader(factory, context, filePath, properties);
            }
        } else {
            commandReader = System.console() != null ? new InteractiveShellCommandReader(factory, context) : new StdInShellCommandReader(factory, context);
        }
        return commandReader;
    }

    private static Map<String, String> getProperties(int index, String[] args) {
        HashMap<String, String> properties = new HashMap<String, String>();
        boolean propertyFileArg = false;
        for (int i = index; i < args.length; ++i) {
            String argument = args[i];
            if (!propertyFileArg) {
                if (argument.startsWith("-D")) {
                    if (argument.contains("=")) {
                        String key = argument.substring(2, argument.indexOf("="));
                        String value = argument.substring(argument.indexOf("=") + 1);
                        properties.put(key, value);
                        continue;
                    }
                    System.out.println("Error Argument: " + argument + " index: " + i + " " + Messages.i18n.format("InvalidArgMsg.property.not.correct.format", new Object[0]));
                    continue;
                }
                if (!argument.equals("-propertiesFile")) continue;
                propertyFileArg = true;
                continue;
            }
            propertyFileArg = false;
            try {
                properties.putAll(ShellCommandReaderFactory.getPropertiesFromFile(argument, index));
                continue;
            }
            catch (ShellArgumentException sae) {
                System.out.println("Error Argument: " + argument + " index: " + i + " " + sae.getMessage());
            }
        }
        return properties;
    }

    private static Map<String, String> getPropertiesFromFile(String filePath, int index) throws ShellArgumentException {
        HashMap<String, String> properties = new HashMap<String, String>();
        File f = new File(filePath);
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(f));
        }
        catch (FileNotFoundException e) {
            throw new ShellArgumentException(index, Messages.i18n.format("InvalidArgMsg.propertiesFile.not.exist", new Object[0]));
        }
        catch (IOException e) {
            throw new ShellArgumentException(index, Messages.i18n.format("InvalidArgMsg.propertiesFile.error.reading", new Object[0]) + ": " + e.getMessage());
        }
        for (String name : props.stringPropertyNames()) {
            properties.put(name, props.getProperty(name));
        }
        return properties;
    }
}

