/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.jboss.aesh.complete.CompleteOperation;
import org.jboss.aesh.complete.Completion;
import org.overlord.sramp.shell.ShellCommandFactory;
import org.overlord.sramp.shell.api.Arguments;
import org.overlord.sramp.shell.api.InvalidCommandArgumentException;
import org.overlord.sramp.shell.api.ShellCommand;
import org.overlord.sramp.shell.api.ShellContext;
import org.overlord.sramp.shell.commands.CommandNotFoundCommand;

public class TabCompleter
implements Completion {
    private final ShellCommandFactory factory;
    private final ShellContext context;

    public TabCompleter(ShellCommandFactory factory, ShellContext context) {
        this.factory = factory;
        this.context = context;
    }

    public void complete(CompleteOperation completeOperation) {
        String commonPartCandidates;
        String buffer = completeOperation.getBuffer();
        if (buffer.trim().length() == 0) {
            for (String ns : this.factory.getNamespaces()) {
                completeOperation.addCompletionCandidate(ns + ":");
            }
        } else if (!buffer.contains(":") && !buffer.contains(" ")) {
            for (String ns : this.factory.getNamespaces()) {
                if (!ns.startsWith(buffer)) continue;
                completeOperation.addCompletionCandidate(ns + ":");
            }
            if (completeOperation.getCompletionCandidates().isEmpty()) {
                for (QName cmdName : this.factory.getCommandNames("s-ramp")) {
                    if (!cmdName.getLocalPart().startsWith(buffer)) continue;
                    completeOperation.addCompletionCandidate(cmdName.getLocalPart());
                }
            } else if (completeOperation.getCompletionCandidates().size() == 1) {
                completeOperation.doAppendSeparator(false);
            }
        } else if (buffer.endsWith(":") && !buffer.contains(" ")) {
            String ns = buffer.substring(0, buffer.length() - 1);
            for (QName cmdName : this.factory.getCommandNames(ns)) {
                completeOperation.addCompletionCandidate(cmdName.getLocalPart() + " ");
            }
            if (completeOperation.getCompletionCandidates().size() == 1) {
                completeOperation.setOffset(completeOperation.getCursor());
            }
        } else if (buffer.contains(":") && !buffer.endsWith(":") && !buffer.contains(" ")) {
            String ns;
            int colonIdx = buffer.indexOf(58);
            ns = buffer.substring(0, colonIdx);
            String name = buffer.substring(colonIdx + 1);
            for (QName cmdName : this.factory.getCommandNames(ns)) {
                if (!cmdName.getLocalPart().startsWith(name)) continue;
                completeOperation.addCompletionCandidate(cmdName.getNamespaceURI() + ":" + cmdName.getLocalPart());
            }
        } else {
            Arguments arguments = null;
            try {
                arguments = new Arguments(buffer, true);
            }
            catch (InvalidCommandArgumentException e1) {
                // empty catch block
            }
            QName commandName = arguments.removeCommandName();
            String lastArgument = null;
            if (arguments.size() > 0 && !buffer.endsWith(" ")) {
                lastArgument = (String)arguments.remove(arguments.size() - 1);
            }
            ShellCommand command = null;
            try {
                command = this.factory.createCommand(commandName);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (command != null && !(command instanceof CommandNotFoundCommand)) {
                command.setContext(this.context);
                command.setArguments(arguments);
                ArrayList list = new ArrayList();
                int tabCompletionResult = command.tabCompletion(lastArgument, list);
                if (!list.isEmpty()) {
                    if (list.size() == 1) {
                        if (buffer.endsWith(" ")) {
                            completeOperation.addCompletionCandidate(buffer + ((CharSequence)list.get(0)).toString().trim());
                        } else if (buffer.indexOf(" ") != -1) {
                            completeOperation.addCompletionCandidate(buffer.substring(0, buffer.lastIndexOf(" ")) + " " + ((CharSequence)list.get(0)).toString().trim());
                        } else {
                            completeOperation.addCompletionCandidate(buffer + " " + ((CharSequence)list.get(0)).toString().trim());
                        }
                    } else {
                        for (CharSequence sequence : list) {
                            completeOperation.addCompletionCandidate(sequence.toString());
                        }
                    }
                    if (tabCompletionResult == 100) {
                        completeOperation.doAppendSeparator(false);
                    }
                }
            }
        }
        if (StringUtils.isNotBlank((String)(commonPartCandidates = this.mergeCandidates(completeOperation.getCompletionCandidates(), buffer)))) {
            String tokenToCompare = "";
            tokenToCompare = buffer.contains(" ") ? buffer.substring(buffer.lastIndexOf(" ") + 1) : buffer;
            completeOperation.getCompletionCandidates().clear();
            if (StringUtils.isBlank((String)tokenToCompare) || commonPartCandidates.startsWith(tokenToCompare)) {
                if (buffer.contains(" ")) {
                    completeOperation.addCompletionCandidate(buffer.substring(0, buffer.lastIndexOf(" ")).trim() + " " + commonPartCandidates);
                } else {
                    completeOperation.addCompletionCandidate(commonPartCandidates);
                }
            } else {
                completeOperation.addCompletionCandidate(commonPartCandidates);
            }
            completeOperation.doAppendSeparator(false);
        }
    }

    private String mergeCandidates(List<String> completionCandidates, String buffer) {
        if (completionCandidates.size() > 1) {
            int indexOfDifference = StringUtils.indexOfDifference((String[])completionCandidates.toArray(new String[completionCandidates.size()]));
            if (indexOfDifference == -1) {
                return completionCandidates.get(0);
            }
            String partToCompare = "";
            String commonPart = completionCandidates.get(0).substring(0, indexOfDifference);
            partToCompare = commonPart.startsWith(buffer) ? buffer : buffer.substring(buffer.lastIndexOf(" ") + 1);
            if (partToCompare.length() != indexOfDifference) {
                return commonPart;
            }
        }
        return "";
    }
}

