/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.util;

import java.io.File;
import java.util.List;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.atom.archive.SrampArchiveEntry;
import org.overlord.sramp.atom.archive.SrampArchiveException;

public class FileEntryPathCompleter {
    private final SrampArchive archive;

    public FileEntryPathCompleter(SrampArchive archive) {
        this.archive = archive;
    }

    public int complete(String buffer, int cursor, List<CharSequence> candidates) {
        if (this.archive != null) {
            try {
                for (SrampArchiveEntry entry : this.archive.getEntries()) {
                    if (!entry.getPath().startsWith(buffer)) continue;
                    if (entry.getPath().indexOf(File.separator, buffer.length()) != -1) {
                        candidates.add(entry.getPath().substring(0, entry.getPath().indexOf(File.separator, buffer.length()) + 1));
                        continue;
                    }
                    if (entry.getPath().equals(buffer)) continue;
                    candidates.add(entry.getPath());
                }
            }
            catch (SrampArchiveException e) {
                e.printStackTrace();
            }
        }
        if (candidates.size() == 1 && candidates.get(0).toString().endsWith(File.separator)) {
            return 100;
        }
        return -1;
    }
}

