/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.archive;

import java.io.File;
import javax.xml.namespace.QName;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.i18n.Messages;

public abstract class AbstractArchiveCommand
extends BuiltInShellCommand {
    protected SrampArchive archive;
    protected QName clientVarName = new QName("s-ramp", "client");
    protected SrampAtomApiClient client;
    protected QName varName = new QName("archive", "active-archive");

    public boolean validateArchivePath(String archivePath) {
        if (archivePath.endsWith(File.separator)) {
            this.print(Messages.i18n.format("Archive.Path.Arg.should.not.contain.slash.end", new Object[0]), new Object[0]);
            return false;
        }
        return true;
    }

    public boolean validateArchiveSession() {
        if (this.archive == null) {
            this.print(Messages.i18n.format("NO_ARCHIVE_OPEN", new Object[0]), new Object[0]);
            return false;
        }
        return true;
    }

    protected boolean validate(String ... args) throws Exception {
        return true;
    }

    public boolean initialize() throws Exception {
        if (this.getContext() != null) {
            if (this.getContext().getVariable(this.varName) != null) {
                this.archive = (SrampArchive)this.getContext().getVariable(this.varName);
            }
            if (this.getContext().getVariable(this.clientVarName) != null) {
                this.client = (SrampAtomApiClient)this.getContext().getVariable(this.clientVarName);
            }
        }
        return true;
    }
}

