/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.core;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.ArtifactTypeEnum;
import org.overlord.sramp.common.visitors.ArtifactVisitor;
import org.overlord.sramp.common.visitors.ArtifactVisitorHelper;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.i18n.Messages;
import org.overlord.sramp.shell.util.FileNameCompleter;
import org.overlord.sramp.shell.util.PrintArtifactMetaDataVisitor;

public class UploadArtifactCommand
extends BuiltInShellCommand {
    public boolean execute() throws Exception {
        String filePathArg = this.requiredArgument(0, Messages.i18n.format("Upload.InvalidArgMsg.LocalFile", new Object[0]));
        String artifactTypeArg = this.optionalArgument(1);
        QName clientVarName = new QName("s-ramp", "client");
        SrampAtomApiClient client = (SrampAtomApiClient)this.getContext().getVariable(clientVarName);
        if (client == null) {
            this.print(Messages.i18n.format("MissingSRAMPConnection", new Object[0]), new Object[0]);
            return false;
        }
        InputStream content = null;
        try {
            File file = new File(filePathArg);
            if (file.exists()) {
                content = FileUtils.openInputStream((File)file);
            } else {
                URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(filePathArg);
                if (url != null) {
                    this.print(Messages.i18n.format("Upload.InvalidArgMsg.LocalFile", new Object[0]), new Object[0]);
                    content = url.openStream();
                } else {
                    this.print(Messages.i18n.format("Upload.InvalidArgMsg.LocalFile", new Object[0]), new Object[0]);
                }
            }
            ArtifactType artifactType = null;
            if (artifactTypeArg != null && (artifactType = ArtifactType.valueOf((String)artifactTypeArg)).isExtendedType()) {
                artifactType = ArtifactType.ExtendedDocument((String)artifactType.getExtendedType());
            }
            BaseArtifactType artifact = client.uploadArtifact(artifactType, content, file.getName());
            IOUtils.closeQuietly((InputStream)content);
            QName artifactVarName = new QName("s-ramp", "artifact");
            this.getContext().setVariable(artifactVarName, (Object)artifact);
            this.print(Messages.i18n.format("Upload.Success", new Object[0]), new Object[0]);
            PrintArtifactMetaDataVisitor visitor = new PrintArtifactMetaDataVisitor();
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
        }
        catch (Exception e) {
            this.print(Messages.i18n.format("Upload.Failure", new Object[0]), new Object[0]);
            this.print("\t" + e.getMessage(), new Object[0]);
            IOUtils.closeQuietly((InputStream)content);
            return false;
        }
        return true;
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        if (this.getArguments().isEmpty()) {
            if (lastArgument == null) {
                lastArgument = "";
            }
            FileNameCompleter delegate = new FileNameCompleter();
            return delegate.complete(lastArgument, lastArgument.length(), candidates);
        }
        if (this.getArguments().size() == 1) {
            for (ArtifactTypeEnum t : ArtifactTypeEnum.values()) {
                String candidate = t.getType();
                if (lastArgument != null && !candidate.startsWith(lastArgument)) continue;
                candidates.add(candidate);
            }
            return 0;
        }
        return -1;
    }
}

