/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.client.views;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.place.shared.Place;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.List;
import org.overlord.sramp.ui.client.activities.IBrowseActivity;
import org.overlord.sramp.ui.client.places.AbstractPagedPlace;
import org.overlord.sramp.ui.client.places.BrowsePlace;
import org.overlord.sramp.ui.client.services.Services;
import org.overlord.sramp.ui.client.services.place.IPlaceService;
import org.overlord.sramp.ui.client.views.AbstractView;
import org.overlord.sramp.ui.client.views.IBrowseView;
import org.overlord.sramp.ui.client.widgets.ArtifactSummaryPanel;
import org.overlord.sramp.ui.client.widgets.DataTable;
import org.overlord.sramp.ui.client.widgets.DataTableWithPager;
import org.overlord.sramp.ui.client.widgets.PlaceFilterPanel;
import org.overlord.sramp.ui.shared.beans.ArtifactSummary;
import org.overlord.sramp.ui.shared.rsvcs.RemoteServiceException;
import org.overlord.sramp.ui.shared.types.ArtifactTypeFilter;

public class BrowseView
extends AbstractView<IBrowseActivity>
implements IBrowseView {
    private static final int DEFAULT_PAGE_SIZE = 20;
    private static final String DEFAULT_ORDER_BY = "name";
    private ArtifactDataTable artifacts;
    private PlaceFilterPanel<BrowsePlace> typeFilterPanel = new PlaceFilterPanel<BrowsePlace>(this.i18n().translate("views.browse.filter-panel.label", new Object[0])){

        @Override
        protected boolean matches(BrowsePlace currentPlace, BrowsePlace targetPlace) {
            String targetTypeFilter;
            String currentTypeFilter = currentPlace.getTypeFilter();
            if (currentTypeFilter == (targetTypeFilter = targetPlace.getTypeFilter())) {
                return true;
            }
            return currentTypeFilter != null && currentTypeFilter.equals(targetTypeFilter);
        }
    };
    private TextBox nameFilterBox;
    private ArtifactSummaryPanel summaryPanel;
    private BrowsePlace currentPlace;

    public BrowseView() {
        this.artifacts = this.createArtifactTable();
        this.nameFilterBox = new TextBox();
        this.nameFilterBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                BrowsePlace newPlace = BrowseView.this.currentPlace.clone();
                newPlace.setNameFilter(BrowseView.this.nameFilterBox.getValue());
                History.newItem((String)BrowseView.toHistoryToken(newPlace));
            }
        });
        this.summaryPanel = new ArtifactSummaryPanel();
        FlowPanel nameFilterPanel = new FlowPanel();
        nameFilterPanel.setStyleName("filterPanel");
        InlineLabel label = new InlineLabel("Filter by name:");
        label.setStyleName("label");
        nameFilterPanel.add((Widget)label);
        nameFilterPanel.add((Widget)this.nameFilterBox);
        VerticalPanel vpanel = new VerticalPanel();
        vpanel.add(this.typeFilterPanel);
        vpanel.add((Widget)nameFilterPanel);
        HorizontalPanel hpanel = new HorizontalPanel();
        hpanel.setWidth("100%");
        hpanel.add((Widget)vpanel);
        hpanel.add((Widget)this.artifacts);
        hpanel.add((Widget)this.summaryPanel);
        hpanel.setCellWidth((Widget)vpanel, "175px");
        hpanel.setCellWidth((Widget)this.summaryPanel, "300px");
        this.initWidget((Widget)hpanel);
    }

    private static String toHistoryToken(Place place) {
        if (place == null) {
            return "";
        }
        IPlaceService placeService = Services.getServices().getService(IPlaceService.class);
        return placeService.generatePlaceToken(place);
    }

    private void configureFilters(BrowsePlace currentPlace) {
        for (ArtifactTypeFilter filter : ArtifactTypeFilter.values()) {
            BrowsePlace p = currentPlace.clone();
            p.setPage(null);
            p.setTypeFilter(filter.getCode());
            this.typeFilterPanel.addFilterOption(this.i18n().translate(filter.getI18nKey(), new Object[0]), p);
        }
        this.typeFilterPanel.setCurrentPlace(currentPlace);
    }

    @Override
    public int getDefaultPageSize() {
        return 20;
    }

    @Override
    public String getDefaultOrderBy() {
        return DEFAULT_ORDER_BY;
    }

    private ArtifactDataTable createArtifactTable() {
        ArtifactDataTable table = new ArtifactDataTable();
        table.setWidth("100%");
        table.setEmptyTableMessage(this.i18n().translate("views.browse.artifacts.no-artifacts", new Object[0]));
        table.setLoadingMessage(this.i18n().translate("views.browse.artifacts.loading-artifacts", new Object[0]));
        final SingleSelectionModel selectionModel = new SingleSelectionModel();
        selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                ArtifactSummary artifact = (ArtifactSummary)selectionModel.getSelectedObject();
                if (artifact == null) {
                    BrowseView.this.summaryPanel.reset();
                } else {
                    BrowseView.this.summaryPanel.setValue(artifact);
                }
            }
        });
        table.setSelectionModel(selectionModel);
        return table;
    }

    @Override
    public void onQueryStarting(BrowsePlace currentPlace) {
        this.configureFilters(currentPlace);
        this.currentPlace = currentPlace;
        this.artifacts.reset();
        this.nameFilterBox.setValue((Object)currentPlace.getNameFilter());
    }

    @Override
    public void onQueryComplete(List<ArtifactSummary> artifacts, boolean hasMoreRows) {
        this.artifacts.setRowData(artifacts, this.currentPlace, this.getDefaultPageSize(), hasMoreRows);
    }

    @Override
    public void onQueryFailed(RemoteServiceException error) {
        this.artifacts.setRowData(null, null, -1, false);
        this.growl().growl(this.i18n().translate("views.browse.search-error.title", new Object[0]), this.i18n().translate("views.browse.search-error.message", new Object[0]), error);
    }

    private class ArtifactDataTable
    extends DataTableWithPager<ArtifactSummary> {
        @Override
        protected AbstractPagedPlace createPagerPlace(AbstractPagedPlace currentPlace) {
            BrowsePlace place = new BrowsePlace();
            place.setTypeFilter(((BrowsePlace)currentPlace).getTypeFilter());
            return place;
        }

        @Override
        protected void createColumns(DataTable<ArtifactSummary> table) {
            TextColumn<ArtifactSummary> name = new TextColumn<ArtifactSummary>(){

                public String getValue(ArtifactSummary artifact) {
                    return artifact.getName();
                }
            };
            name.setSortable(true);
            name.setDataStoreName(BrowseView.DEFAULT_ORDER_BY);
            table.addColumn((Column)name, BrowseView.this.i18n().translate("views.browse.table.name-column", new Object[0]));
            TextColumn<ArtifactSummary> type = new TextColumn<ArtifactSummary>(){

                public String getValue(ArtifactSummary artifact) {
                    return artifact.getType();
                }
            };
            type.setSortable(false);
            type.setDataStoreName("type");
            table.addColumn((Column)type, BrowseView.this.i18n().translate("views.browse.table.type-column", new Object[0]));
            TextColumn<ArtifactSummary> updatedOn = new TextColumn<ArtifactSummary>(){

                public String getValue(ArtifactSummary artifact) {
                    return BrowseView.this.i18n().formatDateTime(artifact.getUpdatedOn());
                }
            };
            updatedOn.setSortable(true);
            updatedOn.setDataStoreName("updatedOn");
            table.addColumn((Column)updatedOn, BrowseView.this.i18n().translate("views.browse.table.updatedOn-column", new Object[0]));
        }

        @Override
        protected String getDefaultOrderBy() {
            return BrowseView.DEFAULT_ORDER_BY;
        }
    }
}

