/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.client.services.i18n;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.Date;
import java.util.Map;
import org.overlord.sramp.ui.client.services.AbstractService;
import org.overlord.sramp.ui.client.services.IServiceLifecycleListener;
import org.overlord.sramp.ui.client.services.ServiceLifecycleContext;
import org.overlord.sramp.ui.client.services.i18n.ILocalizationService;
import org.overlord.sramp.ui.client.services.i18n.LocalizationDictionary;
import org.overlord.sramp.ui.shared.rsvcs.ILocalizationRemoteService;
import org.overlord.sramp.ui.shared.rsvcs.ILocalizationRemoteServiceAsync;

public class LocalizationService
extends AbstractService
implements ILocalizationService {
    private final ILocalizationRemoteServiceAsync localizationRemoteService = (ILocalizationRemoteServiceAsync)GWT.create(ILocalizationRemoteService.class);
    private LocalizationDictionary messages;
    private DateTimeFormat dateFormat;
    private DateTimeFormat dateTimeFormat;

    @Override
    public void start(ServiceLifecycleContext context, final IServiceLifecycleListener serviceListener) {
        this.localizationRemoteService.getMessages(new AsyncCallback<Map<String, String>>(){

            public void onSuccess(Map<String, String> result) {
                LocalizationService.this.initDictionary(result);
                serviceListener.onStarted();
            }

            public void onFailure(Throwable caught) {
                serviceListener.onError(caught);
            }
        });
    }

    protected void initDictionary(Map<String, String> messages) {
        this.messages = LocalizationDictionary.create(messages);
        String dFormat = this.messages.get("formats.date");
        String dtFormat = this.messages.get("formats.datetime");
        if (dFormat == null) {
            dFormat = "yyyy-MM-dd";
        }
        if (dtFormat == null) {
            dtFormat = "yyyy-MM-dd HH.mm.ss vvv";
        }
        this.dateFormat = DateTimeFormat.getFormat((String)dFormat);
        this.dateTimeFormat = DateTimeFormat.getFormat((String)dtFormat);
    }

    @Override
    public String translate(String key, Object ... args) {
        String val = this.messages.get(key);
        if (val == null) {
            return "**" + key + "**";
        }
        if (args == null || args.length == 0) {
            return val;
        }
        try {
            StringBuilder builder = new StringBuilder();
            builder.append(val);
            int argStartIdx = builder.indexOf("{");
            while (argStartIdx != -1) {
                int argEndIdx = builder.indexOf("}");
                String argSpec = builder.substring(argStartIdx + 1, argEndIdx);
                String[] split = argSpec.split(",");
                String argNumStr = split[0];
                int argNum = Integer.parseInt(argNumStr);
                Object argValue = args[argNum];
                String argType = "string";
                String argFormat = null;
                String formattedArgValue = null;
                if (split.length > 1) {
                    argType = split[1];
                }
                if (split.length > 2) {
                    argFormat = split[2];
                }
                formattedArgValue = "string".equals(argType) ? String.valueOf(argValue) : ("date".equals(argType) ? this.dateFormat.format((Date)argValue) : ("datetime".equals(argType) ? this.dateTimeFormat.format((Date)argValue) : "TBD:" + argFormat));
                builder.replace(argStartIdx, argEndIdx + 1, formattedArgValue);
                argStartIdx = builder.indexOf("{");
            }
            return builder.toString();
        }
        catch (Throwable t) {
            return "!!" + key + "!!";
        }
    }

    @Override
    public String formatDate(Date date) {
        return this.dateFormat.format(date);
    }

    @Override
    public String formatDateTime(Date dateTime) {
        return this.dateTimeFormat.format(dateTime);
    }
}

