/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.client.views;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.overlord.sramp.ui.client.activities.IArtifactActivity;
import org.overlord.sramp.ui.client.places.ArtifactPlace;
import org.overlord.sramp.ui.client.views.AbstractView;
import org.overlord.sramp.ui.client.views.IArtifactView;
import org.overlord.sramp.ui.client.widgets.PlaceHyperlink;
import org.overlord.sramp.ui.client.widgets.PleaseWait;
import org.overlord.sramp.ui.client.widgets.SimpleFormLayoutPanel;
import org.overlord.sramp.ui.client.widgets.UnorderedListPanel;
import org.overlord.sramp.ui.shared.beans.ArtifactDetails;
import org.overlord.sramp.ui.shared.beans.RelationshipDetails;
import org.overlord.sramp.ui.shared.rsvcs.RemoteServiceException;

public class ArtifactView
extends AbstractView<IArtifactActivity>
implements IArtifactView {
    private ArtifactPlace currentPlace;
    private FlowPanel main = new FlowPanel();

    public ArtifactView() {
        this.main.setStyleName("artifactView");
        this.initWidget((Widget)this.main);
    }

    @Override
    public void onArtifactLoading(ArtifactPlace currentPlace) {
        this.currentPlace = currentPlace;
        this.main.clear();
        this.main.add((Widget)new PleaseWait(this.i18n().translate("views.artifact.loading-message", new Object[0])));
    }

    @Override
    public void onArtifactLoaded(ArtifactDetails artifact) {
        this.main.clear();
        HorizontalPanel twoColContent = new HorizontalPanel();
        twoColContent.setStyleName("artifactView-content");
        twoColContent.setWidth("100%");
        this.main.add((Widget)twoColContent);
        VerticalPanel leftCol = new VerticalPanel();
        leftCol.setStyleName("leftCol");
        VerticalPanel rightCol = new VerticalPanel();
        rightCol.setStyleName("rightCol");
        leftCol.setWidth("100%");
        rightCol.setWidth("100%");
        twoColContent.add((Widget)leftCol);
        twoColContent.add((Widget)rightCol);
        twoColContent.setCellWidth((Widget)leftCol, "70%");
        twoColContent.setCellWidth((Widget)rightCol, "30%");
        twoColContent.setCellHorizontalAlignment((Widget)rightCol, HorizontalPanel.ALIGN_RIGHT);
        DisclosurePanel details = new DisclosurePanel(this.i18n().translate("views.artifact.details.label", new Object[0]));
        details.setStyleName("dpanel");
        details.setOpen(true);
        details.add(this.createDetailsForm(artifact));
        DisclosurePanel description = new DisclosurePanel(this.i18n().translate("views.artifact.description.label", new Object[0]));
        description.setStyleName("dpanel");
        description.setOpen(true);
        description.add(this.createDescriptionForm(artifact));
        DisclosurePanel relationships = new DisclosurePanel(this.i18n().translate("views.artifact.relationships.label", new Object[0]));
        relationships.setStyleName("dpanel");
        relationships.setOpen(true);
        relationships.add(this.createRelationshipsForm(artifact));
        leftCol.add((Widget)details);
        leftCol.add((Widget)description);
        leftCol.add((Widget)relationships);
        leftCol.setCellWidth((Widget)details, "100%");
        leftCol.setCellWidth((Widget)description, "100%");
        leftCol.setCellWidth((Widget)relationships, "100%");
        DisclosurePanel properties = new DisclosurePanel(this.i18n().translate("views.artifact.properties.label", new Object[0]));
        properties.setStyleName("dpanel");
        properties.setOpen(true);
        properties.add(this.createPropertiesForm(artifact));
        DisclosurePanel classifications = new DisclosurePanel(this.i18n().translate("views.artifact.classifications.label", new Object[0]));
        classifications.setStyleName("dpanel");
        classifications.setOpen(true);
        classifications.add(this.createClassificationsForm(artifact));
        DisclosurePanel links = new DisclosurePanel(this.i18n().translate("views.artifact.links.label", new Object[0]));
        links.setStyleName("dpanel");
        links.setOpen(true);
        links.add(this.createLinks(artifact));
        rightCol.add((Widget)properties);
        rightCol.add((Widget)classifications);
        rightCol.add((Widget)links);
        rightCol.setCellWidth((Widget)details, "100%");
    }

    private Widget createDescriptionForm(ArtifactDetails artifact) {
        FlowPanel wrapper = new FlowPanel();
        wrapper.setStyleName("dpanel-content");
        String artifactDesc = artifact.getDescription();
        if (artifactDesc == null || artifactDesc.trim().length() == 0) {
            artifactDesc = this.i18n().translate("views.artifact.no-description.message", new Object[0]);
        }
        Label descriptionWidget = new Label(artifactDesc);
        wrapper.add((Widget)descriptionWidget);
        return wrapper;
    }

    private Widget createRelationshipsForm(ArtifactDetails artifact) {
        FlowPanel wrapper = new FlowPanel();
        wrapper.setStyleName("dpanel-content");
        List<RelationshipDetails> relationships = artifact.getRelationships();
        if (relationships.isEmpty()) {
            wrapper.add((Widget)new InlineLabel(this.i18n().translate("views.artifact.no-relationships.message", new Object[0])));
        } else {
            SimpleFormLayoutPanel formLayoutPanel = new SimpleFormLayoutPanel();
            for (RelationshipDetails rd : relationships) {
                ArtifactPlace targetPlace = new ArtifactPlace(null, null, rd.getTargetUuid());
                PlaceHyperlink link = new PlaceHyperlink(rd.getTargetUuid(), targetPlace);
                formLayoutPanel.add(rd.getType(), (Widget)link);
            }
            wrapper.add((Widget)formLayoutPanel);
        }
        return wrapper;
    }

    private Widget createDetailsForm(ArtifactDetails artifact) {
        String createdOn = this.i18n().formatDateTime(artifact.getCreatedOn());
        String updatedOn = this.i18n().formatDateTime(artifact.getUpdatedOn());
        FlowPanel wrapper = new FlowPanel();
        wrapper.setStyleName("dpanel-content");
        SimpleFormLayoutPanel formLayoutPanel = new SimpleFormLayoutPanel();
        formLayoutPanel.add(this.i18n().translate("views.artifact.details.type-label", new Object[0]), (Widget)new InlineLabel(artifact.getType()));
        formLayoutPanel.add(this.i18n().translate("views.artifact.details.uuid-label", new Object[0]), (Widget)new InlineLabel(artifact.getUuid()));
        formLayoutPanel.add(this.i18n().translate("views.artifact.details.name-label", new Object[0]), (Widget)new InlineLabel(artifact.getName()));
        formLayoutPanel.add(this.i18n().translate("views.artifact.details.created-by-label", new Object[0]), (Widget)new InlineLabel(artifact.getCreatedBy()));
        formLayoutPanel.add(this.i18n().translate("views.artifact.details.created-on-label", new Object[0]), (Widget)new InlineLabel(createdOn));
        formLayoutPanel.add(this.i18n().translate("views.artifact.details.updated-by-label", new Object[0]), (Widget)new InlineLabel(artifact.getUpdatedBy()));
        formLayoutPanel.add(this.i18n().translate("views.artifact.details.updated-on-label", new Object[0]), (Widget)new InlineLabel(updatedOn));
        wrapper.add((Widget)formLayoutPanel);
        return wrapper;
    }

    private Widget createPropertiesForm(ArtifactDetails artifact) {
        Set<String> propertyNames = artifact.getPropertyNames();
        if (propertyNames.isEmpty()) {
            return new InlineLabel(this.i18n().translate("views.artifact.no-properties.message", new Object[0]));
        }
        propertyNames = new TreeSet<String>(propertyNames);
        FlowPanel wrapper = new FlowPanel();
        wrapper.setStyleName("dpanel-content");
        SimpleFormLayoutPanel formLayoutPanel = new SimpleFormLayoutPanel();
        for (String propertyName : propertyNames) {
            String propertyValue = artifact.getProperty(propertyName);
            formLayoutPanel.add(propertyName, (Widget)new InlineLabel(propertyValue));
        }
        wrapper.add((Widget)formLayoutPanel);
        return wrapper;
    }

    private Widget createClassificationsForm(ArtifactDetails artifact) {
        List<String> classifiedBy = artifact.getClassifiedBy();
        if (classifiedBy.isEmpty()) {
            return new InlineLabel(this.i18n().translate("views.artifact.no-classifications.message", new Object[0]));
        }
        TreeSet<String> orderedClassifications = new TreeSet<String>(classifiedBy);
        FlowPanel wrapper = new FlowPanel();
        wrapper.setStyleName("dpanel-content");
        UnorderedListPanel ulPanel = new UnorderedListPanel();
        for (String classification : orderedClassifications) {
            ulPanel.add((Widget)new Label(classification));
        }
        wrapper.add((Widget)ulPanel);
        return wrapper;
    }

    private Widget createLinks(ArtifactDetails artifact) {
        String url = GWT.getModuleBaseURL() + "services/artifactDownload";
        url = url + "?uuid=" + artifact.getUuid() + "&type=" + artifact.getType();
        FlowPanel wrapper = new FlowPanel();
        wrapper.setStyleName("dpanel-content");
        if (!artifact.isDerived()) {
            Anchor downloadLink = new Anchor(this.i18n().translate("views.artifact.links.download", new Object[0]), url);
            wrapper.add((Widget)downloadLink);
        }
        return wrapper;
    }

    @Override
    public void onArtifactLoadError(RemoteServiceException error) {
        this.main.clear();
        this.main.add((Widget)new Label(this.i18n().translate("views.artifact.load-error.label", this.currentPlace.getUuid())));
        this.growl().growl(this.i18n().translate("views.artifact.load-error.title", new Object[0]), this.i18n().translate("views.artifact.load-error.message", new Object[0]), error);
    }
}

