/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.client.widgets.dialogs;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.overlord.sramp.ui.client.services.growl.GrowlType;
import org.overlord.sramp.ui.client.widgets.PleaseWait;

public class GrowlDialog
extends DialogBox {
    private VerticalPanel main;
    private Label title;
    private Anchor closeButton;
    private Widget message;
    private GrowlType growlType;
    private boolean mouseIn = false;

    public GrowlDialog(String title, String message, GrowlType type) {
        super(false, false);
        this.title = new Label(title);
        this.title.setStyleName("growlTitle");
        this.closeButton = new Anchor("X");
        this.closeButton.setStyleName("close");
        HorizontalPanel titlePanel = new HorizontalPanel();
        titlePanel.setWidth("100%");
        titlePanel.setStyleName("growlTitleBar");
        titlePanel.add((Widget)this.title);
        titlePanel.add((Widget)this.closeButton);
        titlePanel.setCellHorizontalAlignment((Widget)this.closeButton, HasHorizontalAlignment.ALIGN_RIGHT);
        titlePanel.setCellVerticalAlignment((Widget)this.closeButton, HasVerticalAlignment.ALIGN_MIDDLE);
        this.main = new VerticalPanel();
        this.main.setStyleName("growlContent");
        this.main.add((Widget)titlePanel);
        this.setMessage(message, type);
        this.setWidget((Widget)this.main);
        this.setStyleName("growlDialog");
        this.closeButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                GrowlDialog.this.hide();
            }
        });
    }

    public void setTitle(String title) {
        this.title.setText(title);
    }

    public void setMessage(String message, GrowlType type) {
        if (type == GrowlType.notification || type == GrowlType.error) {
            this.setMessage((Widget)new InlineLabel(message), type);
        } else if (type == GrowlType.progress) {
            PleaseWait wait = new PleaseWait(message);
            this.setMessage((Widget)wait, type);
        }
    }

    public void setMessage(Widget message, GrowlType type) {
        if (this.message != null) {
            this.main.remove(this.message);
        }
        FlowPanel messageWrapper = new FlowPanel();
        messageWrapper.setStyleName("growlMessage");
        if (type == GrowlType.error) {
            HorizontalPanel errorPanel = new HorizontalPanel();
            InlineLabel icon = new InlineLabel(" ");
            icon.setStyleName("errorMessage");
            errorPanel.add((Widget)icon);
            errorPanel.add(message);
            errorPanel.setCellWidth((Widget)icon, "1%");
            errorPanel.setCellVerticalAlignment((Widget)icon, HasVerticalAlignment.ALIGN_MIDDLE);
            messageWrapper.add((Widget)errorPanel);
        } else {
            messageWrapper.add(message);
        }
        this.message = messageWrapper;
        this.main.add((Widget)messageWrapper);
        this.setGrowlType(type);
    }

    public void addCloseHandler(ClickHandler closeHandler) {
        this.closeButton.addClickHandler(closeHandler);
    }

    protected void onPreviewNativeEvent(Event.NativePreviewEvent event) {
        super.onPreviewNativeEvent(event);
        if (event.getTypeInt() == 64) {
            int x = event.getNativeEvent().getClientX();
            int y = event.getNativeEvent().getClientY();
            this.handleMouseMove(x, y);
        }
    }

    private void handleMouseMove(int clientX, int clientY) {
        if (this.isMouseInMe(clientX, clientY)) {
            if (!this.mouseIn) {
                this.mouseIn = true;
                this.onMouseIn();
            }
        } else if (this.mouseIn) {
            this.onMouseOut();
            this.mouseIn = false;
        }
    }

    private boolean isMouseInMe(int clientX, int clientY) {
        try {
            String bottomStyle = this.getElement().getStyle().getBottom();
            int bottom = new Integer(bottomStyle.split("px")[0]);
            bottom = Window.getClientHeight() - bottom;
            int top = bottom - 75;
            int left = Window.getClientWidth() - 400 - 5;
            int right = left + 400;
            return clientX >= left && clientX <= right && clientY >= top && clientY <= bottom;
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected void onMouseIn() {
        this.addStyleName("growlDialog-hover");
    }

    protected void onMouseOut() {
        this.removeStyleName("growlDialog-hover");
    }

    public GrowlType getGrowlType() {
        return this.growlType;
    }

    public void setGrowlType(GrowlType growlType) {
        this.growlType = growlType;
    }
}

