/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.client.widgets.dialogs;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.overlord.sramp.ui.client.events.OkCancelEvent;
import org.overlord.sramp.ui.client.services.Services;
import org.overlord.sramp.ui.client.services.i18n.ILocalizationService;
import org.overlord.sramp.ui.client.widgets.dialogs.DialogBox;

public class OkCancelDialogBox
extends DialogBox
implements OkCancelEvent.HasOkCancelHandlers {
    private FlowPanel contentWrapper;
    private Button okButton;
    private Button cancelButton;

    public OkCancelDialogBox(String title) {
        super(title);
        this.addStyleName("okCancelDialog");
        ILocalizationService i18n = Services.getServices().getService(ILocalizationService.class);
        this.contentWrapper = new FlowPanel();
        this.contentWrapper.setStyleName("okCancelDialogContent");
        this.okButton = new Button(i18n.translate("dialogs.ok", new Object[0]));
        this.cancelButton = new Button(i18n.translate("dialogs.cancel", new Object[0]));
        VerticalPanel vpanel = new VerticalPanel();
        vpanel.add((Widget)this.contentWrapper);
        HorizontalPanel buttonPanel = new HorizontalPanel();
        buttonPanel.setStyleName("buttonPanel");
        buttonPanel.addStyleName("okCancelButtonPanel");
        buttonPanel.add((Widget)this.okButton);
        buttonPanel.add((Widget)this.cancelButton);
        vpanel.add((Widget)buttonPanel);
        super.setWidget((Widget)vpanel);
        this.okButton.setStyleName("okButton");
        this.okButton.addStyleName("button");
        this.cancelButton.setStyleName("cancelButton");
        this.cancelButton.addStyleName("button");
        this.okButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                OkCancelDialogBox.this.fireOk();
            }
        });
        this.cancelButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                OkCancelDialogBox.this.fireCancel();
            }
        });
    }

    public void setWidget(Widget w) {
        this.contentWrapper.clear();
        this.contentWrapper.add(w);
    }

    protected void fireOk() {
        OkCancelEvent.fire(this, OkCancelEvent.OkCancelKind.ok);
    }

    protected void fireCancel() {
        this.hide();
        OkCancelEvent.fire(this, OkCancelEvent.OkCancelKind.cancel);
    }

    @Override
    public HandlerRegistration addOkCancelHandler(OkCancelEvent.Handler handler) {
        return this.addHandler(handler, OkCancelEvent.getType());
    }

    @Override
    protected void handleEscapePressed() {
        this.fireCancel();
    }

    protected ClickHandler createOkButtonClickHandler() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
            }
        };
    }

    protected ClickHandler createCancelButtonClickHandler() {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                OkCancelDialogBox.this.hide();
            }
        };
    }
}

