/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.client.jar.DefaultMetaDataFactory;
import org.overlord.sramp.client.jar.DiscoveredArtifact;
import org.overlord.sramp.client.jar.JarToSrampArchive;
import org.overlord.sramp.client.jar.MetaDataFactory;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.ui.server.api.SrampAtomApiClient;
import org.overlord.sramp.ui.server.util.ExceptionUtils;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;

public class ArtifactUploadServlet
extends HttpServlet {
    private static final long serialVersionUID = ArtifactUploadServlet.class.hashCode();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        HashMap<String, String> responseMap;
        block10: {
            block9: {
                if (!ServletFileUpload.isMultipartContent((HttpServletRequest)req)) break block9;
                DiskFileItemFactory factory = new DiskFileItemFactory();
                ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
                String artifactType = null;
                String fileName = null;
                InputStream artifactContent = null;
                try {
                    List items = upload.parseRequest(req);
                    for (FileItem item : items) {
                        if (item.isFormField()) {
                            if (!item.getFieldName().equals("artifactType")) continue;
                            artifactType = item.getString();
                            continue;
                        }
                        fileName = item.getName();
                        if (fileName != null) {
                            fileName = FilenameUtils.getName((String)fileName);
                        }
                        artifactContent = item.getInputStream();
                    }
                    responseMap = this.uploadArtifact(artifactType, fileName, artifactContent);
                }
                catch (SrampAtomException e) {
                    responseMap = new HashMap<String, String>();
                    responseMap.put("exception", "true");
                    responseMap.put("exception-message", e.getMessage());
                    responseMap.put("exception-stack", ExceptionUtils.getRootStackTrace(e));
                    IOUtils.closeQuietly((InputStream)artifactContent);
                }
                catch (Throwable e2) {
                    responseMap = new HashMap();
                    responseMap.put("exception", "true");
                    responseMap.put("exception-message", e2.getMessage());
                    responseMap.put("exception-stack", ExceptionUtils.getRootStackTrace(e2));
                    {
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(artifactContent);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)artifactContent);
                }
                IOUtils.closeQuietly(artifactContent);
                break block10;
            }
            response.sendError(415, "Request contents type is not supported by the servlet.");
            return;
        }
        this.writeToResponse(responseMap, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> uploadArtifact(String artifactType, String fileName, InputStream artifactContent) throws Exception {
        SrampAtomApiClient client = SrampAtomApiClient.getInstance();
        File tempFile = this.stashResourceContent(artifactContent);
        FileInputStream contentStream = null;
        String uuid = null;
        HashMap<String, String> responseParams = new HashMap<String, String>();
        try {
            try {
                contentStream = FileUtils.openInputStream((File)tempFile);
                ArtifactType at = ArtifactType.valueOf((String)artifactType);
                BaseArtifactType artifact = client.uploadArtifact(at, contentStream, fileName);
                responseParams.put("model", at.getArtifactType().getModel());
                responseParams.put("type", at.getArtifactType().getType());
                responseParams.put("uuid", artifact.getUuid());
                uuid = artifact.getUuid();
            }
            finally {
                IOUtils.closeQuietly((InputStream)contentStream);
            }
            if (this.isExpandable(fileName)) {
                JarToSrampArchive j2sramp = null;
                SrampArchive archive = null;
                try {
                    final String parentUUID = uuid;
                    j2sramp = new JarToSrampArchive(tempFile);
                    j2sramp.setMetaDataFactory((MetaDataFactory)new DefaultMetaDataFactory(){

                        public BaseArtifactType createMetaData(DiscoveredArtifact artifact) {
                            BaseArtifactType metaData = super.createMetaData(artifact);
                            SrampModelUtils.addGenericRelationship((BaseArtifactType)metaData, (String)"expandedFromDocument", (String)parentUUID);
                            return metaData;
                        }
                    });
                    archive = j2sramp.createSrampArchive();
                    client.uploadBatch(archive);
                }
                catch (Throwable throwable) {
                    SrampArchive.closeQuietly(archive);
                    JarToSrampArchive.closeQuietly(j2sramp);
                    throw throwable;
                }
                SrampArchive.closeQuietly((SrampArchive)archive);
                JarToSrampArchive.closeQuietly((JarToSrampArchive)j2sramp);
            }
            HashMap<String, String> hashMap = responseParams;
            return hashMap;
        }
        finally {
            FileUtils.deleteQuietly((File)tempFile);
        }
    }

    private File stashResourceContent(InputStream resourceInputStream) throws IOException {
        File resourceTempFile = null;
        FileOutputStream oStream = null;
        try {
            resourceTempFile = File.createTempFile("s-ramp-ui-upload", ".tmp");
            oStream = FileUtils.openOutputStream((File)resourceTempFile);
        }
        catch (IOException e) {
            try {
                FileUtils.deleteQuietly((File)resourceTempFile);
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.copy((InputStream)resourceInputStream, oStream);
                IOUtils.closeQuietly((InputStream)resourceInputStream);
                IOUtils.closeQuietly((OutputStream)oStream);
                throw throwable;
            }
        }
        IOUtils.copy((InputStream)resourceInputStream, (OutputStream)oStream);
        IOUtils.closeQuietly((InputStream)resourceInputStream);
        IOUtils.closeQuietly((OutputStream)oStream);
        return resourceTempFile;
    }

    private boolean isExpandable(String fileName) {
        String name = fileName.toLowerCase();
        return name.endsWith(".jar") || name.endsWith(".war") || name.endsWith(".ear");
    }

    private void writeToResponse(Map<String, String> responseMap, HttpServletResponse response) throws IOException {
        response.setContentType("application/json; charset=UTF8");
        StringBuilder builder = new StringBuilder();
        builder.append("({");
        boolean first = true;
        for (Map.Entry<String, String> entry : responseMap.entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append("\"");
            builder.append(key);
            builder.append("\" : \"");
            if (val != null) {
                val = val.replace("\"", "\\\"");
                val = val.replace("\n", "\\n");
                builder.append(val);
            }
            builder.append("\"");
        }
        builder.append("})");
        byte[] jsonData = builder.toString().getBytes("UTF-8");
        response.setContentLength(jsonData.length);
        response.getOutputStream().write(jsonData);
        response.getOutputStream().flush();
    }
}

