/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.wagon;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.security.MessageDigest;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.overlord.sramp.ArtifactType;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.wagon.models.MavenGavInfo;
import org.overlord.sramp.wagon.util.PomGenerator;
import org.s_ramp.xmlns._2010.s_ramp.Artifact;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;
import org.w3c.dom.Document;

@Component(role=Wagon.class, hint="sramp", instantiationStrategy="per-lookup")
public class SrampWagon
extends StreamWagon {
    @Requirement
    private Logger logger;

    protected void openConnectionInternal() throws ConnectionException, AuthenticationException {
    }

    public void closeConnection() throws ConnectionException {
    }

    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = inputData.getResource();
        this.logger.debug("Looking up resource: " + resource);
        try {
            MavenGavInfo gavInfo = MavenGavInfo.fromResource(resource);
            this.logger.debug("GAV: " + gavInfo);
            String endpoint = this.getRepository().getUrl().replace("sramp:", "http:").replace("sramps:", "https:");
            String artifactModel = gavInfo.getGroupId().substring(0, gavInfo.getGroupId().indexOf(46));
            String artifactType = gavInfo.getGroupId().substring(gavInfo.getGroupId().indexOf(46) + 1);
            String uuid = gavInfo.getArtifactId();
            SrampAtomApiClient client = new SrampAtomApiClient(endpoint);
            Entry fullEntry = client.getFullArtifactEntry(artifactModel, artifactType, uuid);
            if (fullEntry == null) {
                throw new ResourceDoesNotExistException("Could not find file: '" + resource + "'");
            }
            if ("pom".equals(gavInfo.getType())) {
                String serializedPom = this.generatePom(artifactType, fullEntry);
                inputData.setInputStream((InputStream)new ByteArrayInputStream(serializedPom.getBytes("UTF-8")));
                return;
            }
            if (artifactModel.equals(gavInfo.getType())) {
                InputStream artifactContent = client.getArtifactContent(artifactModel, artifactType, uuid);
                inputData.setInputStream(artifactContent);
                return;
            }
            if (gavInfo.getType().equals(artifactModel + ".sha1")) {
                InputStream artifactContent = client.getArtifactContent(artifactModel, artifactType, uuid);
                String sha1Hash = this.generateSHA1Hash(artifactContent);
                inputData.setInputStream((InputStream)new ByteArrayInputStream(sha1Hash.getBytes("UTF-8")));
                return;
            }
            if ("pom.sha1".equals(gavInfo.getType())) {
                String serializedPom = this.generatePom(artifactType, fullEntry);
                MessageDigest md = MessageDigest.getInstance("SHA1");
                md.update(serializedPom.getBytes("UTF-8"));
                byte[] mdbytes = md.digest();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < mdbytes.length; ++i) {
                    sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
                }
                inputData.setInputStream((InputStream)new ByteArrayInputStream(sb.toString().getBytes("UTF-8")));
                return;
            }
        }
        catch (ResourceDoesNotExistException e) {
            throw e;
        }
        catch (Throwable t) {
            this.logger.error(t.getMessage(), t);
        }
        throw new ResourceDoesNotExistException("Could not find file: '" + resource + "'");
    }

    private String generateSHA1Hash(InputStream artifactContent) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] buff = new byte[2048];
            int count = artifactContent.read(buff);
            while (count != -1) {
                md.update(buff, 0, count);
                count = artifactContent.read(buff);
            }
            byte[] mdbytes = md.digest();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mdbytes.length; ++i) {
                sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)artifactContent);
        }
    }

    private String generatePom(String artifactType, Entry fullEntry) throws Exception {
        ArtifactType type = ArtifactType.valueOf((String)artifactType);
        Artifact srampArty = (Artifact)fullEntry.getAnyOtherJAXBObject(Artifact.class, new Class[0]);
        BaseArtifactType artifact = type.unwrap(srampArty);
        PomGenerator pomGenerator = new PomGenerator();
        Document pomDoc = pomGenerator.generatePom(artifact, type);
        String serializedPom = this.serializeDocument(pomDoc);
        return serializedPom;
    }

    private String serializeDocument(Document document) {
        try {
            StringWriter writer = new StringWriter();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(document), new StreamResult(writer));
            return writer.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        System.out.println("fillOutputData");
    }
}

