/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.wagon.util;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.overlord.sramp.ArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PomGenerator {
    private static final String POM_NS = "http://maven.apache.org/POM/4.0.0";

    public Document generatePom(BaseArtifactType artifact, ArtifactType type) throws Exception {
        Document document = this.loadTemplate();
        String groupId = type.getModel() + "." + type.name();
        String artifactId = artifact.getUuid();
        String version = artifact.getVersion();
        String name = artifact.getName();
        String description = artifact.getDescription();
        String pomType = type.getModel();
        if (version == null) {
            version = "1.0";
        }
        if (name == null || name.trim().length() == 0) {
            name = artifactId;
        }
        this.setElementText(document, "groupId", groupId);
        this.setElementText(document, "artifactId", artifactId);
        this.setElementText(document, "version", version);
        this.setElementText(document, "name", name);
        this.setElementText(document, "description", description);
        this.setElementText(document, "type", pomType);
        return document;
    }

    private Document loadTemplate() throws Exception {
        InputStream templateIS = this.getClass().getResourceAsStream("pom.template");
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        dbFactory.setValidating(false);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(templateIS);
        return doc;
    }

    private void setElementText(Document document, String elementName, String value) {
        if (value == null) {
            return;
        }
        Element elem = (Element)document.getElementsByTagNameNS(POM_NS, elementName).item(0);
        elem.appendChild(document.createTextNode(value));
    }
}

