/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.wagon.models;

import junit.framework.Assert;
import org.apache.maven.wagon.resource.Resource;
import org.junit.Test;
import org.overlord.sramp.wagon.models.MavenGavInfo;

public class MavenGavInfoTest {
    private static final String[][] TEST_DATA = new String[][]{{"org/example/schema/my-schema/1.3/my-schema-1.3.xsd", "org.example.schema", "my-schema", "1.3", null, "xsd", "my-schema-1.3.xsd", "false", "false", null}, {"xsd/XsdDocument/29873-21983-2497822-1989/1.0/29873-21983-2497822-1989-1.0.pom", "xsd.XsdDocument", "29873-21983-2497822-1989", "1.0", null, "pom", "29873-21983-2497822-1989-1.0.pom", "false", "false", null}, {"org/apache/commons/commons-io/1.3.2/commons-io-1.3.2.jar", "org.apache.commons", "commons-io", "1.3.2", null, "jar", "commons-io-1.3.2.jar", "false", "false", null}, {"org/apache/commons/commons-io/1.3.2/commons-io-1.3.2.pom.sha1", "org.apache.commons", "commons-io", "1.3.2", null, "pom.sha1", "commons-io-1.3.2.pom.sha1", "true", "false", null}, {"org/apache/commons/commons-io/1.3.2/commons-io-1.3.2.jar.sha1", "org.apache.commons", "commons-io", "1.3.2", null, "jar.sha1", "commons-io-1.3.2.jar.sha1", "true", "false", null}, {"org/apache/commons/commons-io/1.3.2/commons-io-1.3.2-sources.jar", "org.apache.commons", "commons-io", "1.3.2", "sources", "jar", "commons-io-1.3.2-sources.jar", "false", "false", null}, {"org/apache/commons/commons-io/1.3.2/commons-io-1.3.2-sources.jar.md5", "org.apache.commons", "commons-io", "1.3.2", "sources", "jar.md5", "commons-io-1.3.2-sources.jar.md5", "true", "false", null}, {"org/overlord/sramp/test/test-wagon-push/0.0.1-SNAPSHOT/test-wagon-push-0.0.1-20120921.113704-1.jar", "org.overlord.sramp.test", "test-wagon-push", "0.0.1-SNAPSHOT", null, "jar", "test-wagon-push-0.0.1-20120921.113704-1.jar", "false", "true", "20120921.113704-1"}, {"org/overlord/sramp/test/test-wagon-push/0.0.1-SNAPSHOT/test-wagon-push-0.0.1-20120921.113704-1-sources.jar.md5", "org.overlord.sramp.test", "test-wagon-push", "0.0.1-SNAPSHOT", "sources", "jar.md5", "test-wagon-push-0.0.1-20120921.113704-1-sources.jar.md5", "true", "true", "20120921.113704-1"}, {"org/overlord/sramp/test/test-wagon-push/0.0.1-SNAPSHOT/test-wagon-push-0.0.1-20120921.113704-1.pom.sha1", "org.overlord.sramp.test", "test-wagon-push", "0.0.1-SNAPSHOT", null, "pom.sha1", "test-wagon-push-0.0.1-20120921.113704-1.pom.sha1", "true", "true", "20120921.113704-1"}};

    @Test
    public void testFromResource() {
        for (String[] testCase : TEST_DATA) {
            String resourcePath = testCase[0];
            String expectedGroupId = testCase[1];
            String expectedArtifactId = testCase[2];
            String expectedVersion = testCase[3];
            String expectedClassifier = testCase[4];
            String expectedType = testCase[5];
            String expectedName = testCase[6];
            String expectedHash = testCase[7];
            String expectedSnapshot = testCase[8];
            String expectedSnapshotId = testCase[9];
            MavenGavInfo gavInfo = MavenGavInfo.fromResource((Resource)new Resource(resourcePath));
            String helpfulMsg = "Failure in test case: " + resourcePath;
            Assert.assertEquals((String)helpfulMsg, (String)expectedGroupId, (String)gavInfo.getGroupId());
            Assert.assertEquals((String)helpfulMsg, (String)expectedArtifactId, (String)gavInfo.getArtifactId());
            Assert.assertEquals((String)helpfulMsg, (String)expectedVersion, (String)gavInfo.getVersion());
            Assert.assertEquals((String)helpfulMsg, (String)expectedClassifier, (String)gavInfo.getClassifier());
            Assert.assertEquals((String)helpfulMsg, (String)expectedType, (String)gavInfo.getType());
            Assert.assertEquals((String)helpfulMsg, (String)expectedName, (String)gavInfo.getName());
            Assert.assertEquals((String)helpfulMsg, (String)expectedHash, (String)String.valueOf(gavInfo.isHash()));
            Assert.assertEquals((String)helpfulMsg, (String)expectedSnapshot, (String)String.valueOf(gavInfo.isSnapshot()));
            Assert.assertEquals((String)helpfulMsg, (String)expectedSnapshotId, (String)gavInfo.getSnapshotId());
        }
    }
}

