/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.wagon;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Relationship;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.atom.providers.HttpResponseProvider;
import org.overlord.sramp.atom.providers.SrampAtomExceptionProvider;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.common.test.resteasy.BaseResourceTest;
import org.overlord.sramp.common.test.resteasy.TestPortProvider;
import org.overlord.sramp.repository.PersistenceFactory;
import org.overlord.sramp.repository.jcr.JCRRepository;
import org.overlord.sramp.repository.jcr.modeshape.JCRRepositoryCleaner;
import org.overlord.sramp.server.atom.services.ArtifactResource;
import org.overlord.sramp.server.atom.services.BatchResource;
import org.overlord.sramp.server.atom.services.FeedResource;
import org.overlord.sramp.server.atom.services.QueryResource;
import org.overlord.sramp.server.atom.services.ServiceDocumentResource;
import org.overlord.sramp.wagon.SrampWagon;

public class SrampWagonTest
extends BaseResourceTest {
    @BeforeClass
    public static void setUp() throws Exception {
        System.setProperty("sramp.modeshape.config.url", "classpath://" + JCRRepository.class.getName() + "/META-INF/modeshape-configs/inmemory-sramp-config.json");
        System.setProperty("sramp.config.auditing.enabled", "false");
        deployment.getProviderFactory().registerProvider(SrampAtomExceptionProvider.class);
        deployment.getProviderFactory().registerProvider(HttpResponseProvider.class);
        dispatcher.getRegistry().addPerRequestResource(ServiceDocumentResource.class);
        dispatcher.getRegistry().addPerRequestResource(ArtifactResource.class);
        dispatcher.getRegistry().addPerRequestResource(FeedResource.class);
        dispatcher.getRegistry().addPerRequestResource(BatchResource.class);
        dispatcher.getRegistry().addPerRequestResource(QueryResource.class);
    }

    @Before
    public void cleanRepository() {
        new JCRRepositoryCleaner().clean();
    }

    @AfterClass
    public static void cleanup() {
        PersistenceFactory.newInstance().shutdown();
        System.clearProperty("sramp.config.auditing.enabled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWagonPush() throws Exception {
        SrampWagon wagon = new SrampWagon();
        this.setLogger(wagon);
        Repository repo = new Repository("sramp.repo", TestPortProvider.generateURL((String)"/s-ramp/?artifactType=JavaArchive").replaceAll("http", "sramp"));
        wagon.connect(repo);
        InputStream metaDataStream = null;
        InputStream artifactStream = null;
        InputStream pomStream = null;
        InputStream artifactSHA1Stream = null;
        InputStream pomSHA1Stream = null;
        try {
            metaDataStream = ((Object)((Object)this)).getClass().getResourceAsStream("maven-metadata.xml");
            artifactStream = ((Object)((Object)this)).getClass().getResourceAsStream("artifact-0.0.3.jar");
            pomStream = ((Object)((Object)this)).getClass().getResourceAsStream("artifact-0.0.3.pom");
            artifactSHA1Stream = ((Object)((Object)this)).getClass().getResourceAsStream("artifact-0.0.3.jar.sha1");
            pomSHA1Stream = ((Object)((Object)this)).getClass().getResourceAsStream("artifact-0.0.3.pom.sha1");
            Assert.assertNotNull((Object)metaDataStream);
            Assert.assertNotNull((Object)artifactStream);
            Assert.assertNotNull((Object)pomStream);
            Assert.assertNotNull((Object)artifactSHA1Stream);
            Assert.assertNotNull((Object)pomSHA1Stream);
            wagon.putFromStream(metaDataStream, "org/overlord/sramp/test/archive/0.0.3/maven-metadata.xml");
            wagon.putFromStream(artifactStream, "org/overlord/sramp/test/archive/0.0.3/artifact-0.0.3.jar");
            wagon.putFromStream(artifactSHA1Stream, "org/overlord/sramp/test/archive/0.0.3/artifact-0.0.3.jar.sha1");
            wagon.putFromStream(pomStream, "org/overlord/sramp/test/archive/0.0.3/artifact-0.0.3.pom");
            wagon.putFromStream(pomSHA1Stream, "org/overlord/sramp/test/archive/0.0.3/artifact-0.0.3.pom.sha1");
        }
        catch (Throwable throwable) {
            wagon.disconnect();
            IOUtils.closeQuietly((InputStream)metaDataStream);
            IOUtils.closeQuietly(artifactStream);
            IOUtils.closeQuietly(pomStream);
            IOUtils.closeQuietly(artifactSHA1Stream);
            IOUtils.closeQuietly(pomSHA1Stream);
            throw throwable;
        }
        wagon.disconnect();
        IOUtils.closeQuietly((InputStream)metaDataStream);
        IOUtils.closeQuietly((InputStream)artifactStream);
        IOUtils.closeQuietly((InputStream)pomStream);
        IOUtils.closeQuietly((InputStream)artifactSHA1Stream);
        IOUtils.closeQuietly((InputStream)pomSHA1Stream);
        SrampAtomApiClient client = new SrampAtomApiClient(TestPortProvider.generateURL((String)"/s-ramp/"));
        QueryResultSet rset = client.query("/s-ramp/ext/JavaArchive");
        Assert.assertEquals((long)1L, (long)rset.size());
        rset = client.query("/s-ramp/ext/MavenPom");
        Assert.assertEquals((long)1L, (long)rset.size());
        rset = client.query("/s-ramp/xsd/XsdDocument");
        Assert.assertEquals((long)3L, (long)rset.size());
        rset = client.query("/s-ramp/wsdl/WsdlDocument");
        Assert.assertEquals((long)1L, (long)rset.size());
        rset = client.query("/s-ramp[expandedFromDocument]");
        Assert.assertEquals((long)4L, (long)rset.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWagonPushNoSpecifiedTypeUseHints() throws Exception {
        SrampWagon wagon = new SrampWagon();
        this.setLogger(wagon);
        Repository repo = new Repository("sramp.repo", TestPortProvider.generateURL((String)"/s-ramp/").replaceAll("http", "sramp"));
        wagon.connect(repo);
        InputStream metaDataStream = null;
        InputStream artifactStream = null;
        InputStream pomStream = null;
        InputStream artifactSHA1Stream = null;
        InputStream pomSHA1Stream = null;
        try {
            metaDataStream = ((Object)((Object)this)).getClass().getResourceAsStream("maven-metadata.xml");
            artifactStream = ((Object)((Object)this)).getClass().getResourceAsStream("artifact-0.0.3.jar");
            pomStream = ((Object)((Object)this)).getClass().getResourceAsStream("artifact-0.0.3.pom");
            artifactSHA1Stream = ((Object)((Object)this)).getClass().getResourceAsStream("artifact-0.0.3.jar.sha1");
            pomSHA1Stream = ((Object)((Object)this)).getClass().getResourceAsStream("artifact-0.0.3.pom.sha1");
            Assert.assertNotNull((Object)metaDataStream);
            Assert.assertNotNull((Object)artifactStream);
            Assert.assertNotNull((Object)pomStream);
            Assert.assertNotNull((Object)artifactSHA1Stream);
            Assert.assertNotNull((Object)pomSHA1Stream);
            wagon.putFromStream(metaDataStream, "org/overlord/sramp/test/archive/0.0.3/maven-metadata.xml");
            wagon.putFromStream(artifactStream, "org/overlord/sramp/test/archive/0.0.3/artifact-0.0.3.jar");
            wagon.putFromStream(artifactSHA1Stream, "org/overlord/sramp/test/archive/0.0.3/artifact-0.0.3.jar.sha1");
            wagon.putFromStream(pomStream, "org/overlord/sramp/test/archive/0.0.3/artifact-0.0.3.pom");
            wagon.putFromStream(pomSHA1Stream, "org/overlord/sramp/test/archive/0.0.3/artifact-0.0.3.pom.sha1");
        }
        catch (Throwable throwable) {
            wagon.disconnect();
            IOUtils.closeQuietly((InputStream)metaDataStream);
            IOUtils.closeQuietly(artifactStream);
            IOUtils.closeQuietly(pomStream);
            IOUtils.closeQuietly(artifactSHA1Stream);
            IOUtils.closeQuietly(pomSHA1Stream);
            throw throwable;
        }
        wagon.disconnect();
        IOUtils.closeQuietly((InputStream)metaDataStream);
        IOUtils.closeQuietly((InputStream)artifactStream);
        IOUtils.closeQuietly((InputStream)pomStream);
        IOUtils.closeQuietly((InputStream)artifactSHA1Stream);
        IOUtils.closeQuietly((InputStream)pomSHA1Stream);
        SrampAtomApiClient client = new SrampAtomApiClient(TestPortProvider.generateURL((String)"/s-ramp/"));
        QueryResultSet rset = client.query("/s-ramp/ext/JavaArchive");
        Assert.assertEquals((long)1L, (long)rset.size());
        rset = client.query("/s-ramp/ext/MavenPom");
        Assert.assertEquals((long)1L, (long)rset.size());
        rset = client.query("/s-ramp/xsd/XsdDocument");
        Assert.assertEquals((long)3L, (long)rset.size());
        rset = client.query("/s-ramp/wsdl/WsdlDocument");
        Assert.assertEquals((long)1L, (long)rset.size());
        rset = client.query("/s-ramp[expandedFromDocument]");
        Assert.assertEquals((long)4L, (long)rset.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWagonPushWithArtifactName() throws Exception {
        SrampWagon wagon = new SrampWagon();
        this.setLogger(wagon);
        Repository repo = new Repository("sramp.repo", TestPortProvider.generateURL((String)"/s-ramp/?artifactType=FooApplication").replaceAll("http", "sramp"));
        wagon.connect(repo);
        InputStream artifactStream = null;
        InputStream pomStream = null;
        InputStream artifactSHA1Stream = null;
        InputStream pomSHA1Stream = null;
        try {
            artifactStream = ((Object)((Object)this)).getClass().getResourceAsStream("foo-artifact-0.0.3.txt");
            pomStream = ((Object)((Object)this)).getClass().getResourceAsStream("artifact-0.0.3.pom");
            artifactSHA1Stream = ((Object)((Object)this)).getClass().getResourceAsStream("artifact-0.0.3.jar.sha1");
            pomSHA1Stream = ((Object)((Object)this)).getClass().getResourceAsStream("artifact-0.0.3.pom.sha1");
            Assert.assertNotNull((Object)artifactStream);
            Assert.assertNotNull((Object)pomStream);
            Assert.assertNotNull((Object)artifactSHA1Stream);
            Assert.assertNotNull((Object)pomSHA1Stream);
            wagon.putFromStream(artifactStream, "org/overlord/sramp/test/foo/0.0.3/foo-artifact-0.0.3.txt");
            wagon.putFromStream(artifactSHA1Stream, "org/overlord/sramp/test/foo/0.0.3/foo-artifact-0.0.3.txt.sha1");
            wagon.putFromStream(pomStream, "org/overlord/sramp/test/foo/0.0.3/foo-artifact-0.0.3.pom");
            wagon.putFromStream(pomSHA1Stream, "org/overlord/sramp/test/foo/0.0.3/foo-artifact-0.0.3.pom.sha1");
        }
        catch (Throwable throwable) {
            wagon.disconnect();
            IOUtils.closeQuietly((InputStream)artifactStream);
            IOUtils.closeQuietly(pomStream);
            IOUtils.closeQuietly(artifactSHA1Stream);
            IOUtils.closeQuietly(pomSHA1Stream);
            throw throwable;
        }
        wagon.disconnect();
        IOUtils.closeQuietly((InputStream)artifactStream);
        IOUtils.closeQuietly((InputStream)pomStream);
        IOUtils.closeQuietly((InputStream)artifactSHA1Stream);
        IOUtils.closeQuietly((InputStream)pomSHA1Stream);
        SrampAtomApiClient client = new SrampAtomApiClient(TestPortProvider.generateURL((String)"/s-ramp/"));
        QueryResultSet rset = client.query("/s-ramp/core/Document");
        Assert.assertEquals((long)0L, (long)rset.size());
        rset = client.query("/s-ramp/ext/FooApplication");
        Assert.assertEquals((long)1L, (long)rset.size());
        rset = client.query("/s-ramp/ext/MavenPom");
        Assert.assertEquals((long)1L, (long)rset.size());
        rset = client.query("/s-ramp[@maven.groupId = 'org.overlord.sramp.test']");
        Assert.assertEquals((long)2L, (long)rset.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWagonPushWithArtifactGrouping() throws Exception {
        SrampWagon wagon = new SrampWagon();
        this.setLogger(wagon);
        Repository repo = new Repository("sramp.repo", TestPortProvider.generateURL((String)"/s-ramp/?artifactGrouping=MyArtifactGrouping").replaceAll("http", "sramp"));
        InputStream artifact1Stream = null;
        InputStream artifact2Stream = null;
        InputStream pom1Stream = null;
        InputStream pom2Stream = null;
        InputStream artifactSHA1Stream = null;
        InputStream artifactSHA2Stream = null;
        InputStream pomSHA1Stream = null;
        InputStream pomSHA2Stream = null;
        try {
            artifact1Stream = ((Object)((Object)this)).getClass().getResourceAsStream("artifact-0.0.3.jar");
            artifact2Stream = ((Object)((Object)this)).getClass().getResourceAsStream("foo-artifact-0.0.3.txt");
            pom1Stream = ((Object)((Object)this)).getClass().getResourceAsStream("artifact-0.0.3.pom");
            pom2Stream = ((Object)((Object)this)).getClass().getResourceAsStream("artifact-0.0.3.pom");
            artifactSHA1Stream = ((Object)((Object)this)).getClass().getResourceAsStream("artifact-0.0.3.jar.sha1");
            artifactSHA2Stream = ((Object)((Object)this)).getClass().getResourceAsStream("artifact-0.0.3.jar.sha1");
            pomSHA1Stream = ((Object)((Object)this)).getClass().getResourceAsStream("artifact-0.0.3.pom.sha1");
            pomSHA2Stream = ((Object)((Object)this)).getClass().getResourceAsStream("artifact-0.0.3.pom.sha1");
            Assert.assertNotNull((Object)artifact1Stream);
            Assert.assertNotNull((Object)artifact2Stream);
            Assert.assertNotNull((Object)pom1Stream);
            Assert.assertNotNull((Object)pom2Stream);
            Assert.assertNotNull((Object)artifactSHA1Stream);
            Assert.assertNotNull((Object)artifactSHA2Stream);
            Assert.assertNotNull((Object)pomSHA1Stream);
            Assert.assertNotNull((Object)pomSHA2Stream);
            wagon.connect(repo);
            wagon.putFromStream(artifact1Stream, "org/overlord/sramp/test/artifact/0.0.3/artifact-0.0.3.jar");
            wagon.putFromStream(artifactSHA1Stream, "org/overlord/sramp/test/artifact/0.0.3/artifact-0.0.3.jar.sha1");
            wagon.putFromStream(pom1Stream, "org/overlord/sramp/test/artifact/0.0.3/artifact-0.0.3.pom");
            wagon.putFromStream(pomSHA1Stream, "org/overlord/sramp/test/artifact/0.0.3/artifact-0.0.3.pom.sha1");
            wagon.disconnect();
            wagon.connect(repo);
            wagon.putFromStream(artifact2Stream, "org/overlord/sramp/test/bar/0.0.3/bar-0.0.3.txt");
            wagon.putFromStream(artifactSHA2Stream, "org/overlord/sramp/test/bar/0.0.3/bar-0.0.3.txt.sha1");
            wagon.putFromStream(pom2Stream, "org/overlord/sramp/test/bar/0.0.3/bar-0.0.3.pom");
            wagon.putFromStream(pomSHA2Stream, "org/overlord/sramp/test/bar/0.0.3/bar-0.0.3.pom.sha1");
        }
        catch (Throwable throwable) {
            wagon.disconnect();
            IOUtils.closeQuietly((InputStream)artifact1Stream);
            IOUtils.closeQuietly(artifact2Stream);
            IOUtils.closeQuietly(pom1Stream);
            IOUtils.closeQuietly(pom2Stream);
            IOUtils.closeQuietly(artifactSHA1Stream);
            IOUtils.closeQuietly(artifactSHA2Stream);
            IOUtils.closeQuietly(pomSHA1Stream);
            IOUtils.closeQuietly(pomSHA2Stream);
            throw throwable;
        }
        wagon.disconnect();
        IOUtils.closeQuietly((InputStream)artifact1Stream);
        IOUtils.closeQuietly((InputStream)artifact2Stream);
        IOUtils.closeQuietly((InputStream)pom1Stream);
        IOUtils.closeQuietly((InputStream)pom2Stream);
        IOUtils.closeQuietly((InputStream)artifactSHA1Stream);
        IOUtils.closeQuietly((InputStream)artifactSHA2Stream);
        IOUtils.closeQuietly((InputStream)pomSHA1Stream);
        IOUtils.closeQuietly((InputStream)pomSHA2Stream);
        SrampAtomApiClient client = new SrampAtomApiClient(TestPortProvider.generateURL((String)"/s-ramp/"));
        QueryResultSet rset = client.query("/s-ramp[@maven.groupId = 'org.overlord.sramp.test']");
        Assert.assertEquals((long)4L, (long)rset.size());
        rset = client.query("/s-ramp/ext/ArtifactGrouping");
        Assert.assertEquals((long)1L, (long)rset.size());
        rset = client.query("/s-ramp/ext/ArtifactGrouping[@name = 'MyArtifactGrouping']");
        Assert.assertEquals((long)1L, (long)rset.size());
        ArtifactSummary artifactSummary = rset.get(0);
        Assert.assertEquals((Object)"MyArtifactGrouping", (Object)artifactSummary.getName());
        BaseArtifactType groupingArtifact = client.getArtifactMetaData(artifactSummary.getUuid());
        Assert.assertNotNull((Object)groupingArtifact);
        Relationship relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)groupingArtifact, (String)"groups");
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((long)4L, (long)relationship.getRelationshipTarget().size());
        rset = client.query("/s-ramp[groupedBy[@name = 'MyArtifactGrouping']]");
        Assert.assertEquals((long)4L, (long)rset.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWagonPull() throws Exception {
        SrampAtomApiClient client = new SrampAtomApiClient(TestPortProvider.generateURL((String)"/s-ramp/"));
        InputStream archiveStream = null;
        SrampArchive archive = null;
        try {
            archiveStream = ((Object)((Object)this)).getClass().getResourceAsStream("sramp-archive.zip");
            archive = new SrampArchive(archiveStream);
            client.uploadBatch(archive);
        }
        catch (Throwable throwable) {
            SrampArchive.closeQuietly(archive);
            throw throwable;
        }
        SrampArchive.closeQuietly((SrampArchive)archive);
        SrampWagon wagon = new SrampWagon();
        this.setLogger(wagon);
        Repository repo = new Repository("sramp.repo", TestPortProvider.generateURL((String)"/s-ramp/").replaceAll("http", "sramp"));
        wagon.connect(repo);
        File tempFile = File.createTempFile("s-ramp-wagon-test", ".tmp");
        try {
            wagon.get("org/overlord/sramp/test/archive/maven-metadata.xml", tempFile);
            Assert.assertTrue((boolean)tempFile.exists());
            Assert.assertTrue((boolean)tempFile.isFile());
            wagon.get("org/overlord/sramp/test/archive/0.0.3/artifact-0.0.3.jar", tempFile);
            this.assertContents("artifact-0.0.3.jar", tempFile);
            tempFile.delete();
            wagon.get("org/overlord/sramp/test/archive/0.0.3/artifact-0.0.3.jar.sha1", tempFile);
            this.assertContents("artifact-0.0.3.jar.sha1", tempFile);
            tempFile.delete();
            wagon.get("org/overlord/sramp/test/archive/0.0.3/artifact-0.0.3.pom", tempFile);
            tempFile.delete();
            wagon.get("org/overlord/sramp/test/archive/0.0.3/artifact-0.0.3.pom.sha1", tempFile);
            this.assertContents("artifact-0.0.3.pom.sha1", tempFile);
            tempFile.delete();
        }
        finally {
            if (tempFile.exists()) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertContents(String expected, File actual) throws IOException {
        InputStream expectedStream = null;
        FileInputStream actualStream = null;
        try {
            expectedStream = ((Object)((Object)this)).getClass().getResourceAsStream(expected);
            actualStream = FileUtils.openInputStream((File)actual);
            Assert.assertTrue((String)("File contents failed to match: " + actual.getName()), (boolean)IOUtils.contentEquals((InputStream)expectedStream, (InputStream)actualStream));
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(actualStream);
            IOUtils.closeQuietly((InputStream)expectedStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)actualStream);
        IOUtils.closeQuietly((InputStream)expectedStream);
    }

    private void setLogger(SrampWagon wagon) throws Exception {
        Field field = wagon.getClass().getDeclaredField("logger");
        field.setAccessible(true);
        field.set(wagon, new ConsoleLogger(0, "logger"));
    }
}

