/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.wagon;

import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedArtifactType;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.atom.archive.SrampArchiveEntry;
import org.overlord.sramp.atom.archive.SrampArchiveException;
import org.overlord.sramp.atom.archive.expand.MetaDataProvider;
import org.overlord.sramp.atom.archive.expand.ZipToSrampArchive;
import org.overlord.sramp.atom.archive.expand.registry.ArchiveInfo;
import org.overlord.sramp.atom.archive.expand.registry.ZipToSrampArchiveRegistry;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.client.SrampClientQuery;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.ArtifactTypeEnum;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.wagon.i18n.Messages;
import org.overlord.sramp.wagon.models.MavenGavInfo;
import org.overlord.sramp.wagon.util.DevNullOutputStream;

@Component(role=Wagon.class, hint="sramp", instantiationStrategy="per-lookup")
public class SrampWagon
extends StreamWagon {
    @Requirement
    private Logger logger;
    private transient SrampArchive archive;
    private transient SrampAtomApiClient client;

    private String getSrampEndpoint() {
        String pomUrl = this.getRepository().getUrl();
        if (pomUrl.indexOf(63) > 0) {
            pomUrl = pomUrl.substring(0, pomUrl.indexOf(63));
        }
        String replace = pomUrl.replace("sramp:", "http:").replace("sramps:", "https:");
        return replace;
    }

    protected void openConnectionInternal() throws ConnectionException, AuthenticationException {
        ClassLoader oldCtxCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SrampWagon.class.getClassLoader());
        try {
            this.archive = new SrampArchive();
            String endpoint = this.getSrampEndpoint();
            String username = null;
            String password = null;
            AuthenticationInfo authInfo = this.getAuthenticationInfo();
            if (authInfo != null) {
                if (authInfo.getUserName() != null) {
                    username = authInfo.getUserName();
                }
                if (authInfo.getPassword() != null) {
                    password = authInfo.getPassword();
                }
            }
            if (username == null) {
                username = this.promptForUsername();
            }
            if (password == null) {
                password = this.promptForPassword();
            }
            this.client = new SrampAtomApiClient(endpoint, username, password, true);
        }
        catch (SrampArchiveException e) {
            throw new ConnectionException(Messages.i18n.format("FAILED_TO_CREATE_ARCHIVE", new Object[0]), (Throwable)e);
        }
        catch (SrampClientException e) {
            throw new ConnectionException(Messages.i18n.format("FAILED_TO_CONNECT_TO_SRAMP", new Object[0]), (Throwable)e);
        }
        catch (SrampAtomException e) {
            throw new ConnectionException(Messages.i18n.format("FAILED_TO_CONNECT_TO_SRAMP", new Object[0]), (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCtxCL);
        }
    }

    private String promptForUsername() {
        Console console = System.console();
        if (console != null) {
            return console.readLine(Messages.i18n.format("USERNAME_PROMPT", new Object[0]), new Object[0]);
        }
        System.err.println(Messages.i18n.format("NO_CONSOLE_ERROR_1", new Object[0]));
        return null;
    }

    private String promptForPassword() {
        Console console = System.console();
        if (console != null) {
            return new String(console.readPassword(Messages.i18n.format("PASSWORD_PROMPT", new Object[0]), new Object[0]));
        }
        System.err.println(Messages.i18n.format("NO_CONSOLE_ERROR_2", new Object[0]));
        return null;
    }

    public void closeConnection() throws ConnectionException {
        SrampArchive.closeQuietly((SrampArchive)this.archive);
    }

    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = inputData.getResource();
        MavenGavInfo gavInfo = MavenGavInfo.fromResource(resource);
        if (gavInfo.isMavenMetaData() && gavInfo.getVersion() == null) {
            this.doGenerateArtifactDirMavenMetaData(gavInfo, inputData);
            return;
        }
        if (gavInfo.isMavenMetaData() && gavInfo.getVersion() != null) {
            this.doGenerateSnapshotMavenMetaData(gavInfo, inputData);
            return;
        }
        this.debug(Messages.i18n.format("LOOKING_UP_RESOURCE_IN_SRAMP", new Object[]{resource}));
        if (gavInfo.isHash()) {
            this.doGetHash(gavInfo, inputData);
        } else {
            this.doGetArtifact(gavInfo, inputData);
        }
    }

    private void doGenerateArtifactDirMavenMetaData(MavenGavInfo gavInfo, InputData inputData) throws ResourceDoesNotExistException {
        ClassLoader oldCtxCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SrampWagon.class.getClassLoader());
        try {
            SrampArchiveEntry entry;
            String artyPath = gavInfo.getFullName();
            if (gavInfo.isHash()) {
                artyPath = artyPath.substring(0, artyPath.lastIndexOf(46));
            }
            if ((entry = this.archive.getEntry(artyPath)) == null) {
                QueryResultSet resultSet = this.client.buildQuery("/s-ramp[@maven.groupId = ? and @maven.artifactId = ?]").parameter(gavInfo.getGroupId()).parameter(gavInfo.getArtifactId()).propertyName("maven.version").count(500).orderBy("createdTimestamp").ascending().query();
                if (resultSet.size() == 0L) {
                    throw new Exception(Messages.i18n.format("NO_ARTIFACTS_FOUND", new Object[0]));
                }
                String groupId = gavInfo.getGroupId();
                String artifactId = gavInfo.getArtifactId();
                String latest = null;
                String release = null;
                String lastUpdated = null;
                LinkedHashSet<String> versions = new LinkedHashSet<String>();
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
                for (ArtifactSummary artifactSummary : resultSet) {
                    String version = artifactSummary.getCustomPropertyValue("maven.version");
                    if (versions.add(version)) {
                        latest = version;
                        if (!version.endsWith("-SNAPSHOT")) {
                            release = version;
                        }
                    }
                    lastUpdated = format.format(artifactSummary.getCreatedTimestamp());
                }
                StringBuilder mavenMetadata = new StringBuilder();
                mavenMetadata.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                mavenMetadata.append("<metadata>\n");
                mavenMetadata.append("  <groupId>").append(groupId).append("</groupId>\n");
                mavenMetadata.append("  <artifactId>").append(artifactId).append("</artifactId>\n");
                mavenMetadata.append("  <versioning>\n");
                mavenMetadata.append("    <latest>").append(latest).append("</latest>\n");
                mavenMetadata.append("    <release>").append(release).append("</release>\n");
                mavenMetadata.append("    <versions>\n");
                for (String version : versions) {
                    mavenMetadata.append("      <version>").append(version).append("</version>\n");
                }
                mavenMetadata.append("    </versions>\n");
                mavenMetadata.append("    <lastUpdated>").append(lastUpdated).append("</lastUpdated>\n");
                mavenMetadata.append("  </versioning>\n");
                mavenMetadata.append("</metadata>\n");
                BaseArtifactType artifact = ArtifactType.ExtendedDocument((String)"MavenMetaData").newArtifactInstance();
                this.archive.addEntry(artyPath, artifact, IOUtils.toInputStream((String)mavenMetadata.toString()));
                entry = this.archive.getEntry(artyPath);
            }
            if (!gavInfo.isHash()) {
                inputData.setInputStream(this.archive.getInputStream(entry));
            } else {
                String hash = this.generateHash(this.archive.getInputStream(entry), gavInfo.getHashAlgorithm());
                inputData.setInputStream(IOUtils.toInputStream((String)hash));
            }
        }
        catch (Exception e) {
            throw new ResourceDoesNotExistException(Messages.i18n.format("FAILED_TO_GENERATE_METADATA", new Object[0]), (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCtxCL);
        }
    }

    private void doGenerateSnapshotMavenMetaData(MavenGavInfo gavInfo, InputData inputData) throws ResourceDoesNotExistException {
        ClassLoader oldCtxCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SrampWagon.class.getClassLoader());
        try {
            SrampArchiveEntry entry;
            String artyPath = gavInfo.getFullName();
            if (gavInfo.isHash()) {
                artyPath = artyPath.substring(0, artyPath.lastIndexOf(46));
            }
            if ((entry = this.archive.getEntry(artyPath)) == null) {
                QueryResultSet resultSet = this.client.buildQuery("/s-ramp[@maven.groupId = ? and @maven.artifactId = ? and @maven.version = ?]").parameter(gavInfo.getGroupId()).parameter(gavInfo.getArtifactId()).parameter(gavInfo.getVersion()).propertyName("maven.classifier").propertyName("maven.type").count(500).orderBy("createdTimestamp").ascending().query();
                if (resultSet.size() == 0L) {
                    throw new Exception(Messages.i18n.format("NO_ARTIFACTS_FOUND", new Object[0]));
                }
                SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyyMMdd.HHmmss");
                SimpleDateFormat updatedFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                StringBuilder snapshotVersions = new StringBuilder();
                snapshotVersions.append("    <snapshotVersions>\n");
                HashSet<String> processed = new HashSet<String>();
                Date latestDate = null;
                for (ArtifactSummary artifactSummary : resultSet) {
                    String extension = artifactSummary.getCustomPropertyValue("maven.type");
                    String classifier = artifactSummary.getCustomPropertyValue("maven.classifier");
                    String value = gavInfo.getVersion();
                    Date updatedDate = artifactSummary.getLastModifiedTimestamp();
                    String updated = updatedFormat.format(updatedDate);
                    String pkey = classifier + "::" + extension;
                    if (!processed.add(pkey)) continue;
                    snapshotVersions.append("      <snapshotVersion>\n");
                    if (classifier != null) {
                        snapshotVersions.append("        <classifier>").append(classifier).append("</classifier>\n");
                    }
                    snapshotVersions.append("        <extension>").append(extension).append("</extension>\n");
                    snapshotVersions.append("        <value>").append(value).append("</value>\n");
                    snapshotVersions.append("        <updated>").append(updated).append("</updated>\n");
                    snapshotVersions.append("      </snapshotVersion>\n");
                    if (latestDate != null && !latestDate.before(updatedDate)) continue;
                    latestDate = updatedDate;
                }
                snapshotVersions.append("    </snapshotVersions>\n");
                String groupId = gavInfo.getGroupId();
                String artifactId = gavInfo.getArtifactId();
                String version = gavInfo.getVersion();
                String lastUpdated = updatedFormat.format(latestDate);
                StringBuilder mavenMetadata = new StringBuilder();
                mavenMetadata.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                mavenMetadata.append("<metadata>\n");
                mavenMetadata.append("  <groupId>").append(groupId).append("</groupId>\n");
                mavenMetadata.append("  <artifactId>").append(artifactId).append("</artifactId>\n");
                mavenMetadata.append("  <version>").append(version).append("</version>\n");
                mavenMetadata.append("  <versioning>\n");
                mavenMetadata.append("    <snapshot>\n");
                mavenMetadata.append("      <timestamp>").append(timestampFormat.format(latestDate)).append("</timestamp>\n");
                mavenMetadata.append("      <buildNumber>1</buildNumber>\n");
                mavenMetadata.append("    </snapshot>\n");
                mavenMetadata.append("    <lastUpdated>").append(lastUpdated).append("</lastUpdated>\n");
                mavenMetadata.append(snapshotVersions.toString());
                mavenMetadata.append("  </versioning>\n");
                mavenMetadata.append("</metadata>\n");
                BaseArtifactType artifact = ArtifactType.ExtendedDocument((String)"MavenMetaData").newArtifactInstance();
                this.archive.addEntry(artyPath, artifact, IOUtils.toInputStream((String)mavenMetadata.toString()));
                entry = this.archive.getEntry(artyPath);
            }
            if (!gavInfo.isHash()) {
                inputData.setInputStream(this.archive.getInputStream(entry));
            } else {
                String hash = this.generateHash(this.archive.getInputStream(entry), gavInfo.getHashAlgorithm());
                inputData.setInputStream(IOUtils.toInputStream((String)hash));
            }
        }
        catch (Exception e) {
            throw new ResourceDoesNotExistException(Messages.i18n.format("FAILED_TO_GENERATE_METADATA", new Object[0]), (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCtxCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGetHash(MavenGavInfo gavInfo, InputData inputData) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        String hashPropName;
        String artyPath = gavInfo.getFullName();
        if (gavInfo.getType().endsWith(".md5")) {
            hashPropName = "maven.hash.md5";
            artyPath = artyPath.substring(0, artyPath.length() - 4);
        } else {
            hashPropName = "maven.hash.sha1";
            artyPath = artyPath.substring(0, artyPath.length() - 5);
        }
        ClassLoader oldCtxCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SrampWagon.class.getClassLoader());
        try {
            SrampArchiveEntry entry = this.archive.getEntry(artyPath);
            if (entry == null) {
                throw new ResourceDoesNotExistException(Messages.i18n.format("MISSING_RESOURCE_HASH", new Object[]{gavInfo.getName()}));
            }
            BaseArtifactType metaData = entry.getMetaData();
            String hashValue = SrampModelUtils.getCustomProperty((BaseArtifactType)metaData, (String)hashPropName);
            if (hashValue == null) {
                throw new ResourceDoesNotExistException(Messages.i18n.format("MISSING_RESOURCE_HASH", new Object[]{gavInfo.getName()}));
            }
            inputData.setInputStream(IOUtils.toInputStream((String)hashValue));
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCtxCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGetArtifact(MavenGavInfo gavInfo, InputData inputData) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        ClassLoader oldCtxCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SrampWagon.class.getClassLoader());
        try {
            BaseArtifactType artifact = this.findExistingArtifact(this.client, gavInfo);
            if (artifact == null) {
                throw new ResourceDoesNotExistException(Messages.i18n.format("ARTIFACT_NOT_FOUND", new Object[]{gavInfo.getName()}));
            }
            this.archive.addEntry(gavInfo.getFullName(), artifact, null);
            ArtifactType type = ArtifactType.valueOf((BaseArtifactType)artifact);
            InputStream artifactContent = this.client.getArtifactContent(type, artifact.getUuid());
            inputData.setInputStream(artifactContent);
        }
        catch (ResourceDoesNotExistException e) {
            throw e;
        }
        catch (SrampClientException e) {
            if (e.getCause() instanceof HttpHostConnectException) {
                this.debug(Messages.i18n.format("SRAMP_CONNECTION_FAILED", new Object[]{e.getMessage()}));
            } else {
                this.error(e.getMessage(), e);
            }
            throw new ResourceDoesNotExistException(Messages.i18n.format("FAILED_TO_GET_RESOURCE_FROM_SRAMP", new Object[]{gavInfo.getName()}));
        }
        catch (Throwable t) {
            this.error(t.getMessage(), t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCtxCL);
        }
    }

    public void putFromStream(InputStream stream, String destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(destination);
        this.putCommon(resource, null, stream);
    }

    public void putFromStream(InputStream stream, String destination, long contentLength, long lastModified) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(destination);
        resource.setContentLength(contentLength);
        resource.setLastModified(lastModified);
        this.putCommon(resource, null, stream);
    }

    public void put(File source, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        FileInputStream resourceInputStream = null;
        try {
            resourceInputStream = new FileInputStream(source);
        }
        catch (FileNotFoundException e) {
            throw new TransferFailedException(e.getMessage());
        }
        Resource resource = new Resource(resourceName);
        resource.setContentLength(source.length());
        resource.setLastModified(source.lastModified());
        this.putCommon(resource, source, resourceInputStream);
    }

    private void putCommon(Resource resource, File source, InputStream content) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.logger.info(Messages.i18n.format("UPLOADING_TO_SRAMP", new Object[]{resource.getName()}));
        this.firePutInitiated(resource, source);
        this.firePutStarted(resource, source);
        if (resource.getName().contains("maven-metadata.xml")) {
            this.logger.info(Messages.i18n.format("SKIPPING_ARTY", new Object[]{resource.getName()}));
            try {
                this.transfer(resource, content, new DevNullOutputStream(), 6);
            }
            catch (IOException e) {
                throw new TransferFailedException(e.getMessage(), (Throwable)e);
            }
        } else {
            this.doPut(resource, content);
        }
        this.firePutCompleted(resource, source);
    }

    private ArtifactType getArtifactType(MavenGavInfo gavInfo, String artifactModel) {
        String customAT = this.getParamFromRepositoryUrl("artifactType");
        if (gavInfo.getType().equals("pom")) {
            return ArtifactType.valueOf((String)"MavenPom");
        }
        if (this.isPrimaryArtifact(gavInfo) && customAT != null) {
            return ArtifactType.valueOf((String)customAT);
        }
        if (artifactModel != null) {
            return ArtifactType.valueOf((String)"ext", (String)artifactModel, (Boolean)true);
        }
        return ArtifactType.valueOf((String)ArtifactTypeEnum.Document.name());
    }

    private void doPut(Resource resource, InputStream resourceInputStream) throws TransferFailedException {
        MavenGavInfo gavInfo = MavenGavInfo.fromResource(resource);
        if (gavInfo.isHash()) {
            this.doPutHash(gavInfo, resourceInputStream);
        } else {
            this.doPutArtifact(gavInfo, resourceInputStream);
        }
    }

    private void doPutHash(MavenGavInfo gavInfo, InputStream resourceInputStream) throws TransferFailedException {
        this.logger.info(Messages.i18n.format("STORING_HASH_AS_PROP", new Object[]{gavInfo.getName()}));
        try {
            String hashPropName;
            String artyPath = gavInfo.getFullName();
            if (gavInfo.getType().endsWith(".md5")) {
                hashPropName = "maven.hash.md5";
                artyPath = artyPath.substring(0, artyPath.length() - 4);
            } else {
                hashPropName = "maven.hash.sha1";
                artyPath = artyPath.substring(0, artyPath.length() - 5);
            }
            String hashValue = IOUtils.toString((InputStream)resourceInputStream);
            ClassLoader oldCtxCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(SrampWagon.class.getClassLoader());
            try {
                SrampArchiveEntry entry = this.archive.getEntry(artyPath);
                BaseArtifactType metaData = this.client.getArtifactMetaData(entry.getMetaData().getUuid());
                SrampModelUtils.setCustomProperty((BaseArtifactType)metaData, (String)hashPropName, (String)hashValue);
                this.archive.updateEntry(entry, null);
                this.client.updateArtifactMetaData(metaData);
            }
            catch (Throwable t) {
                throw new TransferFailedException(t.getMessage(), t);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCtxCL);
            }
        }
        catch (Exception e) {
            throw new TransferFailedException(Messages.i18n.format("FAILED_TO_STORE_HASH", new Object[]{gavInfo.getName()}), (Throwable)e);
        }
    }

    private void doPutArtifact(final MavenGavInfo gavInfo, InputStream resourceInputStream) throws TransferFailedException {
        ClassLoader oldCtxCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SrampWagon.class.getClassLoader());
        File tempResourceFile = null;
        ZipToSrampArchive expander = null;
        SrampArchive archive = null;
        BaseArtifactType artifactGrouping = null;
        try {
            BaseArtifactType artifact;
            tempResourceFile = this.stashResourceContent(resourceInputStream);
            resourceInputStream = FileUtils.openInputStream((File)tempResourceFile);
            ArchiveInfo archiveInfo = ZipToSrampArchiveRegistry.inspectArchive((InputStream)resourceInputStream);
            ArtifactType artifactType = this.getArtifactType(gavInfo, archiveInfo.type);
            resourceInputStream = FileUtils.openInputStream((File)tempResourceFile);
            if (this.isPrimaryArtifact(gavInfo) && this.getParamFromRepositoryUrl("artifactGrouping") != null) {
                artifactGrouping = this.ensureArtifactGrouping();
            }
            if ((artifact = this.findExistingArtifactByGAV(this.client, gavInfo)) != null) {
                this.archive.addEntry(gavInfo.getFullName(), artifact, null);
                this.client.updateArtifactContent(artifact, resourceInputStream);
                if (ZipToSrampArchiveRegistry.canExpand((ArtifactType)artifactType)) {
                    String parentUUID = artifact.getUuid();
                    this.cleanExpandedArtifacts(this.client, parentUUID);
                }
            } else {
                artifact = this.client.uploadArtifact(artifactType, resourceInputStream, gavInfo.getName());
                SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.groupId", (String)gavInfo.getGroupId());
                SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.artifactId", (String)gavInfo.getArtifactId());
                SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.version", (String)gavInfo.getVersion());
                artifact.setVersion(gavInfo.getVersion());
                if (gavInfo.getClassifier() != null) {
                    SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.classifier", (String)gavInfo.getClassifier());
                }
                SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.type", (String)gavInfo.getType());
                if (artifactGrouping != null) {
                    SrampModelUtils.addGenericRelationship((BaseArtifactType)artifact, (String)"groupedBy", (String)artifactGrouping.getUuid());
                    SrampModelUtils.addGenericRelationship((BaseArtifactType)artifactGrouping, (String)"groups", (String)artifact.getUuid());
                    this.client.updateArtifactMetaData(artifactGrouping);
                }
                this.client.updateArtifactMetaData(artifact);
                this.archive.addEntry(gavInfo.getFullName(), artifact, null);
            }
            if ((expander = ZipToSrampArchiveRegistry.createExpander((ArtifactType)artifactType, (File)tempResourceFile)) != null) {
                expander.setContextParam("parent.uuid", (Object)artifact.getUuid());
                expander.addMetaDataProvider(new MetaDataProvider(){

                    public void provideMetaData(BaseArtifactType artifact) {
                        SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.parent-groupId", (String)gavInfo.getGroupId());
                        SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.parent-artifactId", (String)gavInfo.getArtifactId());
                        SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.parent-version", (String)gavInfo.getVersion());
                        SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.parent-type", (String)gavInfo.getType());
                    }
                });
                archive = expander.createSrampArchive();
                this.client.uploadBatch(archive);
            }
            Thread.currentThread().setContextClassLoader(oldCtxCL);
        }
        catch (Throwable t) {
            try {
                throw new TransferFailedException(t.getMessage(), t);
            }
            catch (Throwable throwable) {
                Thread.currentThread().setContextClassLoader(oldCtxCL);
                SrampArchive.closeQuietly(archive);
                ZipToSrampArchive.closeQuietly(expander);
                FileUtils.deleteQuietly((File)tempResourceFile);
                throw throwable;
            }
        }
        SrampArchive.closeQuietly(archive);
        ZipToSrampArchive.closeQuietly((ZipToSrampArchive)expander);
        FileUtils.deleteQuietly((File)tempResourceFile);
    }

    private BaseArtifactType ensureArtifactGrouping() throws SrampClientException, SrampAtomException {
        String groupingName = this.getParamFromRepositoryUrl("artifactGrouping");
        if (groupingName == null || groupingName.trim().length() == 0) {
            this.logger.warn(Messages.i18n.format("NO_ARTIFACT_GROUPING_NAME", new Object[0]));
            return null;
        }
        QueryResultSet query = this.client.buildQuery("/s-ramp/ext/ArtifactGrouping[@name = ?]").parameter(groupingName).count(2).query();
        if (query.size() > 1L) {
            this.logger.warn(Messages.i18n.format("MULTIPLE_ARTIFACT_GROUPSING_FOUND", new Object[]{groupingName}));
            return null;
        }
        if (query.size() == 1L) {
            ArtifactSummary summary = query.get(0);
            return this.client.getArtifactMetaData(summary.getType(), summary.getUuid());
        }
        ExtendedArtifactType groupingArtifact = new ExtendedArtifactType();
        groupingArtifact.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
        groupingArtifact.setExtendedType("ArtifactGrouping");
        groupingArtifact.setName(groupingName);
        groupingArtifact.setDescription(Messages.i18n.format("ARTIFACT_GROUPING_DESCRIPTION", new Object[0]));
        return this.client.createArtifact((BaseArtifactType)groupingArtifact);
    }

    private void cleanExpandedArtifacts(SrampAtomApiClient client, String parentUUID) throws SrampAtomException, SrampClientException {
        String query = String.format("/s-ramp[mavenParent[@uuid = '%1$s']]", parentUUID);
        boolean done = false;
        while (!done) {
            QueryResultSet rset = client.query(query, 0, 20, "name", true);
            if (rset.size() == 0L) {
                done = true;
                continue;
            }
            for (ArtifactSummary entry : rset) {
                ArtifactType artifactType = entry.getType();
                String uuid = entry.getUuid();
                client.deleteArtifact(uuid, artifactType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File stashResourceContent(InputStream resourceInputStream) throws IOException {
        File resourceTempFile = null;
        FileOutputStream oStream = null;
        try {
            resourceTempFile = File.createTempFile("s-ramp-wagon-resource", ".tmp");
            oStream = FileUtils.openOutputStream((File)resourceTempFile);
        }
        catch (Throwable throwable) {
            IOUtils.copy((InputStream)resourceInputStream, oStream);
            IOUtils.closeQuietly((InputStream)resourceInputStream);
            IOUtils.closeQuietly((OutputStream)oStream);
            throw throwable;
        }
        IOUtils.copy((InputStream)resourceInputStream, (OutputStream)oStream);
        IOUtils.closeQuietly((InputStream)resourceInputStream);
        IOUtils.closeQuietly((OutputStream)oStream);
        return resourceTempFile;
    }

    private BaseArtifactType findExistingArtifact(SrampAtomApiClient client, MavenGavInfo gavInfo) throws SrampAtomException, SrampClientException, JAXBException {
        BaseArtifactType artifact = this.findExistingArtifactByGAV(client, gavInfo);
        if (artifact == null) {
            artifact = this.findExistingArtifactByUniversal(client, gavInfo);
        }
        return artifact;
    }

    private BaseArtifactType findExistingArtifactByGAV(SrampAtomApiClient client, MavenGavInfo gavInfo) throws SrampAtomException, SrampClientException, JAXBException {
        SrampClientQuery clientQuery = null;
        clientQuery = gavInfo.getClassifier() == null ? client.buildQuery("/s-ramp[@maven.groupId = ? and @maven.artifactId = ? and @maven.version = ? and @maven.type = ?]").parameter(gavInfo.getGroupId()).parameter(gavInfo.getArtifactId()).parameter(gavInfo.getVersion()).parameter(gavInfo.getType()) : client.buildQuery("/s-ramp[@maven.groupId = ? and @maven.artifactId = ? and @maven.version = ? and @maven.classifier = ? and @maven.type = ?]").parameter(gavInfo.getGroupId()).parameter(gavInfo.getArtifactId()).parameter(gavInfo.getVersion()).parameter(gavInfo.getClassifier()).parameter(gavInfo.getType());
        QueryResultSet rset = clientQuery.count(100).query();
        if (rset.size() > 0L) {
            for (ArtifactSummary summary : rset) {
                String uuid = summary.getUuid();
                ArtifactType artifactType = summary.getType();
                BaseArtifactType arty = client.getArtifactMetaData(artifactType, uuid);
                if (gavInfo.getClassifier() == null) {
                    String artyClassifier = SrampModelUtils.getCustomProperty((BaseArtifactType)arty, (String)"maven.classifier");
                    if (artyClassifier != null) continue;
                    return arty;
                }
                return arty;
            }
        }
        return null;
    }

    private BaseArtifactType findExistingArtifactByUniversal(SrampAtomApiClient client, MavenGavInfo gavInfo) throws SrampAtomException, SrampClientException, JAXBException {
        String artifactType = gavInfo.getGroupId().substring(gavInfo.getGroupId().indexOf(46) + 1);
        String uuid = gavInfo.getArtifactId();
        try {
            return client.getArtifactMetaData(ArtifactType.valueOf((String)artifactType), uuid);
        }
        catch (Throwable t) {
            this.debug(t.getMessage());
            return null;
        }
    }

    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        throw new RuntimeException("Should never get here!");
    }

    protected String getParamFromRepositoryUrl(String paramName) {
        String[] params;
        String url = this.getRepository().getUrl();
        int idx = url.indexOf(63);
        if (idx == -1) {
            return null;
        }
        String query = url.substring(idx + 1);
        for (String paramPair : params = query.split("&")) {
            String[] pp = paramPair.split("=");
            if (pp.length == 2) {
                String key = pp[0];
                String val = pp[1];
                if (!key.equals(paramName)) continue;
                return val;
            }
            throw new RuntimeException(Messages.i18n.format("INVALID_QUERY_PARAM", new Object[0]));
        }
        return null;
    }

    protected boolean isPrimaryArtifact(MavenGavInfo gavInfo) {
        return gavInfo.getClassifier() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateHash(InputStream inputStream, String hashAlgorithm) throws Exception {
        try {
            MessageDigest md = MessageDigest.getInstance(hashAlgorithm);
            byte[] dataBytes = new byte[1024];
            int nread = 0;
            while ((nread = inputStream.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
            byte[] mdbytes = md.digest();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mdbytes.length; ++i) {
                sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
            }
            String string = sb.toString();
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private void debug(String message) {
        if (this.logger != null) {
            this.logger.debug(message);
        }
    }

    private void error(String message, Throwable t) {
        if (this.logger != null) {
            this.logger.error(message, t);
        }
    }
}

