/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.wagon.models;

import org.apache.maven.wagon.resource.Resource;
import org.junit.Assert;
import org.junit.Test;
import org.overlord.sramp.wagon.models.MavenGavInfo;

public class MavenGavInfoTest {
    private static final String[][] TEST_DATA = new String[][]{{"org/example/schema/my-schema/1.3/my-schema-1.3.xsd", "org.example.schema", "my-schema", "1.3", null, "xsd", "my-schema-1.3.xsd", "false", "false", null, "false"}, {"xsd/XsdDocument/29873-21983-2497822-1989/1.0/29873-21983-2497822-1989-1.0.pom", "xsd.XsdDocument", "29873-21983-2497822-1989", "1.0", null, "pom", "29873-21983-2497822-1989-1.0.pom", "false", "false", null, "false"}, {"org/apache/commons/commons-io/1.3.2/commons-io-1.3.2.jar", "org.apache.commons", "commons-io", "1.3.2", null, "jar", "commons-io-1.3.2.jar", "false", "false", null, "false"}, {"org/apache/commons/commons-io/1.3.2/commons-io-1.3.2.pom.sha1", "org.apache.commons", "commons-io", "1.3.2", null, "pom.sha1", "commons-io-1.3.2.pom.sha1", "true", "false", null, "false"}, {"org/apache/commons/commons-io/1.3.2/commons-io-1.3.2.jar.sha1", "org.apache.commons", "commons-io", "1.3.2", null, "jar.sha1", "commons-io-1.3.2.jar.sha1", "true", "false", null, "false"}, {"org/apache/commons/commons-io/1.3.2/commons-io-1.3.2-sources.jar", "org.apache.commons", "commons-io", "1.3.2", "sources", "jar", "commons-io-1.3.2-sources.jar", "false", "false", null, "false"}, {"org/apache/commons/commons-io/1.3.2/commons-io-1.3.2-sources.jar.md5", "org.apache.commons", "commons-io", "1.3.2", "sources", "jar.md5", "commons-io-1.3.2-sources.jar.md5", "true", "false", null, "false"}, {"org/overlord/sramp/test/test-wagon-push/0.0.1-SNAPSHOT/test-wagon-push-0.0.1-20120921.113704-1.jar", "org.overlord.sramp.test", "test-wagon-push", "0.0.1-SNAPSHOT", null, "jar", "test-wagon-push-0.0.1-20120921.113704-1.jar", "false", "true", "20120921.113704-1", "false"}, {"org/overlord/sramp/test/test-wagon-push/0.0.1-SNAPSHOT/test-wagon-push-0.0.1-20120921.113704-1-sources.jar.md5", "org.overlord.sramp.test", "test-wagon-push", "0.0.1-SNAPSHOT", "sources", "jar.md5", "test-wagon-push-0.0.1-20120921.113704-1-sources.jar.md5", "true", "true", "20120921.113704-1", "false"}, {"org/overlord/sramp/test/test-wagon-push/0.0.1-SNAPSHOT/test-wagon-push-0.0.1-20120921.113704-1.pom.sha1", "org.overlord.sramp.test", "test-wagon-push", "0.0.1-SNAPSHOT", null, "pom.sha1", "test-wagon-push-0.0.1-20120921.113704-1.pom.sha1", "true", "true", "20120921.113704-1", "false"}, {"org/apache/commons/commons-io/maven-metadata.xml", "org.apache.commons", "commons-io", null, null, "xml", "maven-metadata.xml", "false", "false", null, "true"}, {"org/apache/commons/commons-io/maven-metadata.xml.md5", "org.apache.commons", "commons-io", null, null, "xml.md5", "maven-metadata.xml.md5", "true", "false", null, "true"}, {"org/apache/commons/commons-io/1.0.7-SNAPSHOT/maven-metadata.xml", "org.apache.commons", "commons-io", "1.0.7-SNAPSHOT", null, "xml", "maven-metadata.xml", "false", "true", null, "true"}};

    @Test
    public void testFromResource() {
        for (String[] testCase : TEST_DATA) {
            String resourcePath = testCase[0];
            String expectedGroupId = testCase[1];
            String expectedArtifactId = testCase[2];
            String expectedVersion = testCase[3];
            String expectedClassifier = testCase[4];
            String expectedType = testCase[5];
            String expectedName = testCase[6];
            String expectedHash = testCase[7];
            String expectedSnapshot = testCase[8];
            String expectedSnapshotId = testCase[9];
            String expectedMetaData = testCase[10];
            MavenGavInfo gavInfo = MavenGavInfo.fromResource((Resource)new Resource(resourcePath));
            String helpfulMsg = "Failure in test case: " + resourcePath;
            Assert.assertEquals((String)helpfulMsg, (Object)expectedGroupId, (Object)gavInfo.getGroupId());
            Assert.assertEquals((String)helpfulMsg, (Object)expectedArtifactId, (Object)gavInfo.getArtifactId());
            Assert.assertEquals((String)helpfulMsg, (Object)expectedVersion, (Object)gavInfo.getVersion());
            Assert.assertEquals((String)helpfulMsg, (Object)expectedClassifier, (Object)gavInfo.getClassifier());
            Assert.assertEquals((String)helpfulMsg, (Object)expectedType, (Object)gavInfo.getType());
            Assert.assertEquals((String)helpfulMsg, (Object)expectedName, (Object)gavInfo.getName());
            Assert.assertEquals((String)helpfulMsg, (Object)expectedHash, (Object)String.valueOf(gavInfo.isHash()));
            Assert.assertEquals((String)helpfulMsg, (Object)expectedSnapshot, (Object)String.valueOf(gavInfo.isSnapshot()));
            Assert.assertEquals((String)helpfulMsg, (Object)expectedSnapshotId, (Object)gavInfo.getSnapshotId());
            Assert.assertEquals((String)helpfulMsg, (Object)expectedMetaData, (Object)String.valueOf(gavInfo.isMavenMetaData()));
        }
        MavenGavInfo gavInfo = MavenGavInfo.fromResource((Resource)new Resource("org/apache/commons/commons-io/maven-metadata.xml.md5"));
        Assert.assertEquals((Object)"MD5", (Object)gavInfo.getHashAlgorithm());
    }
}

