/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.eclipse;

import java.io.IOException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;
import org.pi4soa.cdl.CDLManager;
import org.pi4soa.cdl.Package;
import org.pi4soa.common.eclipse.BundleUtil;
import org.pi4soa.common.model.Model;
import org.pi4soa.common.resource.ResourceLocator;
import org.pi4soa.common.validation.eclipse.ValidationManager;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.pi4soa.cdl";
    private static Activator plugin;
    private static Logger logger;
    public static final String CDL_PLUGIN_ID = "org.pi4soa.cdl";
    public static final String CDL_VARIABLE = "PI4SOA_CDL";

    static {
        logger = Logger.getLogger("org.pi4soa.cdl.eclipse");
        BundleUtil.registerClasspathEntries((String)"org.pi4soa.cdl", (boolean)false);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.initialize();
    }

    protected void initialize() {
        try {
            ResourceBundle res = ResourceBundle.getBundle("cdl");
            ResourceLocator.setResourceBundle((String)"cdl", (ResourceBundle)res);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IResourceChangeListener rcl = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent evt) {
                try {
                    evt.getDelta().accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) {
                            boolean ret = true;
                            IResource res = delta.getResource();
                            if (Activator.this.isChangeRelevant(res, delta)) {
                                Activator.this.validateResource(res);
                            }
                            return ret;
                        }
                    });
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Failed to process resource change event", e);
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(rcl, 1);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void logError(String mesg, Throwable t) {
        if (Activator.getDefault() != null) {
            Status status = new Status(4, "org.pi4soa.cdl", 0, mesg, t);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        logger.severe("LOG ERROR: " + mesg + (t == null ? "" : ": " + t));
    }

    protected void validateResource(IResource res) {
        try {
            Package model = Activator.getPackage(res);
            ValidationManager.validate((Model)model, (IResource)res);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to schedule validation of CDL model", e);
        }
    }

    protected boolean isChangeRelevant(IResource res, IResourceDelta delta) {
        boolean ret = false;
        if (res != null && res.getFileExtension() != null && res.getFileExtension().equals("cdm") && ((delta.getFlags() & 0x100) != 0 || delta.getKind() == 1)) {
            ret = true;
        }
        return ret;
    }

    public static Package getPackage(IResource res) throws IOException, CoreException {
        Package ret = null;
        if (res instanceof IFile) {
            ret = CDLManager.load(((IFile)res).getLocation().toPortableString());
        }
        return ret;
    }
}

