/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.eclipse;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.pi4soa.cdl.CDLManager;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.eclipse.Activator;
import org.pi4soa.cdl.eclipse.WSCDLFileSelectionPage;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.resource.eclipse.ResourceUtil;
import org.pi4soa.common.xml.XMLUtils;
import org.w3c.dom.Document;

public class ExportCDLWizard
extends Wizard
implements IExportWizard {
    private static Logger logger = Logger.getLogger("org.pi4soa.cdl.eclipse");
    private IFile m_cdlFile = null;
    private WSCDLFileSelectionPage m_selectionPage = null;
    private static String PAGE_NAME = "Export Choreography Description As WS-CDL";
    private static String RESOURCE_NOT_SELECTED_ERROR = "A resource has not been selected";
    private static String RESOURCE_NOT_FILE_ERROR = "The selected resource is not a file";
    private static String RESOURCE_NOT_CDL_ERROR = "The selected file is not a valid CDL object model";
    private static String RESOURCE_ERROR = "Invalid CDL cannot be exported";

    public boolean performFinish() {
        boolean ret = true;
        if (this.m_cdlFile != null) {
            try {
                Package cdlpack = Activator.getPackage((IResource)this.m_cdlFile);
                ModelListener listener = new ModelListener(){

                    public void report(Object source, String mesg, int reportType) {
                    }

                    public void report(Object source, String mesg, int reportType, Properties props) {
                    }
                };
                Document doc = CDLManager.exportToWSCDL(cdlpack, listener);
                FileOutputStream xmlstr = new FileOutputStream(this.m_selectionPage.getFileName());
                XMLUtils.saveDocument((Document)doc, (OutputStream)xmlstr, (boolean)true);
                ((OutputStream)xmlstr).close();
            }
            catch (Exception e) {
                this.m_selectionPage.setErrorMessage("Failed to export CDL model as XML: " + e);
                logger.log(Level.SEVERE, "Failed to export CDL model as XML", e);
                ret = false;
            }
        }
        return ret;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        String errMesg = null;
        this.m_selectionPage = new WSCDLFileSelectionPage(PAGE_NAME, "Select a WSCDL file as the destination for the exported CDL", true);
        if (selection != null) {
            if (selection.getFirstElement() instanceof IFile) {
                this.m_cdlFile = (IFile)selection.getFirstElement();
                if (this.m_cdlFile.getFileExtension().equals("cdm")) {
                    if (ResourceUtil.hasErrors((IResource)this.m_cdlFile)) {
                        errMesg = RESOURCE_ERROR;
                    }
                } else {
                    errMesg = RESOURCE_NOT_CDL_ERROR;
                }
            } else {
                errMesg = RESOURCE_NOT_FILE_ERROR;
            }
        } else {
            errMesg = RESOURCE_NOT_SELECTED_ERROR;
        }
        if (errMesg != null) {
            this.m_selectionPage.setErrorMessage(errMesg);
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)this.m_selectionPage);
    }
}

