/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.eclipse;

import java.io.File;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class FileSelectionPage
extends WizardPage {
    private Text m_text = null;
    private Shell m_shell = null;
    private Button m_button = null;
    private boolean m_forExport = false;

    public FileSelectionPage(String pageName, String description, boolean forExport) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription(description);
        this.setPageComplete(false);
        this.m_forExport = forExport;
    }

    public void createControl(Composite parent) {
        this.m_shell = parent.getShell();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.m_text = new Text(composite, 2052);
        this.m_text.setLayoutData((Object)new GridData(768));
        if (this.getErrorMessage() == null) {
            this.m_text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String errMesg = null;
                    try {
                        File file = new File(FileSelectionPage.this.m_text.getText());
                        if (FileSelectionPage.this.isExtensionValid(file.getName())) {
                            if (file.exists() && file.isFile()) {
                                if (FileSelectionPage.this.m_forExport) {
                                    MessageBox box = new MessageBox(FileSelectionPage.this.m_shell, 192);
                                    box.setMessage("Overwrite existing file?");
                                    box.setText("WARNING");
                                    if (box.open() == 128) {
                                        errMesg = "The selected file already exists";
                                    }
                                }
                            } else if (!FileSelectionPage.this.m_forExport) {
                                errMesg = "The file does not exist";
                            }
                        } else {
                            errMesg = "Select a file with a valid extension (" + FileSelectionPage.this.getExtension() + ")";
                        }
                    }
                    catch (Exception exception) {}
                    if (errMesg != null) {
                        FileSelectionPage.this.setErrorMessage(errMesg);
                        FileSelectionPage.this.setPageComplete(false);
                    } else {
                        FileSelectionPage.this.setErrorMessage(null);
                        FileSelectionPage.this.setPageComplete(true);
                    }
                }
            });
        }
        this.m_button = new Button(composite, 0);
        this.m_button.setText("Browse");
        this.m_button.setToolTipText("Browse file system to locate destination file");
        this.m_button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent evt) {
                FileDialog dialog = new FileDialog(FileSelectionPage.this.m_shell);
                String filename = dialog.open();
                if (filename != null) {
                    filename = FileSelectionPage.this.preProcessFilename(filename);
                    FileSelectionPage.this.m_text.setText(filename);
                }
            }

            public void widgetDefaultSelected(SelectionEvent evt) {
            }
        });
        if (this.getErrorMessage() != null) {
            this.m_button.setEnabled(false);
            this.m_text.setEnabled(false);
            this.m_text.setEditable(false);
        }
        this.setControl((Control)composite);
    }

    protected String preProcessFilename(String filename) {
        return filename;
    }

    protected boolean isExtensionValid(String name) {
        return true;
    }

    protected String getExtension() {
        return null;
    }

    public String getFileName() {
        if (this.m_text == null) {
            return null;
        }
        return this.m_text.getText();
    }
}

