/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.pi4soa.cdl.Activity;
import org.pi4soa.cdl.CDLException;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.CDLVisitor;
import org.pi4soa.cdl.CdlFactory;
import org.pi4soa.cdl.CdlPackage;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.SemanticAnnotation;
import org.pi4soa.cdl.impl.ImportExportContext;
import org.pi4soa.cdl.util.CDLTypeUtil;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.resource.ResourceLocator;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationDefinitions;
import org.pi4soa.common.validation.ValidationException;
import org.pi4soa.common.xml.XMLUtils;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CDLTypeImpl
extends EObjectImpl
implements CDLType {
    public static final String TYPE = "type";
    protected static final String GETVARIABLE_PREFIX = "cdl:getVariable('";
    protected static final String GETVARIABLE_POSTFIX = "','','')";
    protected static final String TNS_PREFIX = "tns";
    protected static final String DESCRIPTION_EDEFAULT = null;
    protected String description = DESCRIPTION_EDEFAULT;
    protected EList<SemanticAnnotation> semanticAnnotations;
    public static final String DESCRIPTION_TAGNAME = "description";
    public static final String TYPE_DOCUMENTATION = "documentation";
    public static final String TYPE_REFERENCE = "reference";
    public static final String TYPE_SEMANTICS = "semantics";
    public static final String LIST_DELIMITER = " ";

    @Override
    public String getName() {
        return null;
    }

    protected void validateCDLType(ModelListener l, ValidationContext context) throws ValidationException {
        this.validateSyntax(l, context);
        for (Object obj : this.eContents()) {
            if (!(obj instanceof CDLTypeImpl)) continue;
            ((CDLTypeImpl)obj).validateCDLType(l, context);
        }
    }

    protected boolean isNamePrefixAllowed() {
        return false;
    }

    public void validateSyntax(ModelListener l, ValidationContext context) throws ValidationException {
        if (NamesUtil.isSet((String)this.getName())) {
            if (this.getName().indexOf(32) != -1) {
                l.report((Object)this, this.getMessage("_INVALID_CHAR", new Object[]{"name", "' '"}), 2, ValidationDefinitions.getPropertyNameInfo((String)"name"));
            } else if (!this.isNamePrefixAllowed() && this.getName().indexOf(58) != -1) {
                l.report((Object)this, this.getMessage("_INVALID_CHAR", new Object[]{"name", "':'"}), 2, ValidationDefinitions.getPropertyNameInfo((String)"name"));
            }
        }
        EList attrs = this.eClass().getEAllAttributes();
        int i = 0;
        while (i < attrs.size()) {
            EAttribute attr = (EAttribute)attrs.get(i);
            if (attr.isRequired() && attr.getEType().getInstanceClass() == String.class) {
                try {
                    String val = (String)this.eGet((EStructuralFeature)attr);
                    if (!this.isSet(val)) {
                        l.report((Object)this, this.getMessage("_REQUIRED_ATTRIBUTE", new Object[]{NamesUtil.getDisplayName((String)attr.getName())}), 2, ValidationDefinitions.getPropertyNameInfo((String)attr.getName()));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        EList refs = this.eClass().getEAllReferences();
        int i2 = 0;
        while (i2 < refs.size()) {
            EReference ref = (EReference)refs.get(i2);
            if (ref.isMany() && ref.getLowerBound() > 0) {
                List list = (List)this.eGet((EStructuralFeature)ref);
                if (list.size() < ref.getLowerBound()) {
                    l.report((Object)this, this.getMessage("_TOO_FEW_REFERENCES", new Object[]{NamesUtil.getDisplayName((String)ref.getName()), new Integer(ref.getLowerBound()), ref.getEType().getName()}), 2, ValidationDefinitions.getPropertyNameInfo((String)ref.getName()));
                }
            } else if (ref.isRequired() && !this.eIsSet((EStructuralFeature)ref)) {
                l.report((Object)this, this.getMessage("_REQUIRED_REFERENCE", new Object[]{NamesUtil.getDisplayName((String)ref.getName())}), 2, ValidationDefinitions.getPropertyNameInfo((String)ref.getName()));
            }
            ++i2;
        }
    }

    public void importFromDOMElement(Element elem, ModelListener l, ImportExportContext context) throws CDLException {
        NodeList nl = elem.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node instanceof Element && CDLTypeUtil.validNamespace(node)) {
                Element subelem = (Element)node;
                if (subelem.getNamespaceURI() != null && subelem.getNamespaceURI().equals("http://www.w3.org/2005/10/cdl") && subelem.getNodeName().equals(DESCRIPTION_TAGNAME)) {
                    this.importDescription(subelem, l);
                } else {
                    CDLType cdl = this.createCDLType(subelem, l);
                    if (cdl instanceof CDLTypeImpl) {
                        ((CDLTypeImpl)cdl).importFromDOMElement(subelem, l, context);
                    }
                }
            }
            ++i;
        }
    }

    protected void importDescription(Element elem, ModelListener l) {
        String type = elem.getAttribute(TYPE);
        if (type == null || type.equals(TYPE_DOCUMENTATION)) {
            this.setDescription(this.extractText(elem));
        } else if (type.equals(TYPE_SEMANTICS)) {
            SemanticAnnotation annotation = CdlFactory.eINSTANCE.createSemanticAnnotation();
            annotation.setAnnotation(this.extractText(elem));
            if (elem.hasAttributeNS("http://www.pi4soa.org/choreography", "name")) {
                annotation.setName(elem.getAttributeNS("http://www.pi4soa.org/choreography", "name"));
            } else {
                annotation.setName("<undefined>");
            }
            this.getSemanticAnnotations().add((Object)annotation);
        }
    }

    protected String extractText(Element elem) {
        String ret = null;
        NodeList nl = elem.getChildNodes();
        CharacterData text = null;
        int i = 0;
        while (text == null && i < nl.getLength()) {
            if (nl.item(i) instanceof Text) {
                text = (Text)nl.item(i);
            }
            ++i;
        }
        if (text != null) {
            String desc = text.getData().trim();
            int pos = 0;
            while (pos < desc.length() && Character.isWhitespace(desc.charAt(pos))) {
                ++pos;
            }
            ret = desc.substring(pos);
        }
        return ret;
    }

    public void initialize(ModelListener l) {
        for (Object obj : this.eContents()) {
            if (!(obj instanceof CDLTypeImpl)) continue;
            ((CDLTypeImpl)obj).initialize(l);
        }
    }

    protected CDLType createCDLType(Element elem, ModelListener l) {
        return null;
    }

    public static Activity createActivity(Element elem, ModelListener l) {
        Activity ret = null;
        String name = elem.getNodeName();
        if (name.equals("assign")) {
            ret = CdlFactory.eINSTANCE.createAssign();
        } else if (name.equals("choice")) {
            ret = CdlFactory.eINSTANCE.createChoice();
        } else if (name.equals("finalize")) {
            ret = CdlFactory.eINSTANCE.createFinalize();
        } else if (name.equals("interaction")) {
            ret = CdlFactory.eINSTANCE.createInteraction();
        } else if (name.equals("noAction")) {
            ret = CdlFactory.eINSTANCE.createNoAction();
        } else if (name.equals("parallel")) {
            ret = CdlFactory.eINSTANCE.createParallel();
        } else if (name.equals("perform")) {
            ret = CdlFactory.eINSTANCE.createPerform();
        } else if (name.equals("sequence")) {
            ret = CdlFactory.eINSTANCE.createSequence();
        } else if (name.equals("silentAction")) {
            ret = CdlFactory.eINSTANCE.createSilentAction();
        } else if (name.equals("workunit")) {
            ret = elem.hasAttribute("block") && !elem.getAttribute("block").equalsIgnoreCase("false") ? CdlFactory.eINSTANCE.createWhen() : (elem.hasAttribute("repeat") && NamesUtil.isSet((String)elem.getAttribute("repeat")) && !elem.getAttribute("repeat").equalsIgnoreCase(Boolean.FALSE.toString()) ? CdlFactory.eINSTANCE.createWhile() : CdlFactory.eINSTANCE.createConditional());
        }
        return ret;
    }

    protected String getExportTagname() {
        return null;
    }

    protected String getExportNamespace() {
        return "http://www.w3.org/2005/10/cdl";
    }

    public Element exportAsDOMElement(Node parent, ModelListener l, ImportExportContext context) throws CDLException {
        Element ret = null;
        ret = this.createCDLElement(parent, this.getExportTagname(), this.getExportNamespace());
        if (this.isSet(this.getDescription())) {
            Element description = this.createCDLElement(parent, DESCRIPTION_TAGNAME);
            description.setAttribute(TYPE, TYPE_DOCUMENTATION);
            Text text = this.createCDLTextNode(parent, this.getDescription());
            description.appendChild(text);
            ret.appendChild(description);
        }
        for (SemanticAnnotation annotation : this.getSemanticAnnotations()) {
            if (!this.isSet(annotation.getAnnotation())) continue;
            Element description = this.createCDLElement(parent, DESCRIPTION_TAGNAME);
            description.setAttribute(TYPE, TYPE_SEMANTICS);
            if (this.isSet(annotation.getName())) {
                description.setAttribute("xmlns:pi4soa", "http://www.pi4soa.org/choreography");
                description.setAttribute("pi4soa:name", annotation.getName());
            }
            Text text = this.createCDLTextNode(parent, annotation.getAnnotation());
            description.appendChild(text);
            ret.appendChild(description);
        }
        parent.appendChild(ret);
        return ret;
    }

    protected Element createCDLElement(Node docNode, String name) {
        Element ret = this.createCDLElement(docNode, name, "http://www.w3.org/2005/10/cdl");
        return ret;
    }

    protected Element createCDLElement(Node docNode, String name, String namespace) {
        Element ret = null;
        ret = docNode instanceof Document ? ((Document)docNode).createElementNS(namespace, name) : docNode.getOwnerDocument().createElementNS(namespace, name);
        return ret;
    }

    protected Text createCDLTextNode(Node docNode, String text) {
        Text ret = null;
        ret = docNode instanceof Document ? ((Document)docNode).createTextNode(text) : docNode.getOwnerDocument().createTextNode(text);
        return ret;
    }

    protected boolean isSet(String value) {
        return value != null && value.trim().length() > 0;
    }

    protected boolean isSet(Boolean value, boolean def) {
        boolean ret = def;
        if (value != null) {
            ret = value;
        }
        return ret;
    }

    protected static void exportAsDOMElement(CDLType cdlobject, Node parent, ModelListener l, ImportExportContext context) throws CDLException {
        if (cdlobject instanceof CDLTypeImpl) {
            ((CDLTypeImpl)cdlobject).exportAsDOMElement(parent, l, context);
        }
    }

    protected void exportListAsDOMElements(List list, Node parent, ModelListener l, ImportExportContext context) throws CDLException {
        if (list != null) {
            for (CDLTypeImpl cdl : list) {
                cdl.exportAsDOMElement(parent, l, context);
            }
        }
    }

    protected String exportValue(String value) {
        String ret = null;
        if (value != null) {
            ret = value.toLowerCase().replace('_', '-');
        }
        return ret;
    }

    protected String importValue(String value) {
        String ret = null;
        if (this.isSet(value)) {
            ret = String.valueOf(value.toUpperCase().charAt(0)) + value.substring(1).replace('-', '_');
        }
        return ret;
    }

    protected Boolean importBoolean(String value, boolean defaultValue) {
        Boolean ret = null;
        ret = value != null && value.equalsIgnoreCase("true") ? Boolean.TRUE : (value != null && value.equalsIgnoreCase("false") ? Boolean.FALSE : Boolean.valueOf(defaultValue));
        return ret;
    }

    @Override
    public Package getPackage() {
        Package ret = null;
        if (this.eContainer() instanceof CDLTypeImpl) {
            ret = ((CDLTypeImpl)this.eContainer()).getPackage();
        }
        return ret;
    }

    @Override
    public Choreography getEnclosingChoreography() {
        Choreography ret = null;
        if (this.eContainer() instanceof CDLType) {
            ret = ((CDLType)this.eContainer()).getEnclosingChoreography();
        }
        return ret;
    }

    protected CDLType getNamedCDLType(String name, List list) {
        CDLType ret = null;
        String namespace = null;
        String targetNamespace = null;
        if (this.getPackage() != null) {
            targetNamespace = this.getPackage().getTargetNamespace();
        }
        if (targetNamespace == null || (namespace = CDLTypeUtil.getNamespace(name, this, true)) != null && namespace.equals(targetNamespace)) {
            Iterator iter = list.iterator();
            while (ret == null && iter.hasNext()) {
                CDLType type = (CDLType)iter.next();
                if (type.getName() == null || !type.getName().equals(XMLUtils.getLocalname((String)name))) continue;
                ret = type;
            }
        }
        return ret;
    }

    protected CDLType getQNamedCDLType(String name, List list) {
        CDLType ret = null;
        String namespace = CDLTypeUtil.getNamespace(name, this);
        String localpart = XMLUtils.getLocalname((String)name);
        Iterator iter = list.iterator();
        while (ret == null && iter.hasNext()) {
            CDLType type = (CDLType)iter.next();
            String ns = CDLTypeUtil.getNamespace(type.getName(), this);
            String lp = XMLUtils.getLocalname((String)type.getName());
            if ((ns != null || namespace != null) && (ns == null || namespace == null || !ns.equals(namespace)) || lp == null || localpart == null || !lp.equals(localpart)) continue;
            ret = type;
        }
        return ret;
    }

    @Override
    public RoleType[] getRoleTypesForContext() {
        if (this.eContainer() instanceof CDLTypeImpl) {
            return ((CDLTypeImpl)this.eContainer()).getRoleTypesForContext();
        }
        return new RoleType[0];
    }

    protected boolean isAssociatedWithRoleType(RoleType roleType) {
        boolean ret = false;
        if (roleType != null) {
            ret = this.isRoleTypeAssociatedWithContext(roleType.getName());
        }
        return ret;
    }

    @Override
    public boolean isRoleTypeAssociatedWithContext(String roleType) {
        boolean ret = false;
        RoleType[] types = this.getRoleTypesForContext();
        int i = 0;
        while (types != null && roleType != null && !ret && i < types.length) {
            if (types[i] != null && types[i].getName() != null && types[i].getName().equals(roleType)) {
                ret = true;
            }
            ++i;
        }
        return ret;
    }

    @Override
    public boolean isRelevantToRoleType(RoleType roleType) {
        boolean ret = false;
        Iterator iter = this.eContents().iterator();
        while (!ret && iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof CDLTypeImpl)) continue;
            ret = ((CDLTypeImpl)obj).isRelevantToRoleType(roleType);
        }
        return ret;
    }

    @Override
    public boolean isRelevantToRoleTypes(RoleType[] roleTypes) {
        boolean ret = false;
        int i = 0;
        while (!ret && i < roleTypes.length) {
            if (this.isRelevantToRoleType(roleTypes[i])) {
                ret = true;
            }
            ++i;
        }
        return ret;
    }

    @Override
    public boolean isGroupingConstruct() {
        return false;
    }

    @Override
    public boolean isConditionalGroupingConstruct() {
        return false;
    }

    @Override
    public boolean isSequentialGroupingConstruct() {
        return false;
    }

    protected Vector getAggregatedVisibleRoleTypes() {
        Vector<String> ret = new Vector<String>();
        for (Object obj : this.eContents()) {
            if (!(obj instanceof CDLTypeImpl)) continue;
            Vector sub = ((CDLTypeImpl)obj).getAggregatedVisibleRoleTypes();
            for (String subrole : sub) {
                if (ret.contains(subrole)) continue;
                ret.add(subrole);
            }
        }
        return ret;
    }

    @Override
    public CDLType getParent() {
        CDLTypeImpl ret = null;
        if (this.eContainer() instanceof CDLTypeImpl) {
            ret = (CDLTypeImpl)this.eContainer();
        }
        return ret;
    }

    protected String getMessage(String key, Object[] params) {
        return ResourceLocator.getMessage((String)"cdl", (String)key, (Object[])params);
    }

    @Override
    public void visit(CDLVisitor visitor) {
        for (Object obj : this.eContents()) {
            if (!(obj instanceof CDLTypeImpl)) continue;
            ((CDLTypeImpl)obj).visit(visitor);
        }
    }

    protected static String addTNS(String localname) {
        return "tns:" + localname;
    }

    protected CDLTypeImpl() {
    }

    protected EClass eStaticClass() {
        return CdlPackage.Literals.CDL_TYPE;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String newDescription) {
        String oldDescription = this.description;
        this.description = newDescription;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldDescription, (Object)this.description));
        }
    }

    @Override
    public EList<SemanticAnnotation> getSemanticAnnotations() {
        if (this.semanticAnnotations == null) {
            this.semanticAnnotations = new EObjectContainmentEList(SemanticAnnotation.class, (InternalEObject)this, 1);
        }
        return this.semanticAnnotations;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getSemanticAnnotations()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getDescription();
            }
            case 1: {
                return this.getSemanticAnnotations();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setDescription((String)newValue);
                return;
            }
            case 1: {
                this.getSemanticAnnotations().clear();
                this.getSemanticAnnotations().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setDescription(DESCRIPTION_EDEFAULT);
                return;
            }
            case 1: {
                this.getSemanticAnnotations().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return DESCRIPTION_EDEFAULT == null ? this.description != null : !DESCRIPTION_EDEFAULT.equals(this.description);
            }
            case 1: {
                return this.semanticAnnotations != null && !this.semanticAnnotations.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (description: ");
        result.append(this.description);
        result.append(')');
        return result.toString();
    }
}

