/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.pi4soa.cdl.Behavior;
import org.pi4soa.cdl.CDLException;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.CdlFactory;
import org.pi4soa.cdl.CdlPackage;
import org.pi4soa.cdl.ChannelActionType;
import org.pi4soa.cdl.ChannelType;
import org.pi4soa.cdl.Identity;
import org.pi4soa.cdl.KeyType;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.PassingChannelDetails;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.Token;
import org.pi4soa.cdl.UsageType;
import org.pi4soa.cdl.impl.DataTypeImpl;
import org.pi4soa.cdl.impl.ImportExportContext;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationDefinitions;
import org.pi4soa.common.validation.ValidationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelTypeImpl
extends DataTypeImpl
implements ChannelType {
    private static final String KEYTYPE = "type";
    public static final String ACTION = "action";
    public static final String USAGE = "usage";
    public static final String BEHAVIOR = "behavior";
    public static final String TYPEREF = "typeRef";
    public static final String PASSING = "passing";
    public static final String NAME = "name";
    public static final String CHANNELTYPE_TAGNAME = "channelType";
    public static final String ROLETYPE_TAGNAME = "roleType";
    public static final String REFERENCE_TAGNAME = "reference";
    public static final String IDENTITY_TAGNAME = "identity";
    public static final String TOKEN_TAGNAME = "token";
    protected static final UsageType USAGE_EDEFAULT = UsageType.DISTINCT;
    protected UsageType usage = USAGE_EDEFAULT;
    protected static final ChannelActionType ACTION_EDEFAULT = ChannelActionType.REQUEST_RESPOND;
    protected ChannelActionType action = ACTION_EDEFAULT;
    protected EList<PassingChannelDetails> passingChannelDetails;
    protected Behavior behavior;
    protected Token referenceToken;
    protected EList<Identity> identities;
    protected RoleType roleType;

    @Override
    public int getClassification() {
        return 2;
    }

    @Override
    protected String getExportTagname() {
        return CHANNELTYPE_TAGNAME;
    }

    @Override
    public Element exportAsDOMElement(Node parent, ModelListener l, ImportExportContext context) throws CDLException {
        Element elem = super.exportAsDOMElement(parent, l, context);
        if (this.getName() != null) {
            elem.setAttribute(NAME, this.getName());
        }
        if (this.getUsage() != null && this.getUsage() != USAGE_EDEFAULT) {
            elem.setAttribute(USAGE, this.exportValue(this.getUsage().getName()));
        }
        if (this.getAction() != null && this.getAction() != ACTION_EDEFAULT) {
            elem.setAttribute(ACTION, this.exportValue(this.getAction().getName()));
        }
        this.exportListAsDOMElements((List)this.getPassingChannelDetails(), elem, l, context);
        Element role = elem.getOwnerDocument().createElement(ROLETYPE_TAGNAME);
        if (this.getRoleType() != null) {
            role.setAttribute(TYPEREF, ChannelTypeImpl.addTNS(this.getRoleType().getName()));
        }
        if (this.getBehavior() != null) {
            role.setAttribute(BEHAVIOR, this.getBehavior().getName());
        }
        elem.appendChild(role);
        Element reference = elem.getOwnerDocument().createElement(REFERENCE_TAGNAME);
        if (this.getReferenceToken() != null) {
            Element reftoken = elem.getOwnerDocument().createElement(TOKEN_TAGNAME);
            reftoken.setAttribute(NAME, ChannelTypeImpl.addTNS(this.getReferenceToken().getName()));
            reference.appendChild(reftoken);
        }
        elem.appendChild(reference);
        if (this.getIdentities() != null && this.getIdentities().size() > 0) {
            int i = 0;
            while (i < this.getIdentities().size()) {
                Element identity = elem.getOwnerDocument().createElement(IDENTITY_TAGNAME);
                Identity id = (Identity)this.getIdentities().get(i);
                identity.setAttribute(KEYTYPE, this.exportValue(id.getType().getName()));
                for (Token idtoken : id.getTokens()) {
                    Element idelem = elem.getOwnerDocument().createElement(TOKEN_TAGNAME);
                    idelem.setAttribute(NAME, ChannelTypeImpl.addTNS(idtoken.getName()));
                    identity.appendChild(idelem);
                }
                elem.appendChild(identity);
                ++i;
            }
        }
        return elem;
    }

    @Override
    public void importFromDOMElement(Element elem, ModelListener l, ImportExportContext context) throws CDLException {
        if (elem != null && elem.getNodeName().equals(CHANNELTYPE_TAGNAME)) {
            NodeList roles;
            ChannelActionType action;
            this.setName(elem.getAttribute(NAME));
            UsageType usage = UsageType.get(this.importValue(elem.getAttribute(USAGE)));
            if (usage != null) {
                this.setUsage(usage);
            }
            if ((action = ChannelActionType.get(this.importValue(elem.getAttribute(ACTION)))) != null) {
                this.setAction(action);
            }
            if ((roles = elem.getElementsByTagName(ROLETYPE_TAGNAME)).getLength() == 1) {
                this.importRole((Element)roles.item(0), l);
            } else if (roles.getLength() == 0) {
                l.report((Object)this, this.getMessage("_NO_ROLE_FOR_CHANNEL_TYPE", new Object[]{this.getName()}), 2);
            } else {
                l.report((Object)this, this.getMessage("_ONLY_ONE_ROLE_FOR_CHANNEL_TYPE", new Object[]{this.getName()}), 2);
            }
            NodeList refs = elem.getElementsByTagName(REFERENCE_TAGNAME);
            if (refs.getLength() == 1) {
                this.importReference((Element)refs.item(0), l);
            } else if (refs.getLength() == 0) {
                l.report((Object)this, this.getMessage("_NO_REFERENCE_FOR_CHANNEL_TYPE", new Object[]{this.getName()}), 2);
            } else {
                l.report((Object)this, this.getMessage("_ONLY_ONE_REFERENCE_FOR_CHANNEL_TYPE", new Object[]{this.getName()}), 2);
            }
            NodeList ids = elem.getElementsByTagName(IDENTITY_TAGNAME);
            int i = 0;
            while (i < ids.getLength()) {
                this.importIdentity((Element)ids.item(i), l);
                ++i;
            }
        }
        super.importFromDOMElement(elem, l, context);
    }

    protected void importRole(Element elem, ModelListener l) {
        String roleTypeName = elem.getAttribute(TYPEREF);
        Package cdlpack = this.getPackage();
        if (cdlpack != null) {
            RoleType roleType = cdlpack.getRoleType(roleTypeName);
            if (roleType != null) {
                this.setRoleType(roleType);
                String behaviorName = elem.getAttribute(BEHAVIOR);
                if (this.isSet(behaviorName)) {
                    Behavior behavior = roleType.getBehavior(behaviorName);
                    if (behavior != null) {
                        this.setBehavior(behavior);
                    } else {
                        l.report((Object)this, this.getMessage("_NOT_FOUND_BEHAVIOR_ON_ROLE_TYPE", new Object[]{behaviorName, roleTypeName}), 2);
                    }
                }
            } else {
                l.report((Object)this, this.getMessage("_NOT_FOUND_ROLE_TYPE", new Object[]{roleTypeName}), 2);
            }
        }
    }

    protected void importReference(Element elem, ModelListener l) {
        NodeList tokens = elem.getElementsByTagName(TOKEN_TAGNAME);
        if (tokens.getLength() == 0) {
            l.report((Object)this, this.getMessage("_MISSING_CHILD_NODE", new Object[]{"Token", "Reference"}), 2);
        } else if (tokens.getLength() > 1) {
            l.report((Object)this, this.getMessage("TOO_MANY_CHILD_NODES", new Object[]{"Token", "Reference"}), 2);
        } else {
            Token token = this.importToken((Element)tokens.item(0), l);
            this.setReferenceToken(token);
        }
    }

    protected void importIdentity(Element elem, ModelListener l) {
        NodeList tokens = elem.getElementsByTagName(TOKEN_TAGNAME);
        if (tokens.getLength() == 0) {
            l.report((Object)this, this.getMessage("_MISSING_CHILD_NODE", new Object[]{"Token", "Identity"}), 2);
        } else {
            Identity identity = CdlFactory.eINSTANCE.createIdentity();
            KeyType key = KeyType.get(this.importValue(elem.getAttribute(KEYTYPE)));
            if (key != null) {
                identity.setType(key);
            }
            int i = 0;
            while (i < tokens.getLength()) {
                Token token = this.importToken((Element)tokens.item(i), l);
                if (token != null) {
                    identity.getTokens().add((Object)token);
                }
                ++i;
            }
            this.getIdentities().add((Object)identity);
        }
    }

    protected Token importToken(Element elem, ModelListener l) {
        Token ret = null;
        String type = elem.getAttribute(NAME);
        if (this.isSet(type)) {
            Package cdlpack = this.getPackage();
            if (cdlpack != null && (ret = cdlpack.getToken(type)) == null) {
                l.report((Object)this, this.getMessage("_NOT_FOUND_TOKEN", new Object[]{type}), 2);
            }
        } else {
            l.report((Object)this, this.getMessage("_ATTRIBUTE_NOT_SPECIFIED", new Object[]{"Token", NAME}), 2);
        }
        return ret;
    }

    @Override
    protected CDLType createCDLType(Element elem, ModelListener l) {
        PassingChannelDetails ret = null;
        String name = elem.getNodeName();
        if (name.equals(PASSING)) {
            ret = CdlFactory.eINSTANCE.createPassingChannelDetails();
            this.getPassingChannelDetails().add((Object)ret);
        }
        return ret;
    }

    @Override
    public PassingChannelDetails getPassingChannelDetails(ChannelType passed) {
        PassingChannelDetails ret = null;
        Iterator iter = this.getPassingChannelDetails().iterator();
        while (ret == null && iter.hasNext()) {
            ret = (PassingChannelDetails)iter.next();
            if (ret.getChannel() == passed) continue;
            ret = null;
        }
        return ret;
    }

    @Override
    public void validateSyntax(ModelListener l, ValidationContext context) throws ValidationException {
        super.validateSyntax(l, context);
        Package cdlpack = this.getPackage();
        if (cdlpack != null && this.isSet(this.getName()) && cdlpack.getChannelType(this.getName()) != this) {
            l.report((Object)this, this.getMessage("_NAME_NOT_UNIQUE", null), 2, ValidationDefinitions.getPropertyNameInfo((String)NAME));
        }
        if (this.getBehavior() != null && this.getRoleType() != null && !this.getRoleType().getBehaviors().contains((Object)this.getBehavior())) {
            l.report((Object)this, this.getMessage("_NOT_FOUND_BEHAVIOR_ON_ROLE_TYPE", new String[]{this.getBehavior().getName(), this.getRoleType().getName()}), 2, ValidationDefinitions.getPropertyNameInfo((String)BEHAVIOR));
        }
    }

    protected ChannelTypeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return CdlPackage.Literals.CHANNEL_TYPE;
    }

    @Override
    public UsageType getUsage() {
        return this.usage;
    }

    @Override
    public void setUsage(UsageType newUsage) {
        UsageType oldUsage = this.usage;
        UsageType usageType = this.usage = newUsage == null ? USAGE_EDEFAULT : newUsage;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldUsage, (Object)this.usage));
        }
    }

    @Override
    public ChannelActionType getAction() {
        return this.action;
    }

    @Override
    public void setAction(ChannelActionType newAction) {
        ChannelActionType oldAction = this.action;
        ChannelActionType channelActionType = this.action = newAction == null ? ACTION_EDEFAULT : newAction;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldAction, (Object)this.action));
        }
    }

    @Override
    public EList<PassingChannelDetails> getPassingChannelDetails() {
        if (this.passingChannelDetails == null) {
            this.passingChannelDetails = new EObjectContainmentEList(PassingChannelDetails.class, (InternalEObject)this, 5);
        }
        return this.passingChannelDetails;
    }

    @Override
    public Behavior getBehavior() {
        if (this.behavior != null && this.behavior.eIsProxy()) {
            InternalEObject oldBehavior = (InternalEObject)this.behavior;
            this.behavior = (Behavior)this.eResolveProxy(oldBehavior);
            if (this.behavior != oldBehavior && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 6, (Object)oldBehavior, (Object)this.behavior));
            }
        }
        return this.behavior;
    }

    public Behavior basicGetBehavior() {
        return this.behavior;
    }

    @Override
    public void setBehavior(Behavior newBehavior) {
        Behavior oldBehavior = this.behavior;
        this.behavior = newBehavior;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldBehavior, (Object)this.behavior));
        }
    }

    @Override
    public Token getReferenceToken() {
        if (this.referenceToken != null && this.referenceToken.eIsProxy()) {
            InternalEObject oldReferenceToken = (InternalEObject)this.referenceToken;
            this.referenceToken = (Token)this.eResolveProxy(oldReferenceToken);
            if (this.referenceToken != oldReferenceToken && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 7, (Object)oldReferenceToken, (Object)this.referenceToken));
            }
        }
        return this.referenceToken;
    }

    public Token basicGetReferenceToken() {
        return this.referenceToken;
    }

    @Override
    public void setReferenceToken(Token newReferenceToken) {
        Token oldReferenceToken = this.referenceToken;
        this.referenceToken = newReferenceToken;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldReferenceToken, (Object)this.referenceToken));
        }
    }

    @Override
    public EList<Identity> getIdentities() {
        if (this.identities == null) {
            this.identities = new EObjectContainmentEList(Identity.class, (InternalEObject)this, 8);
        }
        return this.identities;
    }

    @Override
    public RoleType getRoleType() {
        if (this.roleType != null && this.roleType.eIsProxy()) {
            InternalEObject oldRoleType = (InternalEObject)this.roleType;
            this.roleType = (RoleType)this.eResolveProxy(oldRoleType);
            if (this.roleType != oldRoleType && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 9, (Object)oldRoleType, (Object)this.roleType));
            }
        }
        return this.roleType;
    }

    public RoleType basicGetRoleType() {
        return this.roleType;
    }

    @Override
    public void setRoleType(RoleType newRoleType) {
        RoleType oldRoleType = this.roleType;
        this.roleType = newRoleType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldRoleType, (Object)this.roleType));
        }
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 5: {
                return ((InternalEList)this.getPassingChannelDetails()).basicRemove((Object)otherEnd, msgs);
            }
            case 8: {
                return ((InternalEList)this.getIdentities()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getUsage();
            }
            case 4: {
                return this.getAction();
            }
            case 5: {
                return this.getPassingChannelDetails();
            }
            case 6: {
                if (resolve) {
                    return this.getBehavior();
                }
                return this.basicGetBehavior();
            }
            case 7: {
                if (resolve) {
                    return this.getReferenceToken();
                }
                return this.basicGetReferenceToken();
            }
            case 8: {
                return this.getIdentities();
            }
            case 9: {
                if (resolve) {
                    return this.getRoleType();
                }
                return this.basicGetRoleType();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.setUsage((UsageType)((Object)newValue));
                return;
            }
            case 4: {
                this.setAction((ChannelActionType)((Object)newValue));
                return;
            }
            case 5: {
                this.getPassingChannelDetails().clear();
                this.getPassingChannelDetails().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.setBehavior((Behavior)newValue);
                return;
            }
            case 7: {
                this.setReferenceToken((Token)newValue);
                return;
            }
            case 8: {
                this.getIdentities().clear();
                this.getIdentities().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.setRoleType((RoleType)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.setUsage(USAGE_EDEFAULT);
                return;
            }
            case 4: {
                this.setAction(ACTION_EDEFAULT);
                return;
            }
            case 5: {
                this.getPassingChannelDetails().clear();
                return;
            }
            case 6: {
                this.setBehavior(null);
                return;
            }
            case 7: {
                this.setReferenceToken(null);
                return;
            }
            case 8: {
                this.getIdentities().clear();
                return;
            }
            case 9: {
                this.setRoleType(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return this.usage != USAGE_EDEFAULT;
            }
            case 4: {
                return this.action != ACTION_EDEFAULT;
            }
            case 5: {
                return this.passingChannelDetails != null && !this.passingChannelDetails.isEmpty();
            }
            case 6: {
                return this.behavior != null;
            }
            case 7: {
                return this.referenceToken != null;
            }
            case 8: {
                return this.identities != null && !this.identities.isEmpty();
            }
            case 9: {
                return this.roleType != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (usage: ");
        result.append((Object)this.usage);
        result.append(", action: ");
        result.append((Object)this.action);
        result.append(')');
        return result.toString();
    }
}

