/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.impl;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.pi4soa.cdl.Activity;
import org.pi4soa.cdl.CDLException;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.CDLVisitor;
import org.pi4soa.cdl.CdlPackage;
import org.pi4soa.cdl.ExceptionWorkUnit;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.impl.CDLTypeImpl;
import org.pi4soa.cdl.impl.ImportExportContext;
import org.pi4soa.cdl.impl.SequenceImpl;
import org.pi4soa.cdl.util.CDLTypeUtil;
import org.pi4soa.cdl.xpath.DefaultXPathContext;
import org.pi4soa.cdl.xpath.ValidationResult;
import org.pi4soa.cdl.xpath.XPathContext;
import org.pi4soa.cdl.xpath.XPathValidator;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationDefinitions;
import org.pi4soa.common.validation.ValidationException;
import org.pi4soa.common.xml.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionWorkUnitImpl
extends CDLTypeImpl
implements ExceptionWorkUnit {
    protected static final String EXCEPTION_TYPE_EDEFAULT = null;
    private boolean m_checkingIfRelevant = false;
    public static final String BLOCK = "block";
    public static final String REPEAT = "repeat";
    public static final String GUARD = "guard";
    public static final String NAME = "name";
    public static final String WORKUNIT_TAGNAME = "workunit";
    protected String exceptionType = EXCEPTION_TYPE_EDEFAULT;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected EList<Activity> activities;

    @Override
    protected String getExportTagname() {
        return WORKUNIT_TAGNAME;
    }

    @Override
    public Element exportAsDOMElement(Node parent, ModelListener l, ImportExportContext context) throws CDLException {
        Element elem = super.exportAsDOMElement(parent, l, context);
        if (this.getName() != null) {
            elem.setAttribute(NAME, this.getName());
        }
        if (this.getExceptionType() != null) {
            elem.setAttribute(GUARD, "cdl:hasExceptionOccurred('" + this.getExceptionType() + "')");
        }
        Element base = elem;
        if (this.getActivities().size() > 1) {
            base = this.createCDLElement(parent, "sequence");
            elem.appendChild(base);
        }
        this.exportListAsDOMElements((List)this.getActivities(), base, l, context);
        return elem;
    }

    @Override
    public void importFromDOMElement(Element elem, ModelListener l, ImportExportContext context) throws CDLException {
        if (elem != null && elem.getNodeName().equals(WORKUNIT_TAGNAME)) {
            if (elem.hasAttribute(NAME)) {
                this.setName(elem.getAttribute(NAME));
            }
            if (elem.hasAttribute(GUARD)) {
                String excTypeName = "<unknown>";
                XPathContext xpcontext = DefaultXPathContext.createContext(this, this.getEnclosingChoreography(), l, this.getMessage("_GUARD_CONDITION", null), true);
                ValidationResult result = XPathValidator.validateExceptionType(xpcontext, this.getPackage(), this.getRoleTypesForContext(), elem.getAttribute(GUARD));
                if (result != null) {
                    excTypeName = result.getExceptionTypeName();
                }
                if (excTypeName != null) {
                    this.setExceptionType(excTypeName);
                }
            }
            if (elem.hasAttribute(REPEAT)) {
                l.report((Object)this, this.getMessage("_WORKUNIT_EXCEPTION_NOT_REPEAT", null), 2);
            }
            if (elem.hasAttribute(BLOCK) && elem.getAttribute(BLOCK).equalsIgnoreCase(Boolean.TRUE.toString())) {
                l.report((Object)this, this.getMessage("_WORKUNIT_EXCEPTION_NOT_BLOCK", null), 2);
            }
        }
        super.importFromDOMElement(elem, l, context);
        if (this.getActivities().size() == 1 && this.getActivities().get(0) instanceof SequenceImpl) {
            SequenceImpl seq = (SequenceImpl)this.getActivities().get(0);
            while (seq.getActivities().size() > 0) {
                Activity act = (Activity)seq.getActivities().get(0);
                seq.getActivities().remove(0);
                this.getActivities().add((Object)act);
            }
            this.getActivities().remove(0);
        }
    }

    @Override
    protected CDLType createCDLType(Element elem, ModelListener l) {
        Activity ret = null;
        Activity act = ExceptionWorkUnitImpl.createActivity(elem, l);
        if (act != null) {
            ret = act;
            this.getActivities().add((Object)act);
        }
        return ret;
    }

    @Override
    public void validateSyntax(ModelListener l, ValidationContext context) throws ValidationException {
        String namespace;
        super.validateSyntax(l, context);
        if (NamesUtil.isSet((String)this.getExceptionType()) && (namespace = CDLTypeUtil.getNamespace(this.getExceptionType(), this, true)) == null && XMLUtils.getPrefix((String)this.getExceptionType()) != null) {
            l.report((Object)this, this.getMessage("_UNDEFINED_NAMESPACE", new Object[]{this.getExceptionType()}), 2, ValidationDefinitions.getPropertyNameInfo((String)"exceptionType"));
        }
    }

    @Override
    public synchronized boolean isRelevantToRoleType(RoleType roleType) {
        boolean ret = false;
        if (!this.m_checkingIfRelevant) {
            this.m_checkingIfRelevant = true;
            if (this.getEnclosingChoreography() != null) {
                ret = this.getEnclosingChoreography().isRelevantToRoleType(roleType);
            }
            this.m_checkingIfRelevant = false;
        }
        return ret;
    }

    @Override
    public boolean isGroupingConstruct() {
        return true;
    }

    @Override
    public boolean isSequentialGroupingConstruct() {
        return true;
    }

    @Override
    public void visit(CDLVisitor visitor) {
        visitor.exceptionWorkUnitStart(this);
        super.visit(visitor);
        visitor.exceptionWorkUnitEnd(this);
    }

    protected ExceptionWorkUnitImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return CdlPackage.Literals.EXCEPTION_WORK_UNIT;
    }

    @Override
    public String getExceptionType() {
        return this.exceptionType;
    }

    @Override
    public void setExceptionType(String newExceptionType) {
        String oldExceptionType = this.exceptionType;
        this.exceptionType = newExceptionType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldExceptionType, (Object)this.exceptionType));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public EList<Activity> getActivities() {
        if (this.activities == null) {
            this.activities = new EObjectContainmentEList(Activity.class, (InternalEObject)this, 4);
        }
        return this.activities;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return ((InternalEList)this.getActivities()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getExceptionType();
            }
            case 3: {
                return this.getName();
            }
            case 4: {
                return this.getActivities();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setExceptionType((String)newValue);
                return;
            }
            case 3: {
                this.setName((String)newValue);
                return;
            }
            case 4: {
                this.getActivities().clear();
                this.getActivities().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setExceptionType(EXCEPTION_TYPE_EDEFAULT);
                return;
            }
            case 3: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 4: {
                this.getActivities().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return EXCEPTION_TYPE_EDEFAULT == null ? this.exceptionType != null : !EXCEPTION_TYPE_EDEFAULT.equals(this.exceptionType);
            }
            case 3: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 4: {
                return this.activities != null && !this.activities.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (exceptionType: ");
        result.append(this.exceptionType);
        result.append(", name: ");
        result.append(this.name);
        result.append(')');
        return result.toString();
    }
}

