/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.pi4soa.cdl.CDLException;
import org.pi4soa.cdl.CdlPackage;
import org.pi4soa.cdl.ChannelActionType;
import org.pi4soa.cdl.ChannelType;
import org.pi4soa.cdl.DataType;
import org.pi4soa.cdl.ExchangeActionType;
import org.pi4soa.cdl.ExchangeDetails;
import org.pi4soa.cdl.Identity;
import org.pi4soa.cdl.InformationType;
import org.pi4soa.cdl.Interaction;
import org.pi4soa.cdl.KeyType;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.PassingChannelDetails;
import org.pi4soa.cdl.RecordDetails;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.Token;
import org.pi4soa.cdl.TokenLocator;
import org.pi4soa.cdl.Variable;
import org.pi4soa.cdl.impl.CDLTypeImpl;
import org.pi4soa.cdl.impl.ImportExportContext;
import org.pi4soa.cdl.util.CDLTypeUtil;
import org.pi4soa.cdl.util.ChoreographyUtil;
import org.pi4soa.cdl.util.InteractionUtil;
import org.pi4soa.cdl.xpath.DefaultXPathContext;
import org.pi4soa.cdl.xpath.ValidationResult;
import org.pi4soa.cdl.xpath.XPathContext;
import org.pi4soa.cdl.xpath.XPathValidator;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationDefinitions;
import org.pi4soa.common.validation.ValidationException;
import org.pi4soa.common.xml.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExchangeDetailsImpl
extends CDLTypeImpl
implements ExchangeDetails {
    public static final String CAUSEEXCEPTION = "causeException";
    public static final String INFORMATIONTYPE = "informationType";
    public static final String CHANNELTYPE = "channelType";
    public static final String RECEIVE = "receive";
    public static final String RECORDREFERENCE = "recordReference";
    public static final String VARIABLE = "variable";
    public static final String SEND = "send";
    public static final String ACTION = "action";
    public static final String NAME = "name";
    public static final String FAULTNAME = "faultName";
    public static final String EXCHANGEDETAILS_TAGNAME = "exchange";
    private String m_sendRecordReferences = null;
    private String m_recvRecordReferences = null;
    private String m_sendVariable = null;
    private String m_receiveVariable = null;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected DataType type;
    protected static final ExchangeActionType ACTION_EDEFAULT = ExchangeActionType.REQUEST;
    protected ExchangeActionType action = ACTION_EDEFAULT;
    protected Variable sendVariable;
    protected Variable receiveVariable;
    protected static final String SEND_CAUSE_EXCEPTION_EDEFAULT = null;
    protected String sendCauseException = SEND_CAUSE_EXCEPTION_EDEFAULT;
    protected static final String RECEIVE_CAUSE_EXCEPTION_EDEFAULT = null;
    protected String receiveCauseException = RECEIVE_CAUSE_EXCEPTION_EDEFAULT;
    protected static final String SEND_VARIABLE_PART_EDEFAULT = null;
    protected String sendVariablePart = SEND_VARIABLE_PART_EDEFAULT;
    protected static final String RECEIVE_VARIABLE_PART_EDEFAULT = null;
    protected String receiveVariablePart = RECEIVE_VARIABLE_PART_EDEFAULT;
    protected EList<RecordDetails> sendRecordDetails;
    protected EList<RecordDetails> receiveRecordDetails;
    protected static final String FAULT_NAME_EDEFAULT = null;
    protected String faultName = FAULT_NAME_EDEFAULT;

    @Override
    protected String getExportTagname() {
        return EXCHANGEDETAILS_TAGNAME;
    }

    @Override
    public Element exportAsDOMElement(Node parent, ModelListener l, ImportExportContext context) throws CDLException {
        String tag;
        Element elem = super.exportAsDOMElement(parent, l, context);
        if (this.getName() != null) {
            elem.setAttribute(NAME, this.getName());
        }
        if ((tag = this.getTypeClassificationTag()) != null) {
            elem.setAttribute(tag, ExchangeDetailsImpl.addTNS(this.getType().getName()));
        }
        if (this.getAction() != null) {
            String action = this.getAction().getName();
            if (!context.isVersionSupported(2) && this.getAction() == ExchangeActionType.NOTIFY) {
                action = ExchangeActionType.RESPOND.getName();
            }
            elem.setAttribute(ACTION, this.exportValue(action));
        }
        if (NamesUtil.isSet((String)this.getFaultName())) {
            elem.setAttribute(FAULTNAME, this.getFaultName());
        }
        Element sendelem = this.createCDLElement(elem, SEND);
        if (this.getSendVariable() != null) {
            String func = "cdl:getVariable('" + this.getSendVariable().getName();
            func = this.isSet(this.getSendVariablePart()) ? String.valueOf(func) + "','" + this.getSendVariablePart() + "','')" : String.valueOf(func) + "','','')";
            sendelem.setAttribute(VARIABLE, func);
        }
        if (NamesUtil.isSet((String)this.getSendCauseException())) {
            sendelem.setAttribute(CAUSEEXCEPTION, this.getSendCauseException());
        }
        String refs = "";
        for (RecordDetails rec : this.getSendRecordDetails()) {
            if (refs != null && refs.trim().length() > 0) {
                refs = String.valueOf(refs) + " ";
            }
            refs = String.valueOf(refs) + rec.getName();
        }
        if (refs != null && refs.trim().length() > 0) {
            sendelem.setAttribute(RECORDREFERENCE, refs);
        }
        elem.appendChild(sendelem);
        Element recvelem = elem.getOwnerDocument().createElementNS("http://www.w3.org/2005/10/cdl", RECEIVE);
        if (this.getReceiveVariable() != null) {
            String func = "cdl:getVariable('" + this.getReceiveVariable().getName();
            func = this.isSet(this.getReceiveVariablePart()) ? String.valueOf(func) + "','" + this.getReceiveVariablePart() + "','')" : String.valueOf(func) + "','','')";
            recvelem.setAttribute(VARIABLE, func);
        }
        if (NamesUtil.isSet((String)this.getReceiveCauseException())) {
            recvelem.setAttribute(CAUSEEXCEPTION, this.getReceiveCauseException());
        }
        refs = "";
        for (RecordDetails rec : this.getReceiveRecordDetails()) {
            if (refs != null && refs.trim().length() > 0) {
                refs = String.valueOf(refs) + " ";
            }
            refs = String.valueOf(refs) + rec.getName();
        }
        if (refs != null && refs.trim().length() > 0) {
            recvelem.setAttribute(RECORDREFERENCE, refs);
        }
        elem.appendChild(recvelem);
        return elem;
    }

    protected String getTypeClassificationTag() {
        String ret = null;
        if (this.getType() != null) {
            switch (this.getType().getClassification()) {
                case 2: {
                    ret = CHANNELTYPE;
                    break;
                }
                default: {
                    ret = INFORMATIONTYPE;
                }
            }
        }
        return ret;
    }

    @Override
    public void importFromDOMElement(Element elem, ModelListener l, ImportExportContext context) throws CDLException {
        if (elem != null && elem.getNodeName().equals(EXCHANGEDETAILS_TAGNAME)) {
            ExchangeActionType action;
            String type;
            this.setName(elem.getAttribute(NAME));
            Package cdlpack = this.getPackage();
            if (elem.hasAttribute(INFORMATIONTYPE)) {
                type = elem.getAttribute(INFORMATIONTYPE);
                if (cdlpack != null) {
                    InformationType infoType = cdlpack.getInformationType(type);
                    if (infoType != null) {
                        this.setType(infoType);
                    } else {
                        l.report((Object)this, this.getMessage("_NOT_FOUND_INFO_TYPE", new Object[]{type}), 2);
                    }
                }
            } else if (elem.hasAttribute(CHANNELTYPE)) {
                type = elem.getAttribute(CHANNELTYPE);
                if (cdlpack != null) {
                    ChannelType channelType = cdlpack.getChannelType(type);
                    if (channelType != null) {
                        this.setType(channelType);
                    } else {
                        l.report((Object)this, this.getMessage("_NOT_FOUND_CHANNEL_TYPE", new Object[]{type}), 2);
                    }
                }
            }
            if ((action = ExchangeActionType.get(this.importValue(elem.getAttribute(ACTION)))) != null) {
                this.setAction(action);
            }
            if (elem.hasAttribute(FAULTNAME)) {
                this.setFaultName(elem.getAttribute(FAULTNAME));
            }
            NodeList sendNode = elem.getElementsByTagName(SEND);
            NodeList recvNode = elem.getElementsByTagName(RECEIVE);
            if (sendNode.getLength() == 1) {
                Element sendElem = (Element)sendNode.item(0);
                this.m_sendVariable = sendElem.getAttribute(VARIABLE);
                if (sendElem.hasAttribute(CAUSEEXCEPTION)) {
                    this.setSendCauseException(sendElem.getAttribute(CAUSEEXCEPTION));
                }
                this.m_sendRecordReferences = sendElem.getAttribute(RECORDREFERENCE);
            } else {
                l.report((Object)this, this.getMessage("_ONLY_SINGLE_CHILD_NODE", new Object[]{SEND, EXCHANGEDETAILS_TAGNAME}), 2);
            }
            if (recvNode.getLength() == 1) {
                Element recvElem = (Element)recvNode.item(0);
                this.m_receiveVariable = recvElem.getAttribute(VARIABLE);
                if (recvElem.hasAttribute(CAUSEEXCEPTION)) {
                    this.setReceiveCauseException(recvElem.getAttribute(CAUSEEXCEPTION));
                }
                this.m_recvRecordReferences = recvElem.getAttribute(RECORDREFERENCE);
            } else {
                l.report((Object)this, this.getMessage("_ONLY_SINGLE_CHILD_NODE", new Object[]{RECEIVE, EXCHANGEDETAILS_TAGNAME}), 2);
            }
        }
        super.importFromDOMElement(elem, l, context);
    }

    @Override
    public void initialize(ModelListener l) {
        XPathContext context;
        ValidationResult res;
        super.initialize(l);
        if (this.isSet(this.m_sendRecordReferences)) {
            this.initRecordRefs(this.m_sendRecordReferences, (List)this.getSendRecordDetails(), this.getMessage("_SEND_RECORD_REFERENCES", null), l);
        }
        if (this.isSet(this.m_recvRecordReferences)) {
            this.initRecordRefs(this.m_recvRecordReferences, (List)this.getReceiveRecordDetails(), this.getMessage("_RECEIVE_RECORD_REFERENCES", null), l);
        }
        if (this.isSet(this.m_sendVariable) && (res = XPathValidator.validateVariable(context = DefaultXPathContext.createContext(this, this.getEnclosingChoreography(), l, this.getMessage("_SEND_VARIABLE", null)), this.m_sendVariable, this.getRoleTypesForContext(), false)) != null) {
            this.setSendVariable(res.getVariable());
            if (this.isSet(res.getPartName())) {
                this.setSendVariablePart(res.getPartName());
            }
        }
        if (this.isSet(this.m_receiveVariable) && (res = XPathValidator.validateVariable(context = DefaultXPathContext.createContext(this, this.getEnclosingChoreography(), l, this.getMessage("_RECEIVE_VARIABLE", null)), this.m_receiveVariable, this.getRoleTypesForContext(), false)) != null) {
            this.setReceiveVariable(res.getVariable());
            if (this.isSet(res.getPartName())) {
                this.setReceiveVariablePart(res.getPartName());
            }
        }
    }

    protected void initRecordRefs(String refs, List list, String mesgPrefix, ModelListener l) {
        StringTokenizer st = new StringTokenizer(refs, " ");
        Interaction interaction = this.getInteraction();
        if (interaction != null) {
            while (st.hasMoreTokens()) {
                String ref = st.nextToken();
                RecordDetails rec = interaction.getRecordDetail(ref);
                if (rec == null) {
                    l.report((Object)this, this.getMessage("_NOT_FOUND_RECORD_REFERENCE", new Object[]{mesgPrefix, ref}), 2);
                    continue;
                }
                list.add(rec);
            }
        }
    }

    @Override
    public void validateSyntax(ModelListener l, ValidationContext context) throws ValidationException {
        String receiveLabel = this.getMessage("_RECEIVE_VARIABLE", null);
        String sendLabel = this.getMessage("_SEND_VARIABLE", null);
        super.validateSyntax(l, context);
        this.validateVariable(this.getSendVariable(), false, sendLabel, l, "sendVariable");
        this.validateVariable(this.getReceiveVariable(), true, receiveLabel, l, "receiveVariable");
        if (this.eContainer() instanceof Interaction) {
            Interaction interaction = (Interaction)this.eContainer();
            RoleType fromRole = interaction.getFromRoleType();
            RoleType toRole = interaction.getToRoleType();
            String directionFrom = "from";
            String directionTo = "to";
            if (this.getAction() != ExchangeActionType.REQUEST) {
                RoleType tmp = fromRole;
                fromRole = toRole;
                toRole = tmp;
                String tmpDirection = directionFrom;
                directionFrom = directionTo;
                directionTo = tmpDirection;
            }
            if (this.getSendVariable() != null && fromRole != null && !this.getSendVariable().isRoleTypeAssociatedWithContext(fromRole.getName())) {
                l.report((Object)this, this.getMessage("_VARIABLE_INTERACTION_ROLE", new Object[]{sendLabel, directionFrom}), 2, ValidationDefinitions.getPropertyNameInfo((String)"sendVariable"));
            }
            if (this.getReceiveVariable() != null && toRole != null && !this.getReceiveVariable().isRoleTypeAssociatedWithContext(toRole.getName())) {
                l.report((Object)this, this.getMessage("_VARIABLE_INTERACTION_ROLE", new Object[]{receiveLabel, directionTo}), 2, ValidationDefinitions.getPropertyNameInfo((String)"receiveVariable"));
            }
            if (interaction.getChannelVariable() != null && interaction.getChannelVariable().getType() instanceof ChannelType) {
                ChannelType ctype = (ChannelType)interaction.getChannelVariable().getType();
                if (this.getAction() == ExchangeActionType.REQUEST && ctype.getAction() == ChannelActionType.RESPOND || this.getAction() != ExchangeActionType.REQUEST && ctype.getAction() == ChannelActionType.REQUEST) {
                    l.report((Object)this, this.getMessage("_INCOMPATIBLE_ACTIONS", new Object[]{this.getAction().getName(), ctype.getAction().getName()}), 2, ValidationDefinitions.getPropertyNameInfo((String)ACTION));
                }
            }
        }
        this.validateRecordDetails((List)this.getSendRecordDetails(), this.getMessage("_SEND_RECORD_REFERENCES", null), l, "sendRecordDetails");
        this.validateRecordDetails((List)this.getReceiveRecordDetails(), this.getMessage("_RECEIVE_RECORD_REFERENCES", null), l, "receiveRecordDetails");
        this.validateFault(l);
        this.validateException(l);
        this.validateIdentity(l);
        this.validateType(l);
        this.validateAction(l);
    }

    protected void validateRecordDetails(List recs, String mesgPrefix, ModelListener l, String propName) {
        Interaction interaction = this.getInteraction();
        if (interaction != null) {
            for (RecordDetails rec : recs) {
                if (interaction.getRecordDetails().contains((Object)rec)) continue;
                l.report((Object)this, this.getMessage("_NOT_FOUND_RECORD_REFERENCE", new Object[]{mesgPrefix, rec.getName()}), 2, ValidationDefinitions.getPropertyNameInfo((String)propName));
            }
        }
    }

    protected void validateVariable(Variable variable, boolean receive, String mesgPrefix, ModelListener l, String propName) {
        if (variable != null) {
            if (variable.getEnclosingChoreography() != this.getEnclosingChoreography()) {
                l.report((Object)this, this.getMessage("_NOT_FOUND_VARIABLE_IN_CHOREO", new Object[]{variable.getName(), this.getEnclosingChoreography().getName()}), 2, ValidationDefinitions.getPropertyNameInfo((String)propName));
            }
            if (this.getType() != null && variable.getType() != null && !variable.getType().equals(this.getType())) {
                l.report((Object)this, this.getMessage("_VARIABLE_EXCHANGE_TYPE", new Object[]{mesgPrefix}), 2, ValidationDefinitions.getPropertyNameInfo((String)propName));
            }
            if (receive && variable.getSilent() != null && variable.getSilent().booleanValue()) {
                l.report((Object)this, this.getMessage("_VARIABLE_MUST_NOT_BE_SILENT", new Object[]{mesgPrefix}), 2, ValidationDefinitions.getPropertyNameInfo((String)propName));
            }
        }
    }

    protected void validateFault(ModelListener l) {
        if (NamesUtil.isSet((String)this.getFaultName())) {
            String namespace = CDLTypeUtil.getNamespace(this.getFaultName(), this);
            if (namespace == null && XMLUtils.getPrefix((String)this.getFaultName()) != null) {
                l.report((Object)this, this.getMessage("_UNDEFINED_NAMESPACE", new Object[]{this.getFaultName()}), 2, ValidationDefinitions.getPropertyNameInfo((String)FAULTNAME));
            }
            if (this.getAction() != ExchangeActionType.RESPOND) {
                l.report((Object)this, this.getMessage("_ONLY_SPECIFY_FAULT_ON_RESPONSE", new Object[]{this.getFaultName()}), 2, ValidationDefinitions.getPropertyNameInfo((String)ACTION));
            }
        }
    }

    protected void validateException(ModelListener l) {
        if (NamesUtil.isSet((String)this.getSendCauseException()) || NamesUtil.isSet((String)this.getReceiveCauseException())) {
            if (this.getAction().equals((Object)ExchangeActionType.REQUEST)) {
                l.report((Object)this, this.getMessage("_REQUEST_EXCHANGE_EXCEPTION", null), 2, ValidationDefinitions.getPropertyNameInfo((String)ACTION));
            } else {
                String namespace;
                if (NamesUtil.isSet((String)this.getSendCauseException())) {
                    namespace = CDLTypeUtil.getNamespace(this.getSendCauseException(), this, true);
                    if (namespace == null) {
                        l.report((Object)this, this.getMessage("_UNDEFINED_NAMESPACE", new Object[]{this.getSendCauseException()}), 2, ValidationDefinitions.getPropertyNameInfo((String)"sendCauseException"));
                    } else if (!ChoreographyUtil.isExceptionTypeHandled(this.getSendCauseException(), this.getEnclosingChoreography())) {
                        l.report((Object)this, this.getMessage("_EXCEPTION_TYPE_NOT_HANDLED", new Object[]{this.getSendCauseException()}), 1, ValidationDefinitions.getPropertyNameInfo((String)"sendCauseException"));
                    }
                }
                if (NamesUtil.isSet((String)this.getReceiveCauseException())) {
                    namespace = CDLTypeUtil.getNamespace(this.getReceiveCauseException(), this, true);
                    if (namespace == null) {
                        l.report((Object)this, this.getMessage("_UNDEFINED_NAMESPACE", new Object[]{this.getReceiveCauseException()}), 2, ValidationDefinitions.getPropertyNameInfo((String)"receiveCauseException"));
                    } else if (!ChoreographyUtil.isExceptionTypeHandled(this.getReceiveCauseException(), this.getEnclosingChoreography())) {
                        l.report((Object)this, this.getMessage("_EXCEPTION_TYPE_NOT_HANDLED", new Object[]{this.getReceiveCauseException()}), 1, ValidationDefinitions.getPropertyNameInfo((String)"receiveCauseException"));
                    }
                }
            }
        }
    }

    protected void validateIdentity(ModelListener l) {
        ChannelType ctype = null;
        if (this.getInteraction() != null && this.getInteraction().getChannelVariable() != null && this.getInteraction().getChannelVariable().getType() instanceof ChannelType) {
            ctype = (ChannelType)this.getInteraction().getChannelVariable().getType();
        }
        if (this.getPackage() != null && ctype != null && ctype.getIdentities().size() > 0) {
            Iterator iter = ctype.getIdentities().iterator();
            boolean identityFound = false;
            InformationType infoType = null;
            String tokenList = "";
            if (this.getType() instanceof InformationType) {
                infoType = (InformationType)this.getType();
            } else if (this.getType() instanceof ChannelType && ((ChannelType)this.getType()).getReferenceToken() != null) {
                infoType = ((ChannelType)this.getType()).getReferenceToken().getInformationType();
            }
            while (infoType != null && !identityFound && iter.hasNext()) {
                Identity identity = (Identity)iter.next();
                if (identity.getType() != KeyType.PRIMARY && identity.getType() != KeyType.ALTERNATE) continue;
                identityFound = true;
                EList<Token> tokens = identity.getTokens();
                String tokenNames = null;
                int i = 0;
                while (i < tokens.size()) {
                    Token token = (Token)tokens.get(i);
                    TokenLocator locator = this.getPackage().getTokenLocator(token.getName(), infoType);
                    if (locator == null) {
                        identityFound = false;
                        tokenNames = tokenNames == null ? "" : String.valueOf(tokenNames) + ",";
                        tokenNames = String.valueOf(tokenNames) + token.getName();
                    }
                    ++i;
                }
                if (identityFound) continue;
                tokenList = tokenNames;
            }
            if (!identityFound) {
                if (infoType != null) {
                    l.report((Object)this, this.getMessage("_IDENTITY_MISSING", new Object[]{ctype.getName(), infoType.getName(), tokenList}), 2);
                } else {
                    l.report((Object)this, this.getMessage("_EXCHANGE_TYPE_REQUIRED", new Object[]{ctype.getName()}), 2);
                }
            }
        }
    }

    protected void validateType(ModelListener l) {
        if (this.getType() instanceof ChannelType) {
            PassingChannelDetails pcd = null;
            ChannelType ctype = null;
            if (this.getInteraction() != null && this.getInteraction().getChannelVariable() != null && this.getInteraction().getChannelVariable().getType() instanceof ChannelType) {
                ctype = (ChannelType)this.getInteraction().getChannelVariable().getType();
                pcd = ctype.getPassingChannelDetails((ChannelType)this.getType());
            }
            if (pcd != null) {
                if (this.getAction() == ExchangeActionType.REQUEST && pcd.getAction() == ChannelActionType.RESPOND || this.getAction() != ExchangeActionType.REQUEST && pcd.getAction() == ChannelActionType.REQUEST) {
                    l.report((Object)this, this.getMessage("_PASSING_CHANNEL_EXCHANGE_ACTION", new Object[]{this.getType().getName(), ctype.getName(), this.getAction().getName()}), 2);
                }
            } else if (ctype != null) {
                l.report((Object)this, this.getMessage("_PASSING_CHANNEL", new Object[]{this.getType().getName(), ctype.getName()}), 2);
            }
        }
    }

    protected void validateAction(ModelListener l) {
        List<ExchangeDetails> reqs;
        if (this.getAction() == ExchangeActionType.RESPOND && ((reqs = InteractionUtil.getRequestExchangeDetails(this)) == null || reqs.size() == 0)) {
            l.report((Object)this, this.getMessage("_NOT_FOUND_REQUEST_FOR_RESPONSE", new Object[0]), 2);
        }
    }

    @Override
    public Interaction getInteraction() {
        Interaction ret = null;
        if (this.eContainer() instanceof Interaction) {
            ret = (Interaction)this.eContainer();
        }
        return ret;
    }

    @Override
    public boolean isFault() {
        boolean ret = false;
        ret = NamesUtil.isSet((String)this.getFaultName());
        return ret;
    }

    protected ExchangeDetailsImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return CdlPackage.Literals.EXCHANGE_DETAILS;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public DataType getType() {
        if (this.type != null && this.type.eIsProxy()) {
            InternalEObject oldType = (InternalEObject)this.type;
            this.type = (DataType)this.eResolveProxy(oldType);
            if (this.type != oldType && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 3, (Object)oldType, (Object)this.type));
            }
        }
        return this.type;
    }

    public DataType basicGetType() {
        return this.type;
    }

    @Override
    public void setType(DataType newType) {
        DataType oldType = this.type;
        this.type = newType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldType, (Object)this.type));
        }
    }

    @Override
    public ExchangeActionType getAction() {
        return this.action;
    }

    @Override
    public void setAction(ExchangeActionType newAction) {
        ExchangeActionType oldAction = this.action;
        ExchangeActionType exchangeActionType = this.action = newAction == null ? ACTION_EDEFAULT : newAction;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldAction, (Object)this.action));
        }
    }

    @Override
    public Variable getSendVariable() {
        if (this.sendVariable != null && this.sendVariable.eIsProxy()) {
            InternalEObject oldSendVariable = (InternalEObject)this.sendVariable;
            this.sendVariable = (Variable)this.eResolveProxy(oldSendVariable);
            if (this.sendVariable != oldSendVariable && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 5, (Object)oldSendVariable, (Object)this.sendVariable));
            }
        }
        return this.sendVariable;
    }

    public Variable basicGetSendVariable() {
        return this.sendVariable;
    }

    @Override
    public void setSendVariable(Variable newSendVariable) {
        Variable oldSendVariable = this.sendVariable;
        this.sendVariable = newSendVariable;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldSendVariable, (Object)this.sendVariable));
        }
    }

    @Override
    public Variable getReceiveVariable() {
        if (this.receiveVariable != null && this.receiveVariable.eIsProxy()) {
            InternalEObject oldReceiveVariable = (InternalEObject)this.receiveVariable;
            this.receiveVariable = (Variable)this.eResolveProxy(oldReceiveVariable);
            if (this.receiveVariable != oldReceiveVariable && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 6, (Object)oldReceiveVariable, (Object)this.receiveVariable));
            }
        }
        return this.receiveVariable;
    }

    public Variable basicGetReceiveVariable() {
        return this.receiveVariable;
    }

    @Override
    public void setReceiveVariable(Variable newReceiveVariable) {
        Variable oldReceiveVariable = this.receiveVariable;
        this.receiveVariable = newReceiveVariable;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldReceiveVariable, (Object)this.receiveVariable));
        }
    }

    @Override
    public String getSendCauseException() {
        return this.sendCauseException;
    }

    @Override
    public void setSendCauseException(String newSendCauseException) {
        String oldSendCauseException = this.sendCauseException;
        this.sendCauseException = newSendCauseException;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldSendCauseException, (Object)this.sendCauseException));
        }
    }

    @Override
    public String getReceiveCauseException() {
        return this.receiveCauseException;
    }

    @Override
    public void setReceiveCauseException(String newReceiveCauseException) {
        String oldReceiveCauseException = this.receiveCauseException;
        this.receiveCauseException = newReceiveCauseException;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldReceiveCauseException, (Object)this.receiveCauseException));
        }
    }

    @Override
    public String getSendVariablePart() {
        return this.sendVariablePart;
    }

    @Override
    public void setSendVariablePart(String newSendVariablePart) {
        String oldSendVariablePart = this.sendVariablePart;
        this.sendVariablePart = newSendVariablePart;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldSendVariablePart, (Object)this.sendVariablePart));
        }
    }

    @Override
    public String getReceiveVariablePart() {
        return this.receiveVariablePart;
    }

    @Override
    public void setReceiveVariablePart(String newReceiveVariablePart) {
        String oldReceiveVariablePart = this.receiveVariablePart;
        this.receiveVariablePart = newReceiveVariablePart;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldReceiveVariablePart, (Object)this.receiveVariablePart));
        }
    }

    @Override
    public EList<RecordDetails> getSendRecordDetails() {
        if (this.sendRecordDetails == null) {
            this.sendRecordDetails = new EObjectResolvingEList(RecordDetails.class, (InternalEObject)this, 11);
        }
        return this.sendRecordDetails;
    }

    @Override
    public EList<RecordDetails> getReceiveRecordDetails() {
        if (this.receiveRecordDetails == null) {
            this.receiveRecordDetails = new EObjectResolvingEList(RecordDetails.class, (InternalEObject)this, 12);
        }
        return this.receiveRecordDetails;
    }

    @Override
    public String getFaultName() {
        return this.faultName;
    }

    @Override
    public void setFaultName(String newFaultName) {
        String oldFaultName = this.faultName;
        this.faultName = newFaultName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldFaultName, (Object)this.faultName));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getName();
            }
            case 3: {
                if (resolve) {
                    return this.getType();
                }
                return this.basicGetType();
            }
            case 4: {
                return this.getAction();
            }
            case 5: {
                if (resolve) {
                    return this.getSendVariable();
                }
                return this.basicGetSendVariable();
            }
            case 6: {
                if (resolve) {
                    return this.getReceiveVariable();
                }
                return this.basicGetReceiveVariable();
            }
            case 7: {
                return this.getSendCauseException();
            }
            case 8: {
                return this.getReceiveCauseException();
            }
            case 9: {
                return this.getSendVariablePart();
            }
            case 10: {
                return this.getReceiveVariablePart();
            }
            case 11: {
                return this.getSendRecordDetails();
            }
            case 12: {
                return this.getReceiveRecordDetails();
            }
            case 13: {
                return this.getFaultName();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setName((String)newValue);
                return;
            }
            case 3: {
                this.setType((DataType)newValue);
                return;
            }
            case 4: {
                this.setAction((ExchangeActionType)((Object)newValue));
                return;
            }
            case 5: {
                this.setSendVariable((Variable)newValue);
                return;
            }
            case 6: {
                this.setReceiveVariable((Variable)newValue);
                return;
            }
            case 7: {
                this.setSendCauseException((String)newValue);
                return;
            }
            case 8: {
                this.setReceiveCauseException((String)newValue);
                return;
            }
            case 9: {
                this.setSendVariablePart((String)newValue);
                return;
            }
            case 10: {
                this.setReceiveVariablePart((String)newValue);
                return;
            }
            case 11: {
                this.getSendRecordDetails().clear();
                this.getSendRecordDetails().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.getReceiveRecordDetails().clear();
                this.getReceiveRecordDetails().addAll((Collection)newValue);
                return;
            }
            case 13: {
                this.setFaultName((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.setType(null);
                return;
            }
            case 4: {
                this.setAction(ACTION_EDEFAULT);
                return;
            }
            case 5: {
                this.setSendVariable(null);
                return;
            }
            case 6: {
                this.setReceiveVariable(null);
                return;
            }
            case 7: {
                this.setSendCauseException(SEND_CAUSE_EXCEPTION_EDEFAULT);
                return;
            }
            case 8: {
                this.setReceiveCauseException(RECEIVE_CAUSE_EXCEPTION_EDEFAULT);
                return;
            }
            case 9: {
                this.setSendVariablePart(SEND_VARIABLE_PART_EDEFAULT);
                return;
            }
            case 10: {
                this.setReceiveVariablePart(RECEIVE_VARIABLE_PART_EDEFAULT);
                return;
            }
            case 11: {
                this.getSendRecordDetails().clear();
                return;
            }
            case 12: {
                this.getReceiveRecordDetails().clear();
                return;
            }
            case 13: {
                this.setFaultName(FAULT_NAME_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 3: {
                return this.type != null;
            }
            case 4: {
                return this.action != ACTION_EDEFAULT;
            }
            case 5: {
                return this.sendVariable != null;
            }
            case 6: {
                return this.receiveVariable != null;
            }
            case 7: {
                return SEND_CAUSE_EXCEPTION_EDEFAULT == null ? this.sendCauseException != null : !SEND_CAUSE_EXCEPTION_EDEFAULT.equals(this.sendCauseException);
            }
            case 8: {
                return RECEIVE_CAUSE_EXCEPTION_EDEFAULT == null ? this.receiveCauseException != null : !RECEIVE_CAUSE_EXCEPTION_EDEFAULT.equals(this.receiveCauseException);
            }
            case 9: {
                return SEND_VARIABLE_PART_EDEFAULT == null ? this.sendVariablePart != null : !SEND_VARIABLE_PART_EDEFAULT.equals(this.sendVariablePart);
            }
            case 10: {
                return RECEIVE_VARIABLE_PART_EDEFAULT == null ? this.receiveVariablePart != null : !RECEIVE_VARIABLE_PART_EDEFAULT.equals(this.receiveVariablePart);
            }
            case 11: {
                return this.sendRecordDetails != null && !this.sendRecordDetails.isEmpty();
            }
            case 12: {
                return this.receiveRecordDetails != null && !this.receiveRecordDetails.isEmpty();
            }
            case 13: {
                return FAULT_NAME_EDEFAULT == null ? this.faultName != null : !FAULT_NAME_EDEFAULT.equals(this.faultName);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", action: ");
        result.append((Object)this.action);
        result.append(", sendCauseException: ");
        result.append(this.sendCauseException);
        result.append(", receiveCauseException: ");
        result.append(this.receiveCauseException);
        result.append(", sendVariablePart: ");
        result.append(this.sendVariablePart);
        result.append(", receiveVariablePart: ");
        result.append(this.receiveVariablePart);
        result.append(", faultName: ");
        result.append(this.faultName);
        result.append(')');
        return result.toString();
    }
}

