/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.pi4soa.cdl.CDLException;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.CDLVisitor;
import org.pi4soa.cdl.CdlFactory;
import org.pi4soa.cdl.CdlPackage;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.Finalize;
import org.pi4soa.cdl.FinalizerHandler;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.Participant;
import org.pi4soa.cdl.ParticipantBindDetails;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.impl.ActivityImpl;
import org.pi4soa.cdl.impl.ChoreographyImpl;
import org.pi4soa.cdl.impl.ImportExportContext;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FinalizeImpl
extends ActivityImpl
implements Finalize {
    public static final String NAME = "name";
    private static Logger logger = Logger.getLogger("org.pi4soa.cdl.impl");
    public static final String FINALIZE_TAGNAME = "finalize";
    public static final String FINALIZERNAME = "finalizerName";
    public static final String CHOREOGRAPHYINSTANCEID = "choreographyInstanceId";
    public static final String CHOREOGRAPHYNAME = "choreographyName";
    private String m_importedChoreographyName = null;
    private String m_importedFinalizerName = null;
    private boolean m_aggregatingVisibleRoleTypes = false;
    private boolean m_isRelevantRoleTypesGuard = false;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected Choreography choreography;
    protected static final String CHOREOGRAPHY_INSTANCE_ID_EDEFAULT = null;
    protected String choreographyInstanceId = CHOREOGRAPHY_INSTANCE_ID_EDEFAULT;
    protected FinalizerHandler finalizer;
    protected EList<ParticipantBindDetails> participantBindDetails;

    @Override
    protected String getExportTagname() {
        return FINALIZE_TAGNAME;
    }

    @Override
    public Element exportAsDOMElement(Node parent, ModelListener l, ImportExportContext context) throws CDLException {
        Element elem = super.exportAsDOMElement(parent, l, context);
        if (this.isSet(this.getName())) {
            elem.setAttribute(NAME, this.getName());
        }
        if (this.getChoreography() != null) {
            elem.setAttribute(CHOREOGRAPHYNAME, this.getChoreography().getName());
        }
        if (this.isSet(this.getChoreographyInstanceId())) {
            elem.setAttribute(CHOREOGRAPHYINSTANCEID, this.getChoreographyInstanceId());
        }
        if (this.getFinalizer() != null) {
            elem.setAttribute(FINALIZERNAME, this.getFinalizer().getName());
        }
        if (context.isVersionSupported(2) && this.getParticipantBindDetails() != null && this.getParticipantBindDetails().size() > 0) {
            this.exportListAsDOMElements((List)this.getParticipantBindDetails(), elem, l, context);
        }
        return elem;
    }

    @Override
    public void importFromDOMElement(Element elem, ModelListener l, ImportExportContext context) throws CDLException {
        if (elem != null && elem.getNodeName().equals(FINALIZE_TAGNAME)) {
            if (elem.hasAttribute(NAME)) {
                this.setName(elem.getAttribute(NAME));
            }
            this.m_importedChoreographyName = elem.getAttribute(CHOREOGRAPHYNAME);
            if (elem.hasAttribute(CHOREOGRAPHYINSTANCEID)) {
                this.setChoreographyInstanceId(elem.getAttribute(CHOREOGRAPHYINSTANCEID));
            }
            if (elem.hasAttribute(FINALIZERNAME)) {
                this.m_importedFinalizerName = elem.getAttribute(FINALIZERNAME);
            }
        }
        super.importFromDOMElement(elem, l, context);
    }

    @Override
    protected CDLType createCDLType(Element elem, ModelListener l) {
        ParticipantBindDetails ret = null;
        String name = elem.getLocalName();
        if (elem.getNamespaceURI() != null && elem.getNamespaceURI().equals("http://www.pi4soa.org/cdl2") && name.equals("participantBinding")) {
            ret = CdlFactory.eINSTANCE.createParticipantBindDetails();
            this.getParticipantBindDetails().add((Object)ret);
        }
        return ret;
    }

    @Override
    public void initialize(ModelListener l) {
        if (this.isSet(this.m_importedChoreographyName)) {
            Package cdlpack;
            Choreography choreo = null;
            Choreography thisChoreo = this.getEnclosingChoreography();
            if (thisChoreo != null) {
                choreo = thisChoreo.getEnclosedChoreography(this.m_importedChoreographyName);
            }
            if (choreo == null && (cdlpack = this.getPackage()) != null) {
                choreo = cdlpack.getChoreography(this.m_importedChoreographyName);
            }
            if (choreo == null) {
                l.report((Object)this, this.getMessage("_NOT_FOUND_CHOREOGRAPHY", new Object[]{this.m_importedChoreographyName}), 2);
            } else {
                this.setChoreography(choreo);
                if (this.isSet(this.m_importedFinalizerName)) {
                    FinalizerHandler fin = choreo.getFinalizerHandler(this.m_importedFinalizerName);
                    if (fin == null) {
                        l.report((Object)this, this.getMessage("_NOT_FOUND_FINALIZER", new Object[]{this.m_importedFinalizerName}), 2);
                    } else {
                        this.setFinalizer(fin);
                    }
                }
            }
        }
        super.initialize(l);
    }

    @Override
    protected synchronized Vector getAggregatedVisibleRoleTypes() {
        Vector ret = null;
        if (!this.m_aggregatingVisibleRoleTypes && this.getChoreography() instanceof ChoreographyImpl) {
            try {
                try {
                    this.m_aggregatingVisibleRoleTypes = true;
                    ret = ((ChoreographyImpl)this.getChoreography()).getAggregatedVisibleRoleTypes();
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "Failed to get aggregated visible role types: " + t, t);
                    this.m_aggregatingVisibleRoleTypes = false;
                }
            }
            finally {
                this.m_aggregatingVisibleRoleTypes = false;
            }
        } else {
            ret = new Vector();
        }
        return ret;
    }

    @Override
    public boolean isRelevantToRoleType(RoleType roleType) {
        boolean ret = false;
        if (!this.m_isRelevantRoleTypesGuard && this.getChoreography() instanceof ChoreographyImpl) {
            try {
                try {
                    this.m_isRelevantRoleTypesGuard = true;
                    ret = ((ChoreographyImpl)this.getChoreography()).isRelevantToRoleType(roleType);
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "Failed to check is relevant role type: " + t, t);
                    this.m_isRelevantRoleTypesGuard = false;
                }
            }
            finally {
                this.m_isRelevantRoleTypesGuard = false;
            }
        }
        return ret;
    }

    @Override
    public void validateSyntax(ModelListener l, ValidationContext context) throws ValidationException {
        super.validateSyntax(l, context);
        if (this.getChoreography() != null) {
            if (this.getFinalizer() != null) {
                if (!this.getChoreography().getFinalizers().contains((Object)this.getFinalizer())) {
                    l.report((Object)this, this.getMessage("_FINALIZER_NOT_IN_CHOREOGRAPHY", null), 2);
                }
            } else if (this.getChoreography().getFinalizers().size() > 1) {
                l.report((Object)this, this.getMessage("_FINALIZER_AMBIGIOUS", null), 2);
            } else if (this.getChoreography().getFinalizers().size() == 0) {
                l.report((Object)this, this.getMessage("_FINALIZER_MISSING", null), 2);
            }
            this.validateFreeParticipants(l);
        }
    }

    protected void validateFreeParticipants(ModelListener l) throws ValidationException {
        for (Participant part : this.getChoreography().getParticipantDefinitions()) {
            if (part.getFree() != Boolean.TRUE) continue;
            Iterator binds = this.getParticipantBindDetails().iterator();
            ParticipantBindDetails bind = null;
            while (bind == null && binds.hasNext()) {
                bind = (ParticipantBindDetails)binds.next();
                if (bind.getFreeParticipant() == part) continue;
                bind = null;
            }
            if (bind != null) continue;
            l.report((Object)this, this.getMessage("_FREE_PARTICIPANT_NOT_BOUND", new Object[]{part.getName()}), 2);
        }
    }

    @Override
    public void visit(CDLVisitor visitor) {
        visitor.finalize(this);
        super.visit(visitor);
    }

    protected FinalizeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return CdlPackage.Literals.FINALIZE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public Choreography getChoreography() {
        if (this.choreography != null && this.choreography.eIsProxy()) {
            InternalEObject oldChoreography = (InternalEObject)this.choreography;
            this.choreography = (Choreography)this.eResolveProxy(oldChoreography);
            if (this.choreography != oldChoreography && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 3, (Object)oldChoreography, (Object)this.choreography));
            }
        }
        return this.choreography;
    }

    public Choreography basicGetChoreography() {
        return this.choreography;
    }

    @Override
    public void setChoreography(Choreography newChoreography) {
        Choreography oldChoreography = this.choreography;
        this.choreography = newChoreography;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldChoreography, (Object)this.choreography));
        }
    }

    @Override
    public String getChoreographyInstanceId() {
        return this.choreographyInstanceId;
    }

    @Override
    public void setChoreographyInstanceId(String newChoreographyInstanceId) {
        String oldChoreographyInstanceId = this.choreographyInstanceId;
        this.choreographyInstanceId = newChoreographyInstanceId;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldChoreographyInstanceId, (Object)this.choreographyInstanceId));
        }
    }

    @Override
    public FinalizerHandler getFinalizer() {
        if (this.finalizer != null && this.finalizer.eIsProxy()) {
            InternalEObject oldFinalizer = (InternalEObject)this.finalizer;
            this.finalizer = (FinalizerHandler)this.eResolveProxy(oldFinalizer);
            if (this.finalizer != oldFinalizer && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 5, (Object)oldFinalizer, (Object)this.finalizer));
            }
        }
        return this.finalizer;
    }

    public FinalizerHandler basicGetFinalizer() {
        return this.finalizer;
    }

    @Override
    public void setFinalizer(FinalizerHandler newFinalizer) {
        FinalizerHandler oldFinalizer = this.finalizer;
        this.finalizer = newFinalizer;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldFinalizer, (Object)this.finalizer));
        }
    }

    @Override
    public EList<ParticipantBindDetails> getParticipantBindDetails() {
        if (this.participantBindDetails == null) {
            this.participantBindDetails = new EObjectContainmentEList(ParticipantBindDetails.class, (InternalEObject)this, 6);
        }
        return this.participantBindDetails;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 6: {
                return ((InternalEList)this.getParticipantBindDetails()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getName();
            }
            case 3: {
                if (resolve) {
                    return this.getChoreography();
                }
                return this.basicGetChoreography();
            }
            case 4: {
                return this.getChoreographyInstanceId();
            }
            case 5: {
                if (resolve) {
                    return this.getFinalizer();
                }
                return this.basicGetFinalizer();
            }
            case 6: {
                return this.getParticipantBindDetails();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setName((String)newValue);
                return;
            }
            case 3: {
                this.setChoreography((Choreography)newValue);
                return;
            }
            case 4: {
                this.setChoreographyInstanceId((String)newValue);
                return;
            }
            case 5: {
                this.setFinalizer((FinalizerHandler)newValue);
                return;
            }
            case 6: {
                this.getParticipantBindDetails().clear();
                this.getParticipantBindDetails().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.setChoreography(null);
                return;
            }
            case 4: {
                this.setChoreographyInstanceId(CHOREOGRAPHY_INSTANCE_ID_EDEFAULT);
                return;
            }
            case 5: {
                this.setFinalizer(null);
                return;
            }
            case 6: {
                this.getParticipantBindDetails().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 3: {
                return this.choreography != null;
            }
            case 4: {
                return CHOREOGRAPHY_INSTANCE_ID_EDEFAULT == null ? this.choreographyInstanceId != null : !CHOREOGRAPHY_INSTANCE_ID_EDEFAULT.equals(this.choreographyInstanceId);
            }
            case 5: {
                return this.finalizer != null;
            }
            case 6: {
                return this.participantBindDetails != null && !this.participantBindDetails.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", choreographyInstanceId: ");
        result.append(this.choreographyInstanceId);
        result.append(')');
        return result.toString();
    }
}

