/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.pi4soa.cdl.CDLException;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.CDLVisitor;
import org.pi4soa.cdl.CdlFactory;
import org.pi4soa.cdl.CdlPackage;
import org.pi4soa.cdl.ChannelType;
import org.pi4soa.cdl.Choreography;
import org.pi4soa.cdl.ExchangeActionType;
import org.pi4soa.cdl.ExchangeDetails;
import org.pi4soa.cdl.Interaction;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.Participant;
import org.pi4soa.cdl.ParticipantType;
import org.pi4soa.cdl.RecordDetails;
import org.pi4soa.cdl.RelationshipType;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.Variable;
import org.pi4soa.cdl.impl.ActivityImpl;
import org.pi4soa.cdl.impl.ChannelTypeImpl;
import org.pi4soa.cdl.impl.ImportExportContext;
import org.pi4soa.cdl.util.PackageUtil;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationDefinitions;
import org.pi4soa.common.validation.ValidationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionImpl
extends ActivityImpl
implements Interaction {
    public static final String PARTICIPATE = "participate";
    public static final String TIMEOUT = "timeout";
    public static final String TOROLETYPERECORDREF = "toRoleTypeRecordRef";
    public static final String FROMROLETYPERECORDREF = "fromRoleTypeRecordRef";
    public static final String TIME_TO_COMPLETE = "time-to-complete";
    public static final String TOROLETYPEREF = "toRoleTypeRef";
    public static final String FROMROLETYPEREF = "fromRoleTypeRef";
    public static final String TOPARTICIPANT = "toParticipant";
    public static final String FROMPARTICIPANT = "fromParticipant";
    public static final String RELATIONSHIPTYPE = "relationshipType";
    public static final String INITIATE = "initiate";
    public static final String ALIGN = "align";
    public static final String CHANNELVARIABLE = "channelVariable";
    public static final String OPERATION = "operation";
    public static final String NAME = "name";
    private String m_fromRoleRecordReferences = null;
    private String m_toRoleRecordReferences = null;
    public static final String INTERACTION_TAGNAME = "interaction";
    public static final String PARTICIPATE_TAGNAME = "participate";
    public static final String TIMEOUT_TAGNAME = "timeout";
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final String OPERATION_EDEFAULT = null;
    protected String operation = OPERATION_EDEFAULT;
    protected Variable channelVariable;
    protected static final String TIME_TO_COMPLETE_EDEFAULT = null;
    protected String timeToComplete = TIME_TO_COMPLETE_EDEFAULT;
    protected static final Boolean ALIGN_EDEFAULT = Boolean.FALSE;
    protected Boolean align = ALIGN_EDEFAULT;
    protected RelationshipType relationship;
    protected EList<ExchangeDetails> exchangeDetails;
    protected EList<RecordDetails> recordDetails;
    protected EList<RecordDetails> timeoutFromRoleTypeRecordDetails;
    protected EList<RecordDetails> timeoutToRoleTypeRecordDetails;
    protected Participant fromParticipant;
    protected Participant toParticipant;

    @Override
    protected String getExportTagname() {
        return INTERACTION_TAGNAME;
    }

    @Override
    public Element exportAsDOMElement(Node parent, ModelListener l, ImportExportContext context) throws CDLException {
        Element elem = super.exportAsDOMElement(parent, l, context);
        if (this.getName() != null) {
            elem.setAttribute(NAME, this.getName());
        }
        if (this.getOperation() != null) {
            elem.setAttribute(OPERATION, this.getOperation());
        }
        if (this.getChannelVariable() != null) {
            elem.setAttribute(CHANNELVARIABLE, InteractionImpl.addTNS(this.getChannelVariable().getName()));
        }
        if (this.isSet(this.getAlign(), false)) {
            elem.setAttribute(ALIGN, this.getAlign().toString());
        }
        Element participate = elem.getOwnerDocument().createElementNS("http://www.w3.org/2005/10/cdl", "participate");
        if (this.getRelationship() != null && this.isSet(this.getRelationship().getName())) {
            participate.setAttribute(RELATIONSHIPTYPE, InteractionImpl.addTNS(this.getRelationship().getName()));
        }
        if (this.getFromRoleType() != null && this.isSet(this.getFromRoleType().getName())) {
            participate.setAttribute(FROMROLETYPEREF, InteractionImpl.addTNS(this.getFromRoleType().getName()));
        }
        if (this.getToRoleType() != null && this.isSet(this.getToRoleType().getName())) {
            participate.setAttribute(TOROLETYPEREF, InteractionImpl.addTNS(this.getToRoleType().getName()));
        }
        if (context.isVersionSupported(2)) {
            if (this.getFromParticipant() != null && this.isSet(this.getFromParticipant().getName())) {
                participate.setAttribute("cdl2:fromParticipant", this.getFromParticipant().getName());
            }
            if (this.getToParticipant() != null && this.isSet(this.getToParticipant().getName())) {
                participate.setAttribute("cdl2:toParticipant", this.getToParticipant().getName());
            }
        }
        elem.appendChild(participate);
        if (this.isSet(this.getTimeToComplete())) {
            Element timeout = elem.getOwnerDocument().createElementNS("http://www.w3.org/2005/10/cdl", "timeout");
            timeout.setAttribute(TIME_TO_COMPLETE, this.getTimeToComplete());
            String refs = "";
            for (RecordDetails rec : this.getTimeoutFromRoleTypeRecordDetails()) {
                if (refs != null && refs.trim().length() > 0) {
                    refs = String.valueOf(refs) + " ";
                }
                refs = String.valueOf(refs) + rec.getName();
            }
            if (refs != null && refs.trim().length() > 0) {
                timeout.setAttribute(FROMROLETYPERECORDREF, refs);
            }
            refs = "";
            for (RecordDetails rec : this.getTimeoutToRoleTypeRecordDetails()) {
                if (refs != null && refs.trim().length() > 0) {
                    refs = String.valueOf(refs) + " ";
                }
                refs = String.valueOf(refs) + rec.getName();
            }
            if (refs != null && refs.trim().length() > 0) {
                timeout.setAttribute(TOROLETYPERECORDREF, refs);
            }
            elem.appendChild(timeout);
        }
        this.exportListAsDOMElements((List)this.getExchangeDetails(), elem, l, context);
        this.exportListAsDOMElements((List)this.getRecordDetails(), elem, l, context);
        return elem;
    }

    @Override
    public void importFromDOMElement(Element elem, ModelListener l, ImportExportContext context) throws CDLException {
        if (elem != null && elem.getNodeName().equals(INTERACTION_TAGNAME)) {
            this.setName(elem.getAttribute(NAME));
            this.setOperation(elem.getAttribute(OPERATION));
            String channelVariable = elem.getAttribute(CHANNELVARIABLE);
            if (this.isSet(channelVariable)) {
                this.initVariable(channelVariable, l);
            }
            this.setAlign(this.importBoolean(elem.getAttribute(ALIGN), false));
            NodeList participate = elem.getElementsByTagName("participate");
            if (participate.getLength() == 1) {
                this.importParticipate((Element)participate.item(0), l);
            } else {
                l.report((Object)this, this.getMessage("_SINGLE_CHILD", new Object[]{"participate"}), 2);
            }
            NodeList timeout = elem.getElementsByTagName("timeout");
            if (timeout.getLength() == 1) {
                this.importTimeout((Element)timeout.item(0), l);
            } else if (timeout.getLength() > 1) {
                l.report((Object)this, this.getMessage("_SINGLE_CHILD", new Object[]{"timeout"}), 2);
            }
        }
        super.importFromDOMElement(elem, l, context);
    }

    protected void initVariable(String varName, ModelListener l) {
        Choreography choreo = this.getEnclosingChoreography();
        if (choreo != null) {
            Variable var = choreo.getVariable(varName);
            if (var == null) {
                l.report((Object)this, this.getMessage("_NOT_FOUND_VARIABLE", new Object[]{varName}), 2);
            } else {
                this.setChannelVariable(var);
            }
        }
    }

    protected void importParticipate(Element elem, ModelListener l) throws CDLException {
        Package cdlpack = this.getPackage();
        if (cdlpack != null) {
            String toPartName;
            String fromPartName;
            String toName;
            RoleType toRoleType;
            String relName = elem.getAttribute(RELATIONSHIPTYPE);
            RelationshipType relType = cdlpack.getRelationshipType(relName);
            if (relType != null) {
                this.setRelationship(relType);
            } else {
                l.report((Object)this, this.getMessage("_NOT_FOUND_REL_TYPE", new Object[]{relName}), 2);
            }
            String fromName = elem.getAttribute(FROMROLETYPEREF);
            RoleType fromRoleType = cdlpack.getRoleType(fromName);
            if (fromRoleType != null) {
                try {
                    this.validateRole(fromRoleType, l, "fromRoleType");
                }
                catch (Exception e) {
                    throw new CDLException(e.getMessage(), e);
                }
                if (fromRoleType != this.getFromRoleType()) {
                    l.report((Object)this, this.getMessage("_INTERACTION_FROM_ROLE", new Object[]{fromName}), 2);
                }
            } else {
                l.report((Object)this, this.getMessage("_NOT_FOUND_ROLE_TYPE", new Object[]{fromName}), 2);
            }
            if ((toRoleType = cdlpack.getRoleType(toName = elem.getAttribute(TOROLETYPEREF))) != null) {
                try {
                    this.validateRole(toRoleType, l, "toRoleType");
                }
                catch (Exception e) {
                    throw new CDLException(e.getMessage(), e);
                }
                if (toRoleType != this.getToRoleType()) {
                    l.report((Object)this, this.getMessage("_ROLE_TYPE_COMPATIBILITY", null), 2);
                }
            } else {
                l.report((Object)this, this.getMessage("_NOT_FOUND_ROLE_TYPE", new Object[]{toName}), 2);
            }
            if (this.isSet(fromPartName = elem.getAttributeNS("http://www.pi4soa.org/cdl2", FROMPARTICIPANT))) {
                Participant fromParticipant = this.getEnclosingChoreography().getParticipant(fromPartName);
                if (fromParticipant == null) {
                    l.report((Object)this, this.getMessage("_NOT_FOUND_PARTICIPANT", new Object[]{fromPartName}), 2);
                } else {
                    this.setFromParticipant(fromParticipant);
                }
            }
            if (this.isSet(toPartName = elem.getAttributeNS("http://www.pi4soa.org/cdl2", TOPARTICIPANT))) {
                Participant toParticipant = this.getEnclosingChoreography().getParticipant(toPartName);
                if (toParticipant == null) {
                    l.report((Object)this, this.getMessage("_NOT_FOUND_PARTICIPANT", new Object[]{toPartName}), 2);
                } else {
                    this.setToParticipant(toParticipant);
                }
            }
        }
    }

    protected void importTimeout(Element elem, ModelListener l) {
        this.setTimeToComplete(elem.getAttribute(TIME_TO_COMPLETE));
        this.m_fromRoleRecordReferences = elem.getAttribute(FROMROLETYPERECORDREF);
        this.m_toRoleRecordReferences = elem.getAttribute(TOROLETYPERECORDREF);
    }

    @Override
    public void initialize(ModelListener l) {
        if (this.isSet(this.m_fromRoleRecordReferences)) {
            this.initRecordRefs(this.m_fromRoleRecordReferences, (List)this.getTimeoutFromRoleTypeRecordDetails(), this.getMessage("_TIMEOUT_FROM_ROLETYPE_RECORDS", null), l);
        }
        if (this.isSet(this.m_toRoleRecordReferences)) {
            this.initRecordRefs(this.m_toRoleRecordReferences, (List)this.getTimeoutToRoleTypeRecordDetails(), this.getMessage("_TIMEOUT_TO_ROLETYPE_RECORDS", null), l);
        }
        super.initialize(l);
    }

    protected void initRecordRefs(String refs, List list, String mesgPrefix, ModelListener l) {
        StringTokenizer st = new StringTokenizer(refs, " ");
        while (st.hasMoreTokens()) {
            String ref = st.nextToken();
            RecordDetails rec = this.getRecordDetail(ref);
            if (rec == null) {
                l.report((Object)this, this.getMessage("_NOT_FOUND_RECORD_REFERENCE", new Object[]{mesgPrefix, ref}), 2);
                continue;
            }
            list.add(rec);
        }
    }

    @Override
    protected CDLType createCDLType(Element elem, ModelListener l) {
        CDLType ret = null;
        String name = elem.getNodeName();
        if (name.equals("exchange")) {
            ret = CdlFactory.eINSTANCE.createExchangeDetails();
            this.getExchangeDetails().add((Object)ret);
        } else if (name.equals("record")) {
            ret = CdlFactory.eINSTANCE.createRecordDetails();
            this.getRecordDetails().add((Object)((RecordDetails)ret));
        }
        return ret;
    }

    @Override
    public void validateSyntax(ModelListener l, ValidationContext context) throws ValidationException {
        super.validateSyntax(l, context);
        this.validateInteraction(l, context);
        this.validateTimeout(l);
        this.validateExchangeDetails(l);
        this.validateRecordDetails(l);
    }

    protected void validateInteraction(ModelListener l, ValidationContext context) throws ValidationException {
        Choreography choreo;
        this.validateChannel(l);
        if (this.isSet(this.getOperation())) {
            String opName = this.getOperation();
            String errorChars = null;
            int i = 0;
            while (i < opName.length()) {
                if (!Character.isLetterOrDigit(opName.charAt(i))) {
                    errorChars = errorChars == null ? "'" + opName.charAt(i) + "'" : String.valueOf(errorChars) + ",'" + opName.charAt(i) + "'";
                }
                ++i;
            }
            if (errorChars != null) {
                l.report((Object)this, this.getMessage("_INVALID_CHAR", new Object[]{OPERATION, errorChars}), 2, ValidationDefinitions.getPropertyNameInfo((String)OPERATION));
            }
        }
        if (this.getRelationship() != null && (choreo = this.getEnclosingChoreography()) != null && choreo.getRelationships().size() > 0 && !choreo.getRelationships().contains((Object)this.getRelationship())) {
            l.report((Object)this, this.getMessage("_REL_NOT_REFERENCED", new Object[]{this.getRelationship().getName(), choreo.getName()}), 2, ValidationDefinitions.getPropertyNameInfo((String)"relationship"));
        }
        if (this.getToRoleType() != null) {
            this.validateRole(this.getToRoleType(), l, "toRoleType");
        }
        if (this.getFromRoleType() != null) {
            this.validateRole(this.getFromRoleType(), l, "fromRoleType");
        }
        if (this.getToRoleType() != null && this.getToRoleType() == this.getFromRoleType()) {
            l.report((Object)this, this.getMessage("_INTERACTION_WITH_SAME_TO_FROM_ROLE", new Object[]{this.getToRoleType().getName()}), 1, ValidationDefinitions.getPropertyNameInfo((String)"toRoleType"));
        }
        this.validateParticipants(l, context);
    }

    protected void validateTimeout(ModelListener l) throws ValidationException {
        RecordDetails rec;
        Iterator iter = this.getTimeoutFromRoleTypeRecordDetails().iterator();
        String mesgPrefix = this.getMessage("_TIMEOUT_FROM_ROLETYPE_RECORDS", null);
        while (iter.hasNext()) {
            rec = (RecordDetails)iter.next();
            if (this.getRecordDetails().contains((Object)rec)) continue;
            l.report((Object)this, this.getMessage("_NOT_FOUND_RECORD_REFERENCE", new Object[]{mesgPrefix, rec.getName()}), 2);
        }
        iter = this.getTimeoutToRoleTypeRecordDetails().iterator();
        mesgPrefix = this.getMessage("_TIMEOUT_TO_ROLETYPE_RECORDS", null);
        while (iter.hasNext()) {
            rec = (RecordDetails)iter.next();
            if (this.getRecordDetails().contains((Object)rec)) continue;
            l.report((Object)this, this.getMessage("_NOT_FOUND_RECORD_REFERENCE", new Object[]{mesgPrefix, rec.getName()}), 2);
        }
    }

    protected void validateParticipants(ModelListener l, ValidationContext context) throws ValidationException {
        if (context.isVersionSupported(2)) {
            Participant[] parts;
            ParticipantType ptype;
            if (this.getFromParticipant() != null && this.getFromParticipant().getEnclosingChoreography() != this.getEnclosingChoreography()) {
                l.report((Object)this, this.getMessage("_NOT_FOUND_PARTICIPANT_IN_CHOREO", new Object[]{this.getFromParticipant().getName(), this.getEnclosingChoreography().getName()}), 2, ValidationDefinitions.getPropertyNameInfo((String)FROMPARTICIPANT));
            }
            if (this.getToParticipant() != null && this.getToParticipant().getEnclosingChoreography() != this.getEnclosingChoreography()) {
                l.report((Object)this, this.getMessage("_NOT_FOUND_PARTICIPANT_IN_CHOREO", new Object[]{this.getToParticipant().getName(), this.getEnclosingChoreography().getName()}), 2, ValidationDefinitions.getPropertyNameInfo((String)TOPARTICIPANT));
            }
            if (this.getToRoleType() != null && this.getToParticipant() != null && !this.getToParticipant().getRoleTypes().contains((Object)this.getToRoleType())) {
                l.report((Object)this, this.getMessage("_ROLE_NOT_ASSOCIATED_WITH_PARTICIPANT", new Object[]{"to", this.getToRoleType().getName(), this.getToParticipant().getName()}), 2, ValidationDefinitions.getPropertyNameInfo((String)"toRoleType"));
            }
            if (this.getFromRoleType() != null && this.getFromParticipant() != null && !this.getFromParticipant().getRoleTypes().contains((Object)this.getFromRoleType())) {
                l.report((Object)this, this.getMessage("_ROLE_NOT_ASSOCIATED_WITH_PARTICIPANT", new Object[]{"from", this.getFromRoleType().getName(), this.getFromParticipant().getName()}), 2, ValidationDefinitions.getPropertyNameInfo((String)"fromRoleType"));
            }
            if (this.getFromRoleType() != null && this.getToRoleType() != null) {
                boolean f_commonParticipantType = false;
                Iterator iter = this.getPackage().getTypeDefinitions().getParticipantTypes().iterator();
                while (!f_commonParticipantType && iter.hasNext()) {
                    ptype = (ParticipantType)iter.next();
                    if (!ptype.getRoleTypes().contains((Object)this.getToRoleType()) || !ptype.getRoleTypes().contains((Object)this.getFromRoleType())) continue;
                    f_commonParticipantType = true;
                }
                if (f_commonParticipantType && this.getToParticipant() == null) {
                    l.report((Object)this, this.getMessage("_INTERACTION_SAME_PARTICIPANT_TYPE", new Object[]{"to"}), 2, ValidationDefinitions.getPropertyNameInfo((String)TOPARTICIPANT));
                }
                if (f_commonParticipantType && this.getFromParticipant() == null) {
                    l.report((Object)this, this.getMessage("_INTERACTION_SAME_PARTICIPANT_TYPE", new Object[]{"from"}), 2, ValidationDefinitions.getPropertyNameInfo((String)FROMPARTICIPANT));
                }
            }
            if (this.getToRoleType() != null && this.getToParticipant() == null) {
                List ptypes = PackageUtil.getParticipantTypesForRoleType(this.getToRoleType());
                boolean f_error = false;
                if (ptypes.size() > 1) {
                    f_error = true;
                } else if (ptypes.size() == 1) {
                    ptype = (ParticipantType)ptypes.get(0);
                    parts = this.getEnclosingChoreography().getParticipantsForRoleTypes(ptype.getRoleTypesForContext());
                    if (parts != null && parts.length > 0) {
                        f_error = true;
                    }
                }
                if (f_error) {
                    l.report((Object)this, this.getMessage("_INTERACTION_PARTICIPANT_DECLARED_FOR_ROLE", new Object[]{"to", this.getToRoleType().getName()}), 2, ValidationDefinitions.getPropertyNameInfo((String)TOPARTICIPANT));
                }
            }
            if (this.getFromRoleType() != null && this.getFromParticipant() == null) {
                List ptypes = PackageUtil.getParticipantTypesForRoleType(this.getFromRoleType());
                boolean f_error = false;
                if (ptypes.size() > 1) {
                    f_error = true;
                } else if (ptypes.size() == 1) {
                    ptype = (ParticipantType)ptypes.get(0);
                    parts = this.getEnclosingChoreography().getParticipantsForRoleTypes(ptype.getRoleTypesForContext());
                    if (parts != null && parts.length > 0) {
                        f_error = true;
                    }
                }
                if (f_error) {
                    l.report((Object)this, this.getMessage("_INTERACTION_PARTICIPANT_DECLARED_FOR_ROLE", new Object[]{"from", this.getFromRoleType().getName()}), 2, ValidationDefinitions.getPropertyNameInfo((String)FROMPARTICIPANT));
                }
            }
        }
    }

    protected void validateRole(RoleType role, ModelListener l, String propName) throws ValidationException {
        Choreography choreo = this.getEnclosingChoreography();
        if (role != null) {
            if (choreo != null && !choreo.isRoleTypeAssociatedWithContext(role.getName())) {
                l.report((Object)this, this.getMessage("_NOT_RELEVANT_ROLE_TYPE", new Object[]{role.getName()}), 2, ValidationDefinitions.getPropertyNameInfo((String)propName));
            }
            if (this.getRelationship() != null && role != this.getRelationship().getFirstRoleType() && role != this.getRelationship().getSecondRoleType()) {
                l.report((Object)this, this.getMessage("_ROLE_TYPE_NOT_IN_REL", new Object[]{role.getName(), this.getRelationship().getName()}), 2, ValidationDefinitions.getPropertyNameInfo((String)propName));
            }
        }
    }

    protected void validateChannel(ModelListener l) throws ValidationException {
        if (this.getChannelVariable() != null) {
            if (!(this.getChannelVariable().getType() instanceof ChannelType)) {
                l.report((Object)this, this.getMessage("_VARIABLE_MUST_BE_CHANNEL_TYPE", null), 2, ValidationDefinitions.getPropertyNameInfo((String)CHANNELVARIABLE));
            } else {
                ChannelType ctype = (ChannelType)this.getChannelVariable().getType();
                if (ctype.getRoleType() != null && ctype.getRoleType().getBehaviors().size() > 1 && ctype.getBehavior() == null) {
                    l.report((Object)this, this.getMessage("_BEHAVIOR_AMBIGUOUS", null), 1, ValidationDefinitions.getPropertyNameInfo((String)CHANNELVARIABLE));
                }
                if (ctype.getRoleType() != this.getToRoleType()) {
                    l.report((Object)this, this.getMessage("_ROLE_TYPE_COMPATIBILITY", null), 2, ValidationDefinitions.getPropertyNameInfo((String)CHANNELVARIABLE));
                }
                if (this.getToRoleType() != null && !this.getChannelVariable().isRelevantToRoleType(this.getToRoleType())) {
                    l.report((Object)this, this.getMessage("_CHANNEL_VARIABLE_NOT_DEFINED_AT_ROLE", new Object[]{this.getToRoleType().getName()}), 2, ValidationDefinitions.getPropertyNameInfo((String)CHANNELVARIABLE));
                }
                if (this.getFromRoleType() != null && !this.getChannelVariable().isRelevantToRoleType(this.getFromRoleType())) {
                    l.report((Object)this, this.getMessage("_CHANNEL_VARIABLE_NOT_DEFINED_AT_ROLE", new Object[]{this.getFromRoleType().getName()}), 2, ValidationDefinitions.getPropertyNameInfo((String)CHANNELVARIABLE));
                }
            }
            if (this.getChannelVariable().getEnclosingChoreography() != this.getEnclosingChoreography()) {
                l.report((Object)this, this.getMessage("_VARIABLE_NOT_IN_CHOREO_SCOPE", new Object[]{"Channel"}), 2, ValidationDefinitions.getPropertyNameInfo((String)CHANNELVARIABLE));
            }
        }
    }

    protected void validateExchangeDetails(ModelListener l) throws ValidationException {
        int numReq = 0;
        int numResp = 0;
        int numFaults = 0;
        int numNotify = 0;
        for (ExchangeDetails exchange : this.getExchangeDetails()) {
            if (exchange.getAction() == ExchangeActionType.REQUEST) {
                ++numReq;
                continue;
            }
            if (exchange.getAction() == ExchangeActionType.RESPOND) {
                if (exchange.isFault()) {
                    ++numFaults;
                    continue;
                }
                ++numResp;
                continue;
            }
            if (exchange.getAction() != ExchangeActionType.NOTIFY) continue;
            ++numNotify;
        }
        if (numReq > 1) {
            l.report((Object)this, this.getMessage("_ONLY_SINGLE_CHILD_NODE", new Object[]{"request exchange", INTERACTION_TAGNAME}), 2);
        }
        if (numResp > 1) {
            l.report((Object)this, this.getMessage("_SINGLE_NON_FAULT_RESPOND", null), 2);
        }
        if (numNotify > 1) {
            l.report((Object)this, this.getMessage("_SINGLE_NOTIFICATION", null), 2);
        }
        if (numNotify == 1 && numReq + numResp + numFaults > 0) {
            l.report((Object)this, this.getMessage("_ONLY_NOTIFICATION", null), 2);
        }
    }

    protected void validateRecordDetails(ModelListener l) throws ValidationException {
        if (this.getRecordDetails().size() > 0 && this.getExchangeDetails().size() == 0) {
            l.report((Object)this, this.getMessage("_NO_RECORD_WITHOUT_EXCHANGE", null), 2);
        }
        Vector<RoleType> rolesWithCauseException = new Vector<RoleType>();
        int i = 0;
        while (i < this.getRecordDetails().size()) {
            RecordDetails rd = (RecordDetails)this.getRecordDetails().get(i);
            if (this.isSet(rd.getCauseException())) {
                RoleType[] rtypes = rd.getRoleTypesForContext();
                int j = 0;
                while (rtypes != null && j < rtypes.length) {
                    if (rolesWithCauseException.contains(rtypes[j])) {
                        l.report((Object)rd, this.getMessage("_ROLE_EXISTING_RECORD_WITH_EXCEPTION", new String[]{rtypes[j].getName()}), 2);
                    } else {
                        rolesWithCauseException.add(rtypes[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    @Override
    public RoleType[] getRoleTypesForContext() {
        RoleType[] roleType = new RoleType[]{this.getFromRoleType(), this.getToRoleType()};
        return roleType;
    }

    @Override
    protected Vector getAggregatedVisibleRoleTypes() {
        Vector<String> ret = new Vector<String>();
        if (this.getFromRoleType() != null) {
            ret.add(this.getFromRoleType().getName());
        }
        if (this.getToRoleType() != null) {
            ret.add(this.getToRoleType().getName());
        }
        return ret;
    }

    @Override
    public boolean isRelevantToRoleType(RoleType roleType) {
        boolean ret = false;
        if (this.getFromRoleType() != null && roleType != null) {
            ret = this.getFromRoleType().equals(roleType);
        }
        if (!ret && this.getToRoleType() != null && roleType != null) {
            ret = this.getToRoleType().equals(roleType);
        }
        return ret;
    }

    @Override
    public RecordDetails getRecordDetail(String name) {
        return (RecordDetails)this.getNamedCDLType(name, (List)this.getRecordDetails());
    }

    @Override
    public void visit(CDLVisitor visitor) {
        visitor.interaction(this);
        super.visit(visitor);
    }

    @Override
    public RoleType getFromRoleType() {
        RoleType ret = null;
        RoleType other = this.getToRoleType();
        if (this.getRelationship() != null && other != null && (ret = this.getRelationship().getFirstRoleType()) == other) {
            ret = this.getRelationship().getSecondRoleType();
        }
        return ret;
    }

    @Override
    public RoleType getToRoleType() {
        RoleType ret = null;
        if (this.getChannelVariable() != null && this.getChannelVariable().getType() instanceof ChannelTypeImpl) {
            ret = ((ChannelTypeImpl)this.getChannelVariable().getType()).getRoleType();
        }
        return ret;
    }

    @Override
    public ExchangeDetails[] getRequestExchanges() {
        Object[] ret = null;
        Vector<ExchangeDetails> v = new Vector<ExchangeDetails>();
        Iterator iter = this.getExchangeDetails().iterator();
        while (ret == null && iter.hasNext()) {
            ExchangeDetails details = (ExchangeDetails)iter.next();
            if (details.getAction() != ExchangeActionType.REQUEST) continue;
            v.add(details);
        }
        ret = new ExchangeDetails[v.size()];
        v.copyInto(ret);
        return ret;
    }

    @Override
    public ExchangeDetails[] getResponseExchanges() {
        Object[] ret = null;
        Vector<ExchangeDetails> responds = new Vector<ExchangeDetails>();
        Iterator iter = this.getExchangeDetails().iterator();
        while (ret == null && iter.hasNext()) {
            ExchangeDetails details = (ExchangeDetails)iter.next();
            if (details.getAction() != ExchangeActionType.RESPOND || details.isFault()) continue;
            responds.add(details);
        }
        ret = new ExchangeDetails[responds.size()];
        responds.copyInto(ret);
        return ret;
    }

    @Override
    public ExchangeDetails[] getNotificationExchanges() {
        Object[] ret = null;
        Vector<ExchangeDetails> responds = new Vector<ExchangeDetails>();
        Iterator iter = this.getExchangeDetails().iterator();
        while (ret == null && iter.hasNext()) {
            ExchangeDetails details = (ExchangeDetails)iter.next();
            if (details.getAction() != ExchangeActionType.NOTIFY) continue;
            responds.add(details);
        }
        ret = new ExchangeDetails[responds.size()];
        responds.copyInto(ret);
        return ret;
    }

    @Override
    public ExchangeDetails[] getFaultExchanges() {
        Object[] ret = null;
        Vector<ExchangeDetails> faults = new Vector<ExchangeDetails>();
        Iterator iter = this.getExchangeDetails().iterator();
        while (ret == null && iter.hasNext()) {
            ExchangeDetails details = (ExchangeDetails)iter.next();
            if (details.getAction() != ExchangeActionType.RESPOND || !details.isFault()) continue;
            faults.add(details);
        }
        ret = new ExchangeDetails[faults.size()];
        faults.copyInto(ret);
        return ret;
    }

    @Override
    public Boolean getInitiate() {
        return Boolean.FALSE;
    }

    protected InteractionImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return CdlPackage.Literals.INTERACTION;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public String getOperation() {
        return this.operation;
    }

    @Override
    public void setOperation(String newOperation) {
        String oldOperation = this.operation;
        this.operation = newOperation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldOperation, (Object)this.operation));
        }
    }

    @Override
    public Variable getChannelVariable() {
        if (this.channelVariable != null && this.channelVariable.eIsProxy()) {
            InternalEObject oldChannelVariable = (InternalEObject)this.channelVariable;
            this.channelVariable = (Variable)this.eResolveProxy(oldChannelVariable);
            if (this.channelVariable != oldChannelVariable && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 4, (Object)oldChannelVariable, (Object)this.channelVariable));
            }
        }
        return this.channelVariable;
    }

    public Variable basicGetChannelVariable() {
        return this.channelVariable;
    }

    @Override
    public void setChannelVariable(Variable newChannelVariable) {
        Variable oldChannelVariable = this.channelVariable;
        this.channelVariable = newChannelVariable;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldChannelVariable, (Object)this.channelVariable));
        }
    }

    @Override
    public String getTimeToComplete() {
        return this.timeToComplete;
    }

    @Override
    public void setTimeToComplete(String newTimeToComplete) {
        String oldTimeToComplete = this.timeToComplete;
        this.timeToComplete = newTimeToComplete;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldTimeToComplete, (Object)this.timeToComplete));
        }
    }

    @Override
    public Boolean getAlign() {
        return this.align;
    }

    @Override
    public void setAlign(Boolean newAlign) {
        Boolean oldAlign = this.align;
        this.align = newAlign;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldAlign, (Object)this.align));
        }
    }

    @Override
    public RelationshipType getRelationship() {
        if (this.relationship != null && this.relationship.eIsProxy()) {
            InternalEObject oldRelationship = (InternalEObject)this.relationship;
            this.relationship = (RelationshipType)this.eResolveProxy(oldRelationship);
            if (this.relationship != oldRelationship && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 7, (Object)oldRelationship, (Object)this.relationship));
            }
        }
        return this.relationship;
    }

    public RelationshipType basicGetRelationship() {
        return this.relationship;
    }

    @Override
    public void setRelationship(RelationshipType newRelationship) {
        RelationshipType oldRelationship = this.relationship;
        this.relationship = newRelationship;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldRelationship, (Object)this.relationship));
        }
    }

    @Override
    public EList<ExchangeDetails> getExchangeDetails() {
        if (this.exchangeDetails == null) {
            this.exchangeDetails = new EObjectContainmentEList(ExchangeDetails.class, (InternalEObject)this, 8);
        }
        return this.exchangeDetails;
    }

    @Override
    public EList<RecordDetails> getRecordDetails() {
        if (this.recordDetails == null) {
            this.recordDetails = new EObjectContainmentEList(RecordDetails.class, (InternalEObject)this, 9);
        }
        return this.recordDetails;
    }

    @Override
    public EList<RecordDetails> getTimeoutFromRoleTypeRecordDetails() {
        if (this.timeoutFromRoleTypeRecordDetails == null) {
            this.timeoutFromRoleTypeRecordDetails = new EObjectResolvingEList(RecordDetails.class, (InternalEObject)this, 10);
        }
        return this.timeoutFromRoleTypeRecordDetails;
    }

    @Override
    public EList<RecordDetails> getTimeoutToRoleTypeRecordDetails() {
        if (this.timeoutToRoleTypeRecordDetails == null) {
            this.timeoutToRoleTypeRecordDetails = new EObjectResolvingEList(RecordDetails.class, (InternalEObject)this, 11);
        }
        return this.timeoutToRoleTypeRecordDetails;
    }

    @Override
    public Participant getFromParticipant() {
        if (this.fromParticipant != null && this.fromParticipant.eIsProxy()) {
            InternalEObject oldFromParticipant = (InternalEObject)this.fromParticipant;
            this.fromParticipant = (Participant)this.eResolveProxy(oldFromParticipant);
            if (this.fromParticipant != oldFromParticipant && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 12, (Object)oldFromParticipant, (Object)this.fromParticipant));
            }
        }
        return this.fromParticipant;
    }

    public Participant basicGetFromParticipant() {
        return this.fromParticipant;
    }

    @Override
    public void setFromParticipant(Participant newFromParticipant) {
        Participant oldFromParticipant = this.fromParticipant;
        this.fromParticipant = newFromParticipant;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldFromParticipant, (Object)this.fromParticipant));
        }
    }

    @Override
    public Participant getToParticipant() {
        if (this.toParticipant != null && this.toParticipant.eIsProxy()) {
            InternalEObject oldToParticipant = (InternalEObject)this.toParticipant;
            this.toParticipant = (Participant)this.eResolveProxy(oldToParticipant);
            if (this.toParticipant != oldToParticipant && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 13, (Object)oldToParticipant, (Object)this.toParticipant));
            }
        }
        return this.toParticipant;
    }

    public Participant basicGetToParticipant() {
        return this.toParticipant;
    }

    @Override
    public void setToParticipant(Participant newToParticipant) {
        Participant oldToParticipant = this.toParticipant;
        this.toParticipant = newToParticipant;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldToParticipant, (Object)this.toParticipant));
        }
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 8: {
                return ((InternalEList)this.getExchangeDetails()).basicRemove((Object)otherEnd, msgs);
            }
            case 9: {
                return ((InternalEList)this.getRecordDetails()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getName();
            }
            case 3: {
                return this.getOperation();
            }
            case 4: {
                if (resolve) {
                    return this.getChannelVariable();
                }
                return this.basicGetChannelVariable();
            }
            case 5: {
                return this.getTimeToComplete();
            }
            case 6: {
                return this.getAlign();
            }
            case 7: {
                if (resolve) {
                    return this.getRelationship();
                }
                return this.basicGetRelationship();
            }
            case 8: {
                return this.getExchangeDetails();
            }
            case 9: {
                return this.getRecordDetails();
            }
            case 10: {
                return this.getTimeoutFromRoleTypeRecordDetails();
            }
            case 11: {
                return this.getTimeoutToRoleTypeRecordDetails();
            }
            case 12: {
                if (resolve) {
                    return this.getFromParticipant();
                }
                return this.basicGetFromParticipant();
            }
            case 13: {
                if (resolve) {
                    return this.getToParticipant();
                }
                return this.basicGetToParticipant();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setName((String)newValue);
                return;
            }
            case 3: {
                this.setOperation((String)newValue);
                return;
            }
            case 4: {
                this.setChannelVariable((Variable)newValue);
                return;
            }
            case 5: {
                this.setTimeToComplete((String)newValue);
                return;
            }
            case 6: {
                this.setAlign((Boolean)newValue);
                return;
            }
            case 7: {
                this.setRelationship((RelationshipType)newValue);
                return;
            }
            case 8: {
                this.getExchangeDetails().clear();
                this.getExchangeDetails().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.getRecordDetails().clear();
                this.getRecordDetails().addAll((Collection)newValue);
                return;
            }
            case 10: {
                this.getTimeoutFromRoleTypeRecordDetails().clear();
                this.getTimeoutFromRoleTypeRecordDetails().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.getTimeoutToRoleTypeRecordDetails().clear();
                this.getTimeoutToRoleTypeRecordDetails().addAll((Collection)newValue);
                return;
            }
            case 12: {
                this.setFromParticipant((Participant)newValue);
                return;
            }
            case 13: {
                this.setToParticipant((Participant)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.setOperation(OPERATION_EDEFAULT);
                return;
            }
            case 4: {
                this.setChannelVariable(null);
                return;
            }
            case 5: {
                this.setTimeToComplete(TIME_TO_COMPLETE_EDEFAULT);
                return;
            }
            case 6: {
                this.setAlign(ALIGN_EDEFAULT);
                return;
            }
            case 7: {
                this.setRelationship(null);
                return;
            }
            case 8: {
                this.getExchangeDetails().clear();
                return;
            }
            case 9: {
                this.getRecordDetails().clear();
                return;
            }
            case 10: {
                this.getTimeoutFromRoleTypeRecordDetails().clear();
                return;
            }
            case 11: {
                this.getTimeoutToRoleTypeRecordDetails().clear();
                return;
            }
            case 12: {
                this.setFromParticipant(null);
                return;
            }
            case 13: {
                this.setToParticipant(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 3: {
                return OPERATION_EDEFAULT == null ? this.operation != null : !OPERATION_EDEFAULT.equals(this.operation);
            }
            case 4: {
                return this.channelVariable != null;
            }
            case 5: {
                return TIME_TO_COMPLETE_EDEFAULT == null ? this.timeToComplete != null : !TIME_TO_COMPLETE_EDEFAULT.equals(this.timeToComplete);
            }
            case 6: {
                return ALIGN_EDEFAULT == null ? this.align != null : !ALIGN_EDEFAULT.equals(this.align);
            }
            case 7: {
                return this.relationship != null;
            }
            case 8: {
                return this.exchangeDetails != null && !this.exchangeDetails.isEmpty();
            }
            case 9: {
                return this.recordDetails != null && !this.recordDetails.isEmpty();
            }
            case 10: {
                return this.timeoutFromRoleTypeRecordDetails != null && !this.timeoutFromRoleTypeRecordDetails.isEmpty();
            }
            case 11: {
                return this.timeoutToRoleTypeRecordDetails != null && !this.timeoutToRoleTypeRecordDetails.isEmpty();
            }
            case 12: {
                return this.fromParticipant != null;
            }
            case 13: {
                return this.toParticipant != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", operation: ");
        result.append(this.operation);
        result.append(", timeToComplete: ");
        result.append(this.timeToComplete);
        result.append(", align: ");
        result.append(this.align);
        result.append(')');
        return result.toString();
    }
}

