/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.pi4soa.cdl.CDLException;
import org.pi4soa.cdl.CdlPackage;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.ParticipantType;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.impl.CDLTypeImpl;
import org.pi4soa.cdl.impl.ImportExportContext;
import org.pi4soa.cdl.util.CDLTypeUtil;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationDefinitions;
import org.pi4soa.common.validation.ValidationException;
import org.pi4soa.common.xml.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParticipantTypeImpl
extends CDLTypeImpl
implements ParticipantType {
    public static final String TYPEREF = "typeRef";
    public static final String ROLETYPE = "roleType";
    public static final String NAME = "name";
    public static final String PARTICIPANTTYPE_TAGNAME = "participantType";
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected EList<RoleType> roleTypes;
    protected static final Boolean STATELESS_EDEFAULT = Boolean.FALSE;
    protected Boolean stateless = STATELESS_EDEFAULT;

    public String[] getRelevantRoleTypeNames() {
        String[] ret = new String[this.getRoleTypes().size()];
        int i = 0;
        while (i < this.getRoleTypes().size()) {
            RoleType rtype = (RoleType)this.getRoleTypes().get(i);
            ret[i] = rtype.getName();
            ++i;
        }
        return ret;
    }

    @Override
    public RoleType[] getRoleTypesForContext() {
        RoleType[] ret = new RoleType[this.getRoleTypes().size()];
        int i = 0;
        while (i < this.getRoleTypes().size()) {
            ret[i] = (RoleType)this.getRoleTypes().get(i);
            ++i;
        }
        return ret;
    }

    @Override
    protected String getExportTagname() {
        return PARTICIPANTTYPE_TAGNAME;
    }

    @Override
    public Element exportAsDOMElement(Node parent, ModelListener l, ImportExportContext context) throws CDLException {
        Element elem = super.exportAsDOMElement(parent, l, context);
        if (this.getName() != null) {
            elem.setAttribute(NAME, this.getName());
        }
        for (RoleType roleType : this.getRoleTypes()) {
            Element role = this.createCDLElement(elem, ROLETYPE);
            if (roleType.getName() != null) {
                role.setAttribute(TYPEREF, ParticipantTypeImpl.addTNS(roleType.getName()));
            }
            elem.appendChild(role);
        }
        return elem;
    }

    @Override
    public void importFromDOMElement(Element elem, ModelListener l, ImportExportContext context) throws CDLException {
        if (elem != null && elem.getNodeName().equals(PARTICIPANTTYPE_TAGNAME)) {
            this.setName(elem.getAttribute(NAME));
            Package cdlpack = this.getPackage();
            if (cdlpack != null) {
                NodeList nl = elem.getChildNodes();
                int i = 0;
                while (i < nl.getLength()) {
                    if (nl.item(i).getNodeName().equals(ROLETYPE) && nl.item(i) instanceof Element) {
                        String type = ((Element)nl.item(i)).getAttribute(TYPEREF);
                        RoleType role = cdlpack.getRoleType(type);
                        if (role == null) {
                            l.report((Object)this, this.getMessage("_NOT_FOUND_ROLE_TYPE", new Object[]{type}), 2);
                        } else {
                            this.getRoleTypes().add((Object)role);
                        }
                    }
                    ++i;
                }
            }
        }
        super.importFromDOMElement(elem, l, context);
    }

    @Override
    protected boolean isNamePrefixAllowed() {
        return true;
    }

    @Override
    public void validateSyntax(ModelListener l, ValidationContext context) throws ValidationException {
        super.validateSyntax(l, context);
        Package cdlpack = this.getPackage();
        if (cdlpack != null && NamesUtil.isSet((String)this.getName())) {
            String namespace = CDLTypeUtil.getNamespace(this.getName(), this);
            if (namespace == null && XMLUtils.getPrefix((String)this.getName()) != null) {
                l.report((Object)this, this.getMessage("_UNDEFINED_NAMESPACE", new Object[]{this.getName()}), 2, ValidationDefinitions.getPropertyNameInfo((String)NAME));
            } else if (cdlpack.getParticipantType(this.getName()) != this) {
                l.report((Object)this, this.getMessage("_NAME_NOT_UNIQUE", null), 2, ValidationDefinitions.getPropertyNameInfo((String)NAME));
            }
        }
    }

    protected ParticipantTypeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return CdlPackage.Literals.PARTICIPANT_TYPE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public EList<RoleType> getRoleTypes() {
        if (this.roleTypes == null) {
            this.roleTypes = new EObjectResolvingEList(RoleType.class, (InternalEObject)this, 3);
        }
        return this.roleTypes;
    }

    @Override
    public Boolean getStateless() {
        return this.stateless;
    }

    @Override
    public void setStateless(Boolean newStateless) {
        Boolean oldStateless = this.stateless;
        this.stateless = newStateless;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldStateless, (Object)this.stateless));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getName();
            }
            case 3: {
                return this.getRoleTypes();
            }
            case 4: {
                return this.getStateless();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setName((String)newValue);
                return;
            }
            case 3: {
                this.getRoleTypes().clear();
                this.getRoleTypes().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setStateless((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.getRoleTypes().clear();
                return;
            }
            case 4: {
                this.setStateless(STATELESS_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 3: {
                return this.roleTypes != null && !this.roleTypes.isEmpty();
            }
            case 4: {
                return STATELESS_EDEFAULT == null ? this.stateless != null : !STATELESS_EDEFAULT.equals(this.stateless);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", stateless: ");
        result.append(this.stateless);
        result.append(')');
        return result.toString();
    }
}

