/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.impl;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.pi4soa.cdl.CDLException;
import org.pi4soa.cdl.CdlPackage;
import org.pi4soa.cdl.ExchangeActionType;
import org.pi4soa.cdl.Interaction;
import org.pi4soa.cdl.RecordDetails;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.Variable;
import org.pi4soa.cdl.WhenType;
import org.pi4soa.cdl.impl.CDLTypeImpl;
import org.pi4soa.cdl.impl.ExchangeDetailsImpl;
import org.pi4soa.cdl.impl.ImportExportContext;
import org.pi4soa.cdl.impl.InteractionImpl;
import org.pi4soa.cdl.util.CDLTypeUtil;
import org.pi4soa.cdl.util.ChoreographyUtil;
import org.pi4soa.cdl.xpath.DefaultXPathContext;
import org.pi4soa.cdl.xpath.ValidationResult;
import org.pi4soa.cdl.xpath.XPathContext;
import org.pi4soa.cdl.xpath.XPathValidator;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationDefinitions;
import org.pi4soa.common.validation.ValidationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RecordDetailsImpl
extends CDLTypeImpl
implements RecordDetails {
    public static final String TARGET = "target";
    public static final String EXPRESSION = "expression";
    public static final String VARIABLE = "variable";
    public static final String SOURCE = "source";
    public static final String CAUSEEXCEPTION = "causeException";
    public static final String WHEN = "when";
    public static final String NAME = "name";
    private String m_sourceVariable = null;
    private String m_targetVariable = null;
    public static final String RECORDDETAILS_TAGNAME = "record";
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final WhenType WHEN_EDEFAULT = WhenType.BEFORE;
    protected WhenType when = WHEN_EDEFAULT;
    protected Variable sourceVariable;
    protected Variable targetVariable;
    protected static final String CAUSE_EXCEPTION_EDEFAULT = null;
    protected String causeException = CAUSE_EXCEPTION_EDEFAULT;
    protected static final String SOURCE_EXPRESSION_EDEFAULT = null;
    protected String sourceExpression = SOURCE_EXPRESSION_EDEFAULT;
    protected static final String SOURCE_VARIABLE_PART_EDEFAULT = null;
    protected String sourceVariablePart = SOURCE_VARIABLE_PART_EDEFAULT;
    protected static final String TARGET_VARIABLE_PART_EDEFAULT = null;
    protected String targetVariablePart = TARGET_VARIABLE_PART_EDEFAULT;

    protected String getExportTagname() {
        return RECORDDETAILS_TAGNAME;
    }

    public Element exportAsDOMElement(Node parent, ModelListener l, ImportExportContext context) throws CDLException {
        Element elem = super.exportAsDOMElement(parent, l, context);
        if (this.getName() != null) {
            elem.setAttribute(NAME, this.getName());
        }
        if (this.getWhen() != null) {
            elem.setAttribute(WHEN, this.exportValue(this.getWhen().getName()));
        }
        if (NamesUtil.isSet((String)this.getCauseException())) {
            elem.setAttribute(CAUSEEXCEPTION, this.getCauseException());
        }
        Element src = this.createCDLElement(elem, SOURCE);
        if (this.getSourceVariable() != null) {
            String func = "cdl:getVariable('" + this.getSourceVariable().getName();
            func = this.isSet(this.getSourceVariablePart()) ? String.valueOf(func) + "','" + this.getSourceVariablePart() + "','')" : String.valueOf(func) + "','','')";
            src.setAttribute(VARIABLE, func);
        } else if (this.isSet(this.getSourceExpression())) {
            src.setAttribute(EXPRESSION, this.getSourceExpression());
        }
        elem.appendChild(src);
        Element target = this.createCDLElement(elem, TARGET);
        if (this.getTargetVariable() != null) {
            String func = "cdl:getVariable('" + this.getTargetVariable().getName();
            func = this.isSet(this.getTargetVariablePart()) ? String.valueOf(func) + "','" + this.getTargetVariablePart() + "','')" : String.valueOf(func) + "','','')";
            target.setAttribute(VARIABLE, func);
        }
        elem.appendChild(target);
        return elem;
    }

    public void importFromDOMElement(Element elem, ModelListener l, ImportExportContext context) throws CDLException {
        if (elem != null && elem.getNodeName().equals(RECORDDETAILS_TAGNAME)) {
            this.setName(elem.getAttribute(NAME));
            WhenType when = WhenType.get(this.importValue(elem.getAttribute(WHEN)));
            if (when != null) {
                this.setWhen(when);
            }
            if (elem.hasAttribute(CAUSEEXCEPTION)) {
                this.setCauseException(elem.getAttribute(CAUSEEXCEPTION));
            }
            NodeList sourceNode = elem.getElementsByTagName(SOURCE);
            NodeList targetNode = elem.getElementsByTagName(TARGET);
            if (sourceNode.getLength() == 1) {
                Element sourceElem = (Element)sourceNode.item(0);
                this.m_sourceVariable = sourceElem.getAttribute(VARIABLE);
                this.setSourceExpression(sourceElem.getAttribute(EXPRESSION));
            } else {
                l.report((Object)this, this.getMessage("_SINGLE_CHILD", new Object[]{SOURCE}), 2);
            }
            if (targetNode.getLength() == 1) {
                Element targetElem = (Element)targetNode.item(0);
                this.m_targetVariable = targetElem.getAttribute(VARIABLE);
            } else {
                l.report((Object)this, this.getMessage("_SINGLE_CHILD", new Object[]{TARGET}), 2);
            }
        }
        super.importFromDOMElement(elem, l, context);
    }

    public void initialize(ModelListener l) {
        ValidationResult res;
        super.initialize(l);
        XPathContext context = DefaultXPathContext.createContext(this, this.getEnclosingChoreography(), l);
        if (this.isSet(this.m_sourceVariable)) {
            context.setMessagePrefix(this.getMessage("_SOURCE_VARIABLE", null));
            res = XPathValidator.validateVariable(context, this.m_sourceVariable, this.getRoleTypesForContext(), false);
            if (res != null && res.getVariable() != null) {
                this.setSourceVariable(res.getVariable());
                if (this.isSet(res.getPartName())) {
                    this.setSourceVariablePart(res.getPartName());
                }
            }
        }
        if (this.isSet(this.m_targetVariable)) {
            context.setMessagePrefix(this.getMessage("_TARGET_VARIABLE", null));
            res = XPathValidator.validateVariable(context, this.m_targetVariable, this.getRoleTypesForContext(), false);
            if (res != null && res.getVariable() != null) {
                this.setTargetVariable(res.getVariable());
                if (this.isSet(res.getPartName())) {
                    this.setTargetVariablePart(res.getPartName());
                }
            }
        }
    }

    public void validateSyntax(ModelListener l, ValidationContext context) throws ValidationException {
        String targetLabel = this.getMessage("_TARGET_VARIABLE", null);
        super.validateSyntax(l, context);
        boolean srcVarSet = false;
        boolean srcExprSet = false;
        if (this.isRecordReferenced()) {
            if (this.getSourceVariable() != null) {
                srcVarSet = true;
                if (this.getSourceVariable().getEnclosingChoreography() != this.getEnclosingChoreography()) {
                    l.report((Object)this, this.getMessage("_NOT_FOUND_VARIABLE_IN_CHOREO", new Object[]{this.getSourceVariable().getName(), this.getEnclosingChoreography().getName()}), 2, ValidationDefinitions.getPropertyNameInfo((String)"sourceVariable"));
                }
            }
            if (this.isSet(this.getSourceExpression())) {
                srcExprSet = true;
                XPathContext xpcontext = DefaultXPathContext.createContext(this, this.getEnclosingChoreography(), l);
                xpcontext.setMessagePrefix(this.getMessage("_SOURCE_EXPRESSION", null));
                XPathValidator.validateExpression(xpcontext, this.getSourceExpression(), this.getRoleTypesForContext(), null, true);
            }
            if (srcVarSet && srcExprSet) {
                l.report((Object)this, this.getMessage("_ONLY_SOURCE_OR_EXPRESSION", null), 2, ValidationDefinitions.getPropertyNameInfo((String)"sourceVariable"));
            } else if (!srcVarSet && !srcExprSet) {
                l.report((Object)this, this.getMessage("_SPECIFY_SOURCE_OR_EXPRESSION", null), 2, ValidationDefinitions.getPropertyNameInfo((String)"sourceVariable"));
            }
            if (this.sourceVariable != null && this.targetVariable != null && this.sourceVariable.getType() != null && this.targetVariable.getType() != null && !this.sourceVariable.getType().equals(this.targetVariable.getType())) {
                l.report((Object)this, this.getMessage("_TYPES_SHOULD_BE_SAME", null), 2);
            }
            if (this.getTargetVariable() != null) {
                if (this.getTargetVariable().getEnclosingChoreography() != this.getEnclosingChoreography()) {
                    l.report((Object)this, this.getMessage("_NOT_FOUND_VARIABLE_IN_CHOREO", new Object[]{this.getTargetVariable().getName(), this.getEnclosingChoreography().getName()}), 2, ValidationDefinitions.getPropertyNameInfo((String)"targetVariable"));
                }
                if (this.getTargetVariable() != null && this.isSet(this.getTargetVariable().getSilent(), false)) {
                    l.report((Object)this, this.getMessage("_VARIABLE_MUST_NOT_BE_SILENT", new Object[]{targetLabel}), 2, ValidationDefinitions.getPropertyNameInfo((String)"targetVariable"));
                }
            }
        } else {
            l.report((Object)this, this.getMessage("_RECORD_DETAILS_NOT_REFERENCED", new Object[]{this.getName()}), 2);
        }
        if (NamesUtil.isSet((String)this.getCauseException())) {
            String namespace = CDLTypeUtil.getNamespace(this.getCauseException(), this, true);
            if (namespace == null) {
                l.report((Object)this, this.getMessage("_UNDEFINED_NAMESPACE", new Object[]{this.getCauseException()}), 2, ValidationDefinitions.getPropertyNameInfo((String)CAUSEEXCEPTION));
            } else if (!ChoreographyUtil.isExceptionTypeHandled(this.getCauseException(), this.getEnclosingChoreography())) {
                l.report((Object)this, this.getMessage("_EXCEPTION_TYPE_NOT_HANDLED", new Object[]{this.getCauseException()}), 1, ValidationDefinitions.getPropertyNameInfo((String)CAUSEEXCEPTION));
            }
        }
    }

    public RoleType[] getRoleTypesForContext() {
        Object[] roleTypes = null;
        Vector<RoleType> roles = new Vector<RoleType>();
        if (this.getParent() instanceof InteractionImpl) {
            InteractionImpl interaction = (InteractionImpl)this.getParent();
            if (interaction.getTimeoutFromRoleTypeRecordDetails().contains((Object)this)) {
                roles.add(interaction.getFromRoleType());
            }
            if (interaction.getTimeoutToRoleTypeRecordDetails().contains((Object)this)) {
                roles.add(interaction.getToRoleType());
            }
            for (ExchangeDetailsImpl ed : interaction.getExchangeDetails()) {
                RoleType src = interaction.getFromRoleType();
                RoleType dest = interaction.getToRoleType();
                if (ed.getAction() != null && ed.getAction() == ExchangeActionType.RESPOND) {
                    src = interaction.getToRoleType();
                    dest = interaction.getFromRoleType();
                }
                if (ed.getSendRecordDetails().contains((Object)this) && !roles.contains(src)) {
                    roles.add(src);
                }
                if (!ed.getReceiveRecordDetails().contains((Object)this) || roles.contains(dest)) continue;
                roles.add(dest);
            }
        }
        roleTypes = new RoleType[roles.size()];
        roles.copyInto(roleTypes);
        return roleTypes;
    }

    protected boolean isRecordReferenced() {
        boolean ret = false;
        if (this.getParent() instanceof InteractionImpl) {
            InteractionImpl interaction = (InteractionImpl)this.getParent();
            if (interaction.getTimeoutFromRoleTypeRecordDetails().contains((Object)this)) {
                ret = true;
            } else if (interaction.getTimeoutToRoleTypeRecordDetails().contains((Object)this)) {
                ret = true;
            } else {
                Iterator iter = interaction.getExchangeDetails().iterator();
                while (!ret && iter.hasNext()) {
                    ExchangeDetailsImpl ed = (ExchangeDetailsImpl)iter.next();
                    if (ed.getSendRecordDetails().contains((Object)this)) {
                        ret = true;
                        continue;
                    }
                    if (!ed.getReceiveRecordDetails().contains((Object)this)) continue;
                    ret = true;
                }
            }
        }
        return ret;
    }

    public Interaction getInteraction() {
        Interaction ret = null;
        if (this.eContainer() instanceof Interaction) {
            ret = (Interaction)this.eContainer();
        }
        return ret;
    }

    protected RecordDetailsImpl() {
    }

    protected EClass eStaticClass() {
        return CdlPackage.Literals.RECORD_DETAILS;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldName, (Object)this.name));
        }
    }

    public WhenType getWhen() {
        return this.when;
    }

    public void setWhen(WhenType newWhen) {
        WhenType oldWhen = this.when;
        WhenType whenType = this.when = newWhen == null ? WHEN_EDEFAULT : newWhen;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldWhen, (Object)this.when));
        }
    }

    public Variable getSourceVariable() {
        if (this.sourceVariable != null && this.sourceVariable.eIsProxy()) {
            InternalEObject oldSourceVariable = (InternalEObject)this.sourceVariable;
            this.sourceVariable = (Variable)this.eResolveProxy(oldSourceVariable);
            if (this.sourceVariable != oldSourceVariable && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 4, (Object)oldSourceVariable, (Object)this.sourceVariable));
            }
        }
        return this.sourceVariable;
    }

    public Variable basicGetSourceVariable() {
        return this.sourceVariable;
    }

    public void setSourceVariable(Variable newSourceVariable) {
        Variable oldSourceVariable = this.sourceVariable;
        this.sourceVariable = newSourceVariable;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldSourceVariable, (Object)this.sourceVariable));
        }
    }

    public Variable getTargetVariable() {
        if (this.targetVariable != null && this.targetVariable.eIsProxy()) {
            InternalEObject oldTargetVariable = (InternalEObject)this.targetVariable;
            this.targetVariable = (Variable)this.eResolveProxy(oldTargetVariable);
            if (this.targetVariable != oldTargetVariable && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 5, (Object)oldTargetVariable, (Object)this.targetVariable));
            }
        }
        return this.targetVariable;
    }

    public Variable basicGetTargetVariable() {
        return this.targetVariable;
    }

    public void setTargetVariable(Variable newTargetVariable) {
        Variable oldTargetVariable = this.targetVariable;
        this.targetVariable = newTargetVariable;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldTargetVariable, (Object)this.targetVariable));
        }
    }

    public String getCauseException() {
        return this.causeException;
    }

    public void setCauseException(String newCauseException) {
        String oldCauseException = this.causeException;
        this.causeException = newCauseException;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldCauseException, (Object)this.causeException));
        }
    }

    public String getSourceExpression() {
        return this.sourceExpression;
    }

    public void setSourceExpression(String newSourceExpression) {
        String oldSourceExpression = this.sourceExpression;
        this.sourceExpression = newSourceExpression;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldSourceExpression, (Object)this.sourceExpression));
        }
    }

    public String getSourceVariablePart() {
        return this.sourceVariablePart;
    }

    public void setSourceVariablePart(String newSourceVariablePart) {
        String oldSourceVariablePart = this.sourceVariablePart;
        this.sourceVariablePart = newSourceVariablePart;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldSourceVariablePart, (Object)this.sourceVariablePart));
        }
    }

    public String getTargetVariablePart() {
        return this.targetVariablePart;
    }

    public void setTargetVariablePart(String newTargetVariablePart) {
        String oldTargetVariablePart = this.targetVariablePart;
        this.targetVariablePart = newTargetVariablePart;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldTargetVariablePart, (Object)this.targetVariablePart));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getName();
            }
            case 3: {
                return this.getWhen();
            }
            case 4: {
                if (resolve) {
                    return this.getSourceVariable();
                }
                return this.basicGetSourceVariable();
            }
            case 5: {
                if (resolve) {
                    return this.getTargetVariable();
                }
                return this.basicGetTargetVariable();
            }
            case 6: {
                return this.getCauseException();
            }
            case 7: {
                return this.getSourceExpression();
            }
            case 8: {
                return this.getSourceVariablePart();
            }
            case 9: {
                return this.getTargetVariablePart();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setName((String)newValue);
                return;
            }
            case 3: {
                this.setWhen((WhenType)((Object)newValue));
                return;
            }
            case 4: {
                this.setSourceVariable((Variable)newValue);
                return;
            }
            case 5: {
                this.setTargetVariable((Variable)newValue);
                return;
            }
            case 6: {
                this.setCauseException((String)newValue);
                return;
            }
            case 7: {
                this.setSourceExpression((String)newValue);
                return;
            }
            case 8: {
                this.setSourceVariablePart((String)newValue);
                return;
            }
            case 9: {
                this.setTargetVariablePart((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.setWhen(WHEN_EDEFAULT);
                return;
            }
            case 4: {
                this.setSourceVariable(null);
                return;
            }
            case 5: {
                this.setTargetVariable(null);
                return;
            }
            case 6: {
                this.setCauseException(CAUSE_EXCEPTION_EDEFAULT);
                return;
            }
            case 7: {
                this.setSourceExpression(SOURCE_EXPRESSION_EDEFAULT);
                return;
            }
            case 8: {
                this.setSourceVariablePart(SOURCE_VARIABLE_PART_EDEFAULT);
                return;
            }
            case 9: {
                this.setTargetVariablePart(TARGET_VARIABLE_PART_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 3: {
                return this.when != WHEN_EDEFAULT;
            }
            case 4: {
                return this.sourceVariable != null;
            }
            case 5: {
                return this.targetVariable != null;
            }
            case 6: {
                return CAUSE_EXCEPTION_EDEFAULT == null ? this.causeException != null : !CAUSE_EXCEPTION_EDEFAULT.equals(this.causeException);
            }
            case 7: {
                return SOURCE_EXPRESSION_EDEFAULT == null ? this.sourceExpression != null : !SOURCE_EXPRESSION_EDEFAULT.equals(this.sourceExpression);
            }
            case 8: {
                return SOURCE_VARIABLE_PART_EDEFAULT == null ? this.sourceVariablePart != null : !SOURCE_VARIABLE_PART_EDEFAULT.equals(this.sourceVariablePart);
            }
            case 9: {
                return TARGET_VARIABLE_PART_EDEFAULT == null ? this.targetVariablePart != null : !TARGET_VARIABLE_PART_EDEFAULT.equals(this.targetVariablePart);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", when: ");
        result.append((Object)this.when);
        result.append(", causeException: ");
        result.append(this.causeException);
        result.append(", sourceExpression: ");
        result.append(this.sourceExpression);
        result.append(", sourceVariablePart: ");
        result.append(this.sourceVariablePart);
        result.append(", targetVariablePart: ");
        result.append(this.targetVariablePart);
        result.append(')');
        return result.toString();
    }
}

