/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.impl;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.pi4soa.cdl.Behavior;
import org.pi4soa.cdl.CDLException;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.CdlFactory;
import org.pi4soa.cdl.CdlPackage;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.ParticipantType;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.impl.CDLTypeImpl;
import org.pi4soa.cdl.impl.ImportExportContext;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationDefinitions;
import org.pi4soa.common.validation.ValidationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleTypeImpl
extends CDLTypeImpl
implements RoleType {
    public static final String NAME = "name";
    public static final String ROLETYPE_TAGNAME = "roleType";
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected EList<Behavior> behaviors;

    @Override
    protected String getExportTagname() {
        return ROLETYPE_TAGNAME;
    }

    @Override
    public Element exportAsDOMElement(Node parent, ModelListener l, ImportExportContext context) throws CDLException {
        Element elem = super.exportAsDOMElement(parent, l, context);
        if (this.getName() != null) {
            elem.setAttribute(NAME, this.getName());
        }
        this.exportListAsDOMElements((List)this.getBehaviors(), elem, l, context);
        return elem;
    }

    @Override
    public void importFromDOMElement(Element elem, ModelListener l, ImportExportContext context) throws CDLException {
        if (elem != null && elem.getNodeName().equals(ROLETYPE_TAGNAME) && elem.hasAttribute(NAME)) {
            this.setName(elem.getAttribute(NAME));
        }
        super.importFromDOMElement(elem, l, context);
    }

    @Override
    protected CDLType createCDLType(Element elem, ModelListener l) {
        Behavior ret = null;
        String name = elem.getNodeName();
        if (name.equals("behavior")) {
            ret = CdlFactory.eINSTANCE.createBehavior();
            this.getBehaviors().add((Object)ret);
        }
        return ret;
    }

    @Override
    public Behavior getBehavior(String name) {
        Behavior ret = null;
        if (name != null) {
            ret = (Behavior)this.getNamedCDLType(name, (List)this.getBehaviors());
        } else if (this.getBehaviors().size() == 1) {
            ret = (Behavior)this.getBehaviors().get(0);
        }
        return ret;
    }

    @Override
    public void validateSyntax(ModelListener l, ValidationContext context) throws ValidationException {
        super.validateSyntax(l, context);
        Package cdlpack = this.getPackage();
        if (cdlpack != null) {
            if (this.isSet(this.getName()) && cdlpack.getRoleType(this.getName()) != this) {
                l.report((Object)this, this.getMessage("_NAME_NOT_UNIQUE", null), 2, ValidationDefinitions.getPropertyNameInfo((String)NAME));
            }
            int participants = 0;
            for (ParticipantType ptype : cdlpack.getTypeDefinitions().getParticipantTypes()) {
                if (!ptype.getRoleTypes().contains((Object)this)) continue;
                ++participants;
            }
            if (participants > 1 && !context.isVersionSupported(2)) {
                l.report((Object)this, this.getMessage("_ROLE_TYPE_MULTIPLE_PARTICIPANTS", null), 2);
            }
        }
    }

    protected RoleTypeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return CdlPackage.Literals.ROLE_TYPE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public EList<Behavior> getBehaviors() {
        if (this.behaviors == null) {
            this.behaviors = new EObjectContainmentEList(Behavior.class, (InternalEObject)this, 3);
        }
        return this.behaviors;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return ((InternalEList)this.getBehaviors()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getName();
            }
            case 3: {
                return this.getBehaviors();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setName((String)newValue);
                return;
            }
            case 3: {
                this.getBehaviors().clear();
                this.getBehaviors().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.getBehaviors().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 3: {
                return this.behaviors != null && !this.behaviors.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(')');
        return result.toString();
    }
}

