/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.impl;

import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.pi4soa.cdl.CDLException;
import org.pi4soa.cdl.CDLVisitor;
import org.pi4soa.cdl.CdlPackage;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.Participant;
import org.pi4soa.cdl.ParticipantType;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.SilentAction;
import org.pi4soa.cdl.impl.ActivityImpl;
import org.pi4soa.cdl.impl.CDLTypeImpl;
import org.pi4soa.cdl.impl.ImportExportContext;
import org.pi4soa.cdl.util.PackageUtil;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationDefinitions;
import org.pi4soa.common.validation.ValidationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SilentActionImpl
extends ActivityImpl
implements SilentAction {
    public static final String NAME = "name";
    public static final String ROLETYPE = "roleType";
    public static final String PARTICIPANT = "participant";
    protected RoleType roleType;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected Participant participant;
    public static final String SILENTACTION_TAGNAME = "silentAction";

    protected String getExportTagname() {
        return SILENTACTION_TAGNAME;
    }

    public Element exportAsDOMElement(Node parent, ModelListener l, ImportExportContext context) throws CDLException {
        String name;
        Element elem = super.exportAsDOMElement(parent, l, context);
        if (this.getRoleType() != null) {
            elem.setAttribute(ROLETYPE, SilentActionImpl.addTNS(this.getRoleType().getName()));
        }
        if (context.isVersionSupported(2) && this.getParticipant() != null) {
            elem.setAttribute("cdl2:participant", this.getParticipant().getName());
        }
        if (!NamesUtil.isSet((String)(name = this.getName()))) {
            name = "";
        }
        elem.setAttribute(NAME, name);
        return elem;
    }

    public void importFromDOMElement(Element elem, ModelListener l, ImportExportContext context) throws CDLException {
        if (elem != null && elem.getNodeName().equals(SILENTACTION_TAGNAME)) {
            String participantName;
            Package cdlpack;
            this.setName(elem.getAttribute(NAME));
            String type = elem.getAttribute(ROLETYPE);
            if (NamesUtil.isSet((String)type) && (cdlpack = this.getPackage()) != null) {
                RoleType roleType = cdlpack.getRoleType(type);
                if (roleType == null) {
                    l.report((Object)this, this.getMessage("_NOT_FOUND_ROLE_TYPE", new Object[]{type}), 2);
                } else {
                    this.setRoleType(roleType);
                }
            }
            if (this.isSet(participantName = elem.getAttributeNS("http://www.pi4soa.org/cdl2", PARTICIPANT))) {
                Participant participant = this.getEnclosingChoreography().getParticipant(participantName);
                if (participant == null) {
                    l.report((Object)this, this.getMessage("_NOT_FOUND_PARTICIPANT", new Object[]{participantName}), 2);
                } else {
                    this.setParticipant(participant);
                }
            }
        }
        super.importFromDOMElement(elem, l, context);
    }

    public void validateSyntax(ModelListener l, ValidationContext context) throws ValidationException {
        super.validateSyntax(l, context);
        if (this.getParent() != null && this.getRoleType() != null && !((CDLTypeImpl)this.getParent()).isAssociatedWithRoleType(this.getRoleType())) {
            l.report((Object)this, this.getMessage("_NOT_RELEVANT_ROLE_TYPE", new Object[]{this.getRoleType().getName()}), 2, ValidationDefinitions.getPropertyNameInfo((String)ROLETYPE));
        }
        if (context.isVersionSupported(2)) {
            if (this.getParticipant() != null && this.getParticipant().getEnclosingChoreography() != this.getEnclosingChoreography()) {
                l.report((Object)this, this.getMessage("_NOT_FOUND_PARTICIPANT_IN_CHOREO", new Object[]{this.getParticipant().getName()}), 2, ValidationDefinitions.getPropertyNameInfo((String)PARTICIPANT));
            }
            if (this.getRoleType() != null && this.getParticipant() == null) {
                List ptypes = PackageUtil.getParticipantTypesForRoleType(this.getRoleType());
                boolean f_error = false;
                if (ptypes.size() > 1) {
                    f_error = true;
                } else if (ptypes.size() == 1) {
                    ParticipantType ptype = (ParticipantType)ptypes.get(0);
                    Participant[] parts = this.getEnclosingChoreography().getParticipantsForRoleTypes(ptype.getRoleTypesForContext());
                    if (parts != null && parts.length > 0) {
                        f_error = true;
                    }
                }
                if (f_error) {
                    l.report((Object)this, this.getMessage("_PARTICIPANT_DECLARED_FOR_ROLE", new Object[]{this.getRoleType().getName()}), 2, ValidationDefinitions.getPropertyNameInfo((String)PARTICIPANT));
                }
            }
        }
    }

    public RoleType[] getRoleTypesForContext() {
        RoleType[] ret = null;
        ret = this.getRoleType() != null ? new RoleType[]{this.getRoleType()} : super.getRoleTypesForContext();
        return ret;
    }

    protected Vector getAggregatedVisibleRoleTypes() {
        Vector<String> ret = new Vector<String>();
        if (this.getRoleType() != null) {
            ret.add(this.getRoleType().getName());
        } else {
            RoleType[] rts = this.getRoleTypesForContext();
            int i = 0;
            while (rts != null && i < rts.length) {
                ret.add(rts[i].getName());
                ++i;
            }
        }
        return ret;
    }

    public boolean isRelevantToRoleType(RoleType roleType) {
        boolean ret = false;
        if (this.getRoleType() != null && roleType != null) {
            ret = this.getRoleType().equals(roleType);
        } else if (roleType != null) {
            RoleType[] rts = this.getRoleTypesForContext();
            int i = 0;
            while (!ret && rts != null && i < rts.length) {
                ret = rts[i].equals(roleType);
                ++i;
            }
        }
        return ret;
    }

    public void visit(CDLVisitor visitor) {
        visitor.silentAction(this);
        super.visit(visitor);
    }

    protected SilentActionImpl() {
    }

    protected EClass eStaticClass() {
        return CdlPackage.Literals.SILENT_ACTION;
    }

    public RoleType getRoleType() {
        if (this.roleType != null && this.roleType.eIsProxy()) {
            InternalEObject oldRoleType = (InternalEObject)this.roleType;
            this.roleType = (RoleType)this.eResolveProxy(oldRoleType);
            if (this.roleType != oldRoleType && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 2, (Object)oldRoleType, (Object)this.roleType));
            }
        }
        return this.roleType;
    }

    public RoleType basicGetRoleType() {
        return this.roleType;
    }

    public void setRoleType(RoleType newRoleType) {
        RoleType oldRoleType = this.roleType;
        this.roleType = newRoleType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldRoleType, (Object)this.roleType));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldName, (Object)this.name));
        }
    }

    public Participant getParticipant() {
        if (this.participant != null && this.participant.eIsProxy()) {
            InternalEObject oldParticipant = (InternalEObject)this.participant;
            this.participant = (Participant)this.eResolveProxy(oldParticipant);
            if (this.participant != oldParticipant && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 4, (Object)oldParticipant, (Object)this.participant));
            }
        }
        return this.participant;
    }

    public Participant basicGetParticipant() {
        return this.participant;
    }

    public void setParticipant(Participant newParticipant) {
        Participant oldParticipant = this.participant;
        this.participant = newParticipant;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldParticipant, (Object)this.participant));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                if (resolve) {
                    return this.getRoleType();
                }
                return this.basicGetRoleType();
            }
            case 3: {
                return this.getName();
            }
            case 4: {
                if (resolve) {
                    return this.getParticipant();
                }
                return this.basicGetParticipant();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setRoleType((RoleType)newValue);
                return;
            }
            case 3: {
                this.setName((String)newValue);
                return;
            }
            case 4: {
                this.setParticipant((Participant)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setRoleType(null);
                return;
            }
            case 3: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 4: {
                this.setParticipant(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.roleType != null;
            }
            case 3: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 4: {
                return this.participant != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(')');
        return result.toString();
    }
}

