/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.pi4soa.cdl.CDLException;
import org.pi4soa.cdl.CdlPackage;
import org.pi4soa.cdl.InformationType;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.Token;
import org.pi4soa.cdl.impl.CDLTypeImpl;
import org.pi4soa.cdl.impl.ImportExportContext;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationDefinitions;
import org.pi4soa.common.validation.ValidationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TokenImpl
extends CDLTypeImpl
implements Token {
    public static final String INFORMATIONTYPE = "informationType";
    public static final String NAME = "name";
    public static final String TOKEN_TAGNAME = "token";
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected InformationType informationType;

    public void importFromDOMElement(Element elem, ModelListener l, ImportExportContext context) throws CDLException {
        if (elem != null && elem.getNodeName().equals(TOKEN_TAGNAME)) {
            Package cdlpack;
            this.setName(elem.getAttribute(NAME));
            String infoType = elem.getAttribute(INFORMATIONTYPE);
            if (infoType != null && (cdlpack = this.getPackage()) != null) {
                InformationType type = cdlpack.getInformationType(infoType);
                if (type != null) {
                    this.setInformationType(type);
                } else {
                    l.report((Object)this, this.getMessage("_NOT_FOUND_INFO_TYPE", new Object[]{infoType}), 2);
                }
            }
        }
        super.importFromDOMElement(elem, l, context);
    }

    protected String getExportTagname() {
        return TOKEN_TAGNAME;
    }

    public Element exportAsDOMElement(Node parent, ModelListener l, ImportExportContext context) throws CDLException {
        Element elem = super.exportAsDOMElement(parent, l, context);
        if (this.getName() != null) {
            elem.setAttribute(NAME, this.getName());
        }
        if (this.getInformationType() != null) {
            elem.setAttribute(INFORMATIONTYPE, TokenImpl.addTNS(this.getInformationType().getName()));
        }
        return elem;
    }

    public void validateSyntax(ModelListener l, ValidationContext context) throws ValidationException {
        super.validateSyntax(l, context);
        Package cdlpack = this.getPackage();
        if (cdlpack != null && this.isSet(this.getName()) && cdlpack.getToken(this.getName()) != this) {
            l.report((Object)this, this.getMessage("_NAME_NOT_UNIQUE", null), 2, ValidationDefinitions.getPropertyNameInfo((String)NAME));
        }
    }

    protected TokenImpl() {
    }

    protected EClass eStaticClass() {
        return CdlPackage.Literals.TOKEN;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldName, (Object)this.name));
        }
    }

    public InformationType getInformationType() {
        if (this.informationType != null && this.informationType.eIsProxy()) {
            InternalEObject oldInformationType = (InternalEObject)this.informationType;
            this.informationType = (InformationType)this.eResolveProxy(oldInformationType);
            if (this.informationType != oldInformationType && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 3, (Object)oldInformationType, (Object)this.informationType));
            }
        }
        return this.informationType;
    }

    public InformationType basicGetInformationType() {
        return this.informationType;
    }

    public void setInformationType(InformationType newInformationType) {
        InformationType oldInformationType = this.informationType;
        this.informationType = newInformationType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldInformationType, (Object)this.informationType));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getName();
            }
            case 3: {
                if (resolve) {
                    return this.getInformationType();
                }
                return this.basicGetInformationType();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setName((String)newValue);
                return;
            }
            case 3: {
                this.setInformationType((InformationType)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.setInformationType(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 3: {
                return this.informationType != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(')');
        return result.toString();
    }
}

