/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.pi4soa.cdl.CDLException;
import org.pi4soa.cdl.CdlPackage;
import org.pi4soa.cdl.InformationType;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.Token;
import org.pi4soa.cdl.TokenLocator;
import org.pi4soa.cdl.impl.CDLTypeImpl;
import org.pi4soa.cdl.impl.ImportExportContext;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.util.NamesUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TokenLocatorImpl
extends CDLTypeImpl
implements TokenLocator {
    public static final String NAME = "name";
    public static final String QUERY = "query";
    public static final String PART = "part";
    public static final String INFORMATIONTYPE = "informationType";
    public static final String TOKENNAME = "tokenName";
    public static final String TOKENLOCATOR_TAGNAME = "tokenLocator";
    protected Token token;
    protected InformationType informationType;
    protected static final String QUERY_EDEFAULT = null;
    protected String query = QUERY_EDEFAULT;
    protected static final String PART_EDEFAULT = null;
    protected String part = PART_EDEFAULT;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;

    protected String getExportTagname() {
        return TOKENLOCATOR_TAGNAME;
    }

    public Element exportAsDOMElement(Node parent, ModelListener l, ImportExportContext context) throws CDLException {
        Element elem = super.exportAsDOMElement(parent, l, context);
        if (NamesUtil.isSet((String)this.getName())) {
            elem.setAttribute(NAME, this.getName());
        }
        if (this.getToken() != null) {
            elem.setAttribute(TOKENNAME, TokenLocatorImpl.addTNS(this.getToken().getName()));
        }
        if (this.getInformationType() != null) {
            elem.setAttribute(INFORMATIONTYPE, TokenLocatorImpl.addTNS(this.getInformationType().getName()));
        }
        if (this.isSet(this.getPart())) {
            elem.setAttribute(PART, this.getPart());
        }
        if (this.isSet(this.getQuery())) {
            elem.setAttribute(QUERY, this.getQuery());
        }
        return elem;
    }

    public void importFromDOMElement(Element elem, ModelListener l, ImportExportContext context) throws CDLException {
        if (elem != null && elem.getNodeName().equals(TOKENLOCATOR_TAGNAME)) {
            Package cdlpack;
            String infoType;
            Package cdlpack2;
            this.setName(elem.getAttribute(NAME));
            String tokenName = elem.getAttribute(TOKENNAME);
            if (tokenName != null && (cdlpack2 = this.getPackage()) != null) {
                Token token = cdlpack2.getToken(tokenName);
                if (token != null) {
                    this.setToken(token);
                } else {
                    l.report((Object)this, this.getMessage("_NOT_FOUND_TOKEN", new Object[]{tokenName}), 2);
                }
            }
            if ((infoType = elem.getAttribute(INFORMATIONTYPE)) != null && (cdlpack = this.getPackage()) != null) {
                InformationType type = cdlpack.getInformationType(infoType);
                if (type != null) {
                    this.setInformationType(type);
                } else {
                    l.report((Object)this, this.getMessage("_NOT_FOUND_INFO_TYPE", new Object[]{infoType}), 2);
                }
            }
            if (elem.hasAttribute(PART)) {
                this.setPart(elem.getAttribute(PART));
            }
            if (elem.hasAttribute(QUERY)) {
                this.setQuery(elem.getAttribute(QUERY));
            }
        }
        super.importFromDOMElement(elem, l, context);
    }

    protected TokenLocatorImpl() {
    }

    protected EClass eStaticClass() {
        return CdlPackage.Literals.TOKEN_LOCATOR;
    }

    public Token getToken() {
        if (this.token != null && this.token.eIsProxy()) {
            InternalEObject oldToken = (InternalEObject)this.token;
            this.token = (Token)this.eResolveProxy(oldToken);
            if (this.token != oldToken && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 2, (Object)oldToken, (Object)this.token));
            }
        }
        return this.token;
    }

    public Token basicGetToken() {
        return this.token;
    }

    public void setToken(Token newToken) {
        Token oldToken = this.token;
        this.token = newToken;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldToken, (Object)this.token));
        }
    }

    public InformationType getInformationType() {
        if (this.informationType != null && this.informationType.eIsProxy()) {
            InternalEObject oldInformationType = (InternalEObject)this.informationType;
            this.informationType = (InformationType)this.eResolveProxy(oldInformationType);
            if (this.informationType != oldInformationType && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 3, (Object)oldInformationType, (Object)this.informationType));
            }
        }
        return this.informationType;
    }

    public InformationType basicGetInformationType() {
        return this.informationType;
    }

    public void setInformationType(InformationType newInformationType) {
        InformationType oldInformationType = this.informationType;
        this.informationType = newInformationType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldInformationType, (Object)this.informationType));
        }
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String newQuery) {
        String oldQuery = this.query;
        this.query = newQuery;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldQuery, (Object)this.query));
        }
    }

    public String getPart() {
        return this.part;
    }

    public void setPart(String newPart) {
        String oldPart = this.part;
        this.part = newPart;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldPart, (Object)this.part));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldName, (Object)this.name));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                if (resolve) {
                    return this.getToken();
                }
                return this.basicGetToken();
            }
            case 3: {
                if (resolve) {
                    return this.getInformationType();
                }
                return this.basicGetInformationType();
            }
            case 4: {
                return this.getQuery();
            }
            case 5: {
                return this.getPart();
            }
            case 6: {
                return this.getName();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setToken((Token)newValue);
                return;
            }
            case 3: {
                this.setInformationType((InformationType)newValue);
                return;
            }
            case 4: {
                this.setQuery((String)newValue);
                return;
            }
            case 5: {
                this.setPart((String)newValue);
                return;
            }
            case 6: {
                this.setName((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setToken(null);
                return;
            }
            case 3: {
                this.setInformationType(null);
                return;
            }
            case 4: {
                this.setQuery(QUERY_EDEFAULT);
                return;
            }
            case 5: {
                this.setPart(PART_EDEFAULT);
                return;
            }
            case 6: {
                this.setName(NAME_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.token != null;
            }
            case 3: {
                return this.informationType != null;
            }
            case 4: {
                return QUERY_EDEFAULT == null ? this.query != null : !QUERY_EDEFAULT.equals(this.query);
            }
            case 5: {
                return PART_EDEFAULT == null ? this.part != null : !PART_EDEFAULT.equals(this.part);
            }
            case 6: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (query: ");
        result.append(this.query);
        result.append(", part: ");
        result.append(this.part);
        result.append(", name: ");
        result.append(this.name);
        result.append(')');
        return result.toString();
    }
}

