/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.impl;

import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.pi4soa.cdl.Activity;
import org.pi4soa.cdl.CDLException;
import org.pi4soa.cdl.CDLType;
import org.pi4soa.cdl.CdlPackage;
import org.pi4soa.cdl.WorkUnit;
import org.pi4soa.cdl.impl.ImportExportContext;
import org.pi4soa.cdl.impl.SequenceImpl;
import org.pi4soa.cdl.impl.StructuralTypeImpl;
import org.pi4soa.cdl.xpath.DefaultXPathContext;
import org.pi4soa.cdl.xpath.XPathContext;
import org.pi4soa.cdl.xpath.XPathValidator;
import org.pi4soa.common.model.ModelListener;
import org.pi4soa.common.validation.ValidationContext;
import org.pi4soa.common.validation.ValidationException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class WorkUnitImpl
extends StructuralTypeImpl
implements WorkUnit {
    public static final String BLOCK = "block";
    public static final String REPEAT = "repeat";
    public static final String GUARD = "guard";
    public static final String NAME = "name";
    public static final String WORKUNIT_TAGNAME = "workunit";
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final String EXPRESSION_EDEFAULT = null;
    protected String expression = EXPRESSION_EDEFAULT;

    protected String getExportTagname() {
        return WORKUNIT_TAGNAME;
    }

    public Element exportAsDOMElement(Node parent, ModelListener l, ImportExportContext context) throws CDLException {
        Element elem = super.exportAsDOMElement(parent, l, context);
        if (this.getName() != null) {
            elem.setAttribute(NAME, this.getName());
        }
        if (this.isSet(this.getGuardCondition())) {
            elem.setAttribute(GUARD, this.getGuardCondition());
        }
        if (this.isSet(this.getRepeatCondition())) {
            elem.setAttribute(REPEAT, this.getRepeatCondition());
        }
        if (this.isBlocking()) {
            elem.setAttribute(BLOCK, Boolean.TRUE.toString());
        }
        Element base = elem;
        if (this.getActivities().size() > 1) {
            base = this.createCDLElement(parent, "sequence");
            elem.appendChild(base);
        }
        this.exportListAsDOMElements((List)this.getActivities(), base, l, context);
        return elem;
    }

    public void importFromDOMElement(Element elem, ModelListener l, ImportExportContext context) throws CDLException {
        if (elem != null && elem.getNodeName().equals(WORKUNIT_TAGNAME)) {
            if (elem.hasAttribute(NAME)) {
                this.setName(elem.getAttribute(NAME));
            }
            this.setGuardCondition(elem.getAttribute(GUARD));
            this.setRepeatCondition(elem.getAttribute(REPEAT));
        }
        super.importFromDOMElement(elem, l, context);
        if (this.getActivities().size() == 1 && this.getActivities().get(0) instanceof SequenceImpl) {
            SequenceImpl seq = (SequenceImpl)this.getActivities().get(0);
            while (seq.getActivities().size() > 0) {
                Activity act = (Activity)seq.getActivities().get(0);
                seq.getActivities().remove(0);
                this.getActivities().add((Object)act);
            }
            this.getActivities().remove(0);
        }
    }

    protected CDLType createCDLType(Element elem, ModelListener l) {
        Activity ret = null;
        Activity act = WorkUnitImpl.createActivity(elem, l);
        if (act != null) {
            ret = act;
            this.getActivities().add((Object)act);
        }
        return ret;
    }

    public void validateSyntax(ModelListener l, ValidationContext context) throws ValidationException {
        XPathContext xpcontext;
        super.validateSyntax(l, context);
        if (this.isSet(this.getGuardCondition())) {
            xpcontext = DefaultXPathContext.createContext(this, this.getEnclosingChoreography(), l, this.getMessage("_GUARD_CONDITION", null), false);
            XPathValidator.validateExpression(xpcontext, this.getGuardCondition(), this.getRoleTypesForContext(), null, false);
        }
        if (this.isSet(this.getRepeatCondition())) {
            xpcontext = DefaultXPathContext.createContext(this, this.getEnclosingChoreography(), l, this.getMessage("_REPEAT_CONDITION", null));
            XPathValidator.validateExpression(xpcontext, this.getRepeatCondition(), this.getRoleTypesForContext(), null, false);
        }
    }

    protected String getGuardCondition() {
        return this.getExpression();
    }

    protected void setGuardCondition(String guard) {
        this.setExpression(guard);
    }

    protected String getRepeatCondition() {
        return this.getReEvaluateCondition();
    }

    protected void setRepeatCondition(String repeat) {
    }

    public boolean isBlocking() {
        return false;
    }

    public String getReEvaluateCondition() {
        return null;
    }

    public boolean isGroupingConstruct() {
        return true;
    }

    public boolean isConditionalGroupingConstruct() {
        return true;
    }

    public boolean isSequentialGroupingConstruct() {
        return true;
    }

    protected WorkUnitImpl() {
    }

    protected EClass eStaticClass() {
        return CdlPackage.Literals.WORK_UNIT;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldName, (Object)this.name));
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String newExpression) {
        String oldExpression = this.expression;
        this.expression = newExpression;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldExpression, (Object)this.expression));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getName();
            }
            case 4: {
                return this.getExpression();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.setName((String)newValue);
                return;
            }
            case 4: {
                this.setExpression((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 4: {
                this.setExpression(EXPRESSION_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 4: {
                return EXPRESSION_EDEFAULT == null ? this.expression != null : !EXPRESSION_EDEFAULT.equals(this.expression);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", expression: ");
        result.append(this.expression);
        result.append(')');
        return result.toString();
    }
}

