/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.interfaces;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.cdl.interfaces.DefaultOperationDefinition;
import org.pi4soa.cdl.interfaces.InterfaceDefinition;
import org.pi4soa.cdl.interfaces.InterfaceVisitor;
import org.pi4soa.cdl.interfaces.MessageDefinition;
import org.pi4soa.common.util.NamesUtil;

public class DefaultInterfaceDefinition
implements InterfaceDefinition {
    private static Logger logger = Logger.getLogger("org.pi4soa.cdl.interfaces");
    private String m_behaviorName = null;
    private String m_namespace = null;
    private String m_interfaceName = null;
    private List m_operations = new Vector();

    public DefaultInterfaceDefinition(String behaviorName, String namespace, String interfaceName) {
        this.m_behaviorName = behaviorName;
        this.m_namespace = namespace;
        this.m_interfaceName = interfaceName;
    }

    public String getBehaviorName() {
        return this.m_behaviorName;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public String getInterfaceName() {
        return this.m_interfaceName;
    }

    public List getOperations() {
        return this.m_operations;
    }

    public List getOperations(String name, String requestNamespace, String requestType, String responseNamespace, String responseType) {
        Vector<DefaultOperationDefinition> ret = new Vector<DefaultOperationDefinition>();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Get operation defns for name=" + name + " reqType=" + requestType + " reqNS=" + requestNamespace + " respType=" + responseType + " respNS=" + responseNamespace);
        }
        for (DefaultOperationDefinition op : this.getOperations()) {
            if (name != null && !op.getOperationName().equals(name)) continue;
            boolean reqFound = requestType == null;
            boolean respFound = responseType == null;
            Iterator miter = op.getMessages().iterator();
            while (!(reqFound && respFound || !miter.hasNext())) {
                MessageDefinition mdef = (MessageDefinition)miter.next();
                String type = mdef.getType();
                String namespace = mdef.getTypeNamespace();
                if (!NamesUtil.isSet((String)type)) {
                    type = mdef.getElement();
                    namespace = mdef.getElementNamespace();
                }
                if (!reqFound && type != null && mdef.getClassification() == 0 && type.equals(requestType) && NamesUtil.compare((String)namespace, (String)requestNamespace)) {
                    reqFound = true;
                    continue;
                }
                if (respFound || type == null || mdef.getClassification() != 1 && mdef.getClassification() != 3 || !type.equals(responseType) || !NamesUtil.compare((String)namespace, (String)responseNamespace)) continue;
                respFound = true;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Result requestFound=" + reqFound + " responseFound=" + respFound);
            }
            if (!reqFound || !respFound) continue;
            ret.add(op);
        }
        return ret;
    }

    public List getNotifications(String name, String notificationNamespace, String notificationType) {
        Vector<DefaultOperationDefinition> ret = new Vector<DefaultOperationDefinition>();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Get notification operation defns for name=" + name + " type=" + notificationType + " namespace=" + notificationNamespace);
        }
        for (DefaultOperationDefinition op : this.getOperations()) {
            if (op.getOperationType() != 2 || name != null && !op.getOperationName().equals(name)) continue;
            boolean respFound = notificationType == null;
            Iterator miter = op.getMessages().iterator();
            while (!respFound && miter.hasNext()) {
                MessageDefinition mdef = (MessageDefinition)miter.next();
                String type = mdef.getType();
                String namespace = mdef.getTypeNamespace();
                if (!NamesUtil.isSet((String)type)) {
                    type = mdef.getElement();
                    namespace = mdef.getElementNamespace();
                }
                if (type == null || mdef.getClassification() != 1 && mdef.getClassification() != 3 || !type.equals(notificationType) || !NamesUtil.compare((String)namespace, (String)notificationNamespace)) continue;
                respFound = true;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Result notification found=" + respFound);
            }
            if (!respFound) continue;
            ret.add(op);
        }
        return ret;
    }

    public void visit(InterfaceVisitor visitor) {
        visitor.interfaceStart(this);
        for (DefaultOperationDefinition opdef : this.getOperations()) {
            opdef.visit(visitor);
        }
        visitor.interfaceEnd(this);
    }

    public int hashCode() {
        int ret = 0;
        ret = this.getBehaviorName() != null ? this.getBehaviorName().hashCode() : (this.getInterfaceName() != null ? this.getInterfaceName().hashCode() : super.hashCode());
        return ret;
    }

    public boolean equals(Object obj) {
        DefaultInterfaceDefinition idef;
        boolean ret = false;
        if (obj instanceof DefaultInterfaceDefinition && (idef = (DefaultInterfaceDefinition)obj).getBehaviorName().equals(this.getBehaviorName()) && idef.getNamespace().equals(this.getNamespace()) && idef.getInterfaceName().equals(this.getInterfaceName())) {
            ret = true;
        }
        return ret;
    }
}

