/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.interfaces;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.interfaces.EquivalenceChecker;
import org.pi4soa.cdl.interfaces.InterfaceDefinition;
import org.pi4soa.cdl.interfaces.InterfaceDeriver;
import org.pi4soa.cdl.interfaces.InterfaceException;
import org.pi4soa.cdl.interfaces.InterfaceIntrospector;
import org.pi4soa.cdl.interfaces.impl.EquivalenceCheckerImpl;
import org.pi4soa.cdl.interfaces.impl.InterfaceDeriverImpl;
import org.pi4soa.common.resource.ArtifactManager;
import org.pi4soa.common.util.PropertyUtil;

public class InterfaceFactory {
    private static Logger logger = Logger.getLogger("org.pi4soa.cdl.interfaces");
    private static Hashtable m_introspectors = new Hashtable();
    public static final String INTERFACE_INTROSPECTORS = "pi4soa.interface.introspectors";
    private static final String DEFAULT_INTERFACE_INTROSPECTORS = "";
    private static final String INTERFACE_INTROSPECTORS_DELIM = ",";

    static {
        if (PropertyUtil.hasProperty((String)INTERFACE_INTROSPECTORS)) {
            String introspectors = PropertyUtil.getProperty((String)INTERFACE_INTROSPECTORS, (String)System.getProperty(INTERFACE_INTROSPECTORS, DEFAULT_INTERFACE_INTROSPECTORS));
            StringTokenizer st = new StringTokenizer(introspectors, INTERFACE_INTROSPECTORS_DELIM);
            while (st.hasMoreTokens()) {
                Class<?> componentClass;
                InterfaceIntrospector introspector;
                String clsName;
                block8: {
                    clsName = st.nextToken().trim();
                    introspector = null;
                    componentClass = null;
                    try {
                        componentClass = Class.forName(clsName);
                    }
                    catch (Exception exception) {
                        if (!logger.isLoggable(Level.FINE)) break block8;
                        logger.fine("Unable to find introspector class '" + clsName + "'");
                    }
                }
                if (componentClass != null && InterfaceIntrospector.class.isAssignableFrom(componentClass)) {
                    try {
                        introspector = (InterfaceIntrospector)componentClass.newInstance();
                    }
                    catch (Exception e) {
                        logger.severe("Failed to instantiate introspector '" + clsName + "': " + e);
                    }
                }
                if (introspector != null) {
                    logger.info("Registering interface introspector: " + clsName);
                    InterfaceFactory.register(introspector);
                    continue;
                }
                logger.warning("Failed to find interface introspector: " + clsName);
            }
        }
    }

    public static InterfaceDeriver getInterfaceDeriver() {
        return new InterfaceDeriverImpl();
    }

    public static EquivalenceChecker getEquivalenceChecker() {
        return new EquivalenceCheckerImpl();
    }

    public static InterfaceIntrospector getIntrospector(String moduleId) {
        InterfaceIntrospector ret = null;
        if (moduleId != null) {
            ret = (InterfaceIntrospector)m_introspectors.get(moduleId);
        }
        return ret;
    }

    public static InterfaceIntrospector[] getIntrospectors() {
        InterfaceIntrospector[] ret = new InterfaceIntrospector[m_introspectors.size()];
        Enumeration iter = m_introspectors.elements();
        int pos = 0;
        while (iter.hasMoreElements()) {
            ret[pos++] = (InterfaceIntrospector)iter.nextElement();
        }
        return ret;
    }

    public static InterfaceDefinition getInterfaceDefinition(Package cdlpack, ArtifactManager artifacts, String intfNamespace, String intfName) throws InterfaceException {
        InterfaceDefinition ret = null;
        InterfaceIntrospector[] introspectors = InterfaceFactory.getIntrospectors();
        int i = 0;
        while (ret == null && i < introspectors.length) {
            ret = introspectors[i].getInterfaceDefinition(cdlpack, artifacts, intfNamespace, intfName);
            ++i;
        }
        return ret;
    }

    public static void register(InterfaceIntrospector introspector) {
        if (introspector != null) {
            logger.info("Registering interface introspector: " + introspector.getModuleId());
            m_introspectors.put(introspector.getModuleId(), introspector);
        }
    }

    public static void unregister(InterfaceIntrospector introspector) {
        if (introspector != null) {
            logger.info("Unregistering interface introspector: " + introspector.getModuleId());
            m_introspectors.remove(introspector.getModuleId());
        }
    }
}

