/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.interfaces.impl;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.pi4soa.cdl.Behavior;
import org.pi4soa.cdl.ChannelType;
import org.pi4soa.cdl.DefaultCDLVisitor;
import org.pi4soa.cdl.ExchangeActionType;
import org.pi4soa.cdl.ExchangeDetails;
import org.pi4soa.cdl.Interaction;
import org.pi4soa.cdl.Package;
import org.pi4soa.cdl.ParticipantType;
import org.pi4soa.cdl.RoleType;
import org.pi4soa.cdl.interfaces.DefaultInterfaceDefinition;
import org.pi4soa.cdl.interfaces.DefaultMessageDefinition;
import org.pi4soa.cdl.interfaces.DefaultOperationDefinition;
import org.pi4soa.cdl.interfaces.DefaultRoleTypeDefinition;
import org.pi4soa.cdl.interfaces.InterfaceDefinition;
import org.pi4soa.cdl.interfaces.InterfaceException;
import org.pi4soa.cdl.interfaces.MessageDefinition;
import org.pi4soa.cdl.interfaces.OperationDefinition;
import org.pi4soa.cdl.util.CDLTypeUtil;
import org.pi4soa.cdl.util.InteractionUtil;
import org.pi4soa.cdl.util.PackageUtil;
import org.pi4soa.common.util.NamesUtil;
import org.pi4soa.common.xml.NameSpaceUtil;
import org.pi4soa.common.xml.XMLPrefixResolver;
import org.pi4soa.common.xml.XMLUtils;

public class CDLInterfaceBuilder {
    private static Logger logger = Logger.getLogger("org.pi4soa.cdl.interfaces.impl");
    private Vector m_roleTypeDefinitions = null;
    private Hashtable m_roleTypeIndex = null;

    public CDLInterfaceBuilder() {
        this.reset();
    }

    public void reset() {
        this.m_roleTypeDefinitions = new Vector();
        this.m_roleTypeIndex = new Hashtable();
    }

    public void build(Package cdlpack) throws InterfaceException {
        if (cdlpack != null) {
            cdlpack.visit(new DefaultCDLVisitor(){

                public void packageStart(Package pack) {
                    if (pack != null) {
                        CDLInterfaceBuilder.this.processPackage(pack);
                    }
                }

                public void interaction(Interaction interaction) {
                    if (interaction != null) {
                        CDLInterfaceBuilder.this.processInteraction(interaction);
                    }
                }
            });
        }
    }

    protected void processPackage(Package pack) {
        if (pack != null && pack.getTypeDefinitions() != null) {
            EList<RoleType> roleTypes = pack.getTypeDefinitions().getRoleTypes();
            XMLPrefixResolver prefixes = CDLTypeUtil.getPrefixResolver(pack);
            for (RoleType roleType : roleTypes) {
                ParticipantType partType = PackageUtil.getParticipantForRoleType(roleType);
                this.configureRoleType(pack.getTargetNamespace(), prefixes, partType, roleType);
            }
        }
    }

    public void configureRoleType(String namespace, XMLPrefixResolver prefixes, ParticipantType partType, RoleType roleType) {
        String partTypeName = null;
        if (partType != null) {
            partTypeName = partType.getName();
            namespace = XMLUtils.getNamespace((String)partType.getName(), (XMLPrefixResolver)prefixes, (String)namespace);
        }
        DefaultRoleTypeDefinition rtdef = new DefaultRoleTypeDefinition(namespace, partTypeName, roleType.getName());
        this.m_roleTypeDefinitions.add(rtdef);
        this.m_roleTypeIndex.put(roleType, rtdef);
        for (Behavior behavior : roleType.getBehaviors()) {
            DefaultInterfaceDefinition idef = null;
            idef = NamesUtil.isSet((String)behavior.getInterface()) ? new DefaultInterfaceDefinition(behavior.getName(), XMLUtils.getNamespace((String)behavior.getInterface(), (XMLPrefixResolver)prefixes, (String)namespace), XMLUtils.getLocalname((String)behavior.getInterface())) : new DefaultInterfaceDefinition(behavior.getName(), namespace, null);
            rtdef.getInterfaces().add(idef);
        }
    }

    protected void processInteraction(Interaction interaction) throws InterfaceException {
        if (interaction.getToRoleType() == null) {
            throw new InterfaceException("'To' role type not defined in interaction");
        }
        InterfaceDefinition idef = this.getInterfaceDefinition(interaction);
        Package cdlpack = interaction.getPackage();
        XMLPrefixResolver prefixes = CDLTypeUtil.getPrefixResolver(cdlpack);
        Iterator iter = interaction.getExchangeDetails().iterator();
        while (iter.hasNext()) {
            this.processExchangeDetails((ExchangeDetails)iter.next(), idef, cdlpack.getTargetNamespace(), prefixes);
        }
    }

    public InterfaceDefinition getInterfaceDefinition(Interaction interaction) throws InterfaceException {
        InterfaceDefinition idef = null;
        DefaultRoleTypeDefinition rtdef = (DefaultRoleTypeDefinition)this.m_roleTypeIndex.get(interaction.getToRoleType());
        if (rtdef == null) {
            throw new InterfaceException("Role definition not found for role type '" + interaction.getToRoleType().getName() + "'");
        }
        ChannelType ctype = (ChannelType)interaction.getChannelVariable().getType();
        Behavior behavior = ctype.getBehavior();
        if (behavior == null && interaction.getToRoleType().getBehaviors().size() > 0) {
            behavior = (Behavior)interaction.getToRoleType().getBehaviors().get(0);
        }
        if (behavior == null) {
            throw new InterfaceException("Could not derive behavior interface for role type '" + interaction.getToRoleType().getName() + "'");
        }
        idef = rtdef.getInterfaceForBehavior(behavior.getName());
        if (idef == null) {
            throw new InterfaceException("Interface could not be found for behavior '" + behavior.getName() + "' on role type '" + interaction.getToRoleType().getName() + "'");
        }
        return idef;
    }

    public void processExchangeDetails(ExchangeDetails exchange, InterfaceDefinition idef, String targetNamespace, XMLPrefixResolver prefixes) throws InterfaceException {
        String type;
        List<ExchangeDetails> reqExchanges = null;
        String reqType = null;
        String reqNamespace = null;
        ExchangeDetails reqDetails = null;
        String notType = null;
        String notNamespace = null;
        if (exchange.getAction() != ExchangeActionType.NOTIFY) {
            reqExchanges = InteractionUtil.getRequestExchangeDetails(exchange);
            if (exchange.getAction() == ExchangeActionType.RESPOND && (reqExchanges == null || reqExchanges.size() == 0)) {
                String name = "";
                if (NamesUtil.isSet((String)exchange.getName())) {
                    name = "'" + exchange.getName() + "' ";
                }
                throw new InterfaceException("Response exchange " + name + "for operation '" + exchange.getInteraction().getOperation() + "' has no associated request: " + exchange);
            }
        } else {
            type = CDLTypeUtil.getRealInformationType(exchange.getType());
            if (!NamesUtil.isSet((String)type)) {
                type = CDLTypeUtil.getRealInformationElement(exchange.getType());
            }
            notNamespace = CDLTypeUtil.getNamespace(type, exchange);
            notType = XMLUtils.getLocalname((String)type);
        }
        if (reqExchanges != null && reqExchanges.size() >= 1) {
            reqDetails = reqExchanges.get(0);
            type = CDLTypeUtil.getRealInformationType(reqDetails.getType());
            if (!NamesUtil.isSet((String)type)) {
                type = CDLTypeUtil.getRealInformationElement(reqDetails.getType());
            }
            reqNamespace = CDLTypeUtil.getNamespace(type, exchange);
            reqType = XMLUtils.getLocalname((String)type);
        }
        DefaultOperationDefinition opdef = null;
        List ops = null;
        ops = exchange.getAction() == ExchangeActionType.NOTIFY ? idef.getNotifications(exchange.getInteraction().getOperation(), notNamespace, notType) : idef.getOperations(exchange.getInteraction().getOperation(), reqNamespace, reqType, null, null);
        if (ops.size() > 0) {
            opdef = (DefaultOperationDefinition)ops.get(0);
            if (ops.size() > 1) {
                logger.warning("More than one operation definition (" + ops.size() + ") exists for '" + exchange.getInteraction().getOperation() + "' and request type '" + NameSpaceUtil.getFullyQualifiedName((String)reqNamespace, (String)reqType) + "'");
            }
        }
        if (opdef == null) {
            opdef = new DefaultOperationDefinition(idef, exchange.getInteraction().getOperation());
            idef.getOperations().add(opdef);
            if (reqDetails != null) {
                this.addMessageDefinition(reqDetails, true, targetNamespace, idef, opdef, prefixes);
            }
        }
        this.addMessageDefinition(exchange, reqDetails != null, targetNamespace, idef, opdef, prefixes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addMessageDefinition(ExchangeDetails exchange, boolean reqFound, String targetNamespace, InterfaceDefinition idef, OperationDefinition opdef, XMLPrefixResolver prefixes) {
        int mesgType = -1;
        if (exchange.getAction() == ExchangeActionType.REQUEST) {
            mesgType = exchange.isFault() ? 2 : 0;
        } else if (exchange.getAction() == ExchangeActionType.RESPOND || exchange.getAction() == ExchangeActionType.NOTIFY) {
            mesgType = exchange.isFault() ? 3 : 1;
        }
        if (mesgType == -1) {
            throw new InterfaceException("Unable to determine message type for operation '" + exchange.getInteraction().getOperation() + "' exchange '" + exchange.getName() + "/" + exchange.getDescription() + "'");
        }
        String faultLocalname = null;
        String faultNamespace = null;
        if (NamesUtil.isSet((String)exchange.getFaultName())) {
            faultLocalname = XMLUtils.getLocalname((String)exchange.getFaultName());
            String prefix = XMLUtils.getPrefix((String)exchange.getFaultName());
            faultNamespace = prefix != null ? XMLUtils.getNamespace((String)exchange.getFaultName(), (XMLPrefixResolver)prefixes, (String)targetNamespace) : targetNamespace;
        }
        MessageDefinition mesgdef = opdef.getMessage(faultNamespace, faultLocalname, mesgType);
        String typeLocalname = null;
        String typeNamespace = null;
        String elemLocalname = null;
        String elemNamespace = null;
        if (exchange.getType() != null) {
            String realType = CDLTypeUtil.getRealInformationType(exchange.getType());
            String realElement = CDLTypeUtil.getRealInformationElement(exchange.getType());
            if (realType != null) {
                typeLocalname = XMLUtils.getLocalname((String)realType);
                typeNamespace = XMLUtils.getNamespace((String)realType, (XMLPrefixResolver)prefixes, null);
            }
            if (realElement != null) {
                elemLocalname = XMLUtils.getLocalname((String)realElement);
                elemNamespace = XMLUtils.getNamespace((String)realElement, (XMLPrefixResolver)prefixes, null);
            }
        }
        if (mesgdef == null) {
            mesgdef = new DefaultMessageDefinition(exchange.getName(), faultNamespace, faultLocalname, typeNamespace, typeLocalname, elemNamespace, elemLocalname, null, mesgType);
            opdef.getMessages().add(mesgdef);
            return;
        } else if (typeLocalname != null) {
            if (mesgdef.getElement() != null) {
                throw new InterfaceException("Invalid exchange '" + exchange.getName() + "' for operation '" + opdef.getOperationName() + "', on role type '" + exchange.getInteraction().getToRoleType().getName() + "', using a 'type' based information type " + "when previously the operation used " + "schema element [" + mesgdef.getElementNamespace() + "]" + mesgdef.getElement());
            }
            if (mesgdef.getType() == null) {
                if (!(mesgdef instanceof DefaultMessageDefinition) || typeLocalname == null) return;
                ((DefaultMessageDefinition)mesgdef).setType(typeLocalname);
                ((DefaultMessageDefinition)mesgdef).setTypeNamespace(typeNamespace);
                return;
            } else {
                if (typeLocalname.equals(mesgdef.getType()) && this.compare(typeNamespace, mesgdef.getTypeNamespace())) return;
                if (reqFound) throw new InterfaceException("Two or more instances of operation '" + opdef.getOperationName() + "', on role type '" + exchange.getInteraction().getToRoleType().getName() + "', have incompatible schema types for a '" + (Object)((Object)exchange.getAction()) + "' exchange: [" + mesgdef.getTypeNamespace() + "]" + mesgdef.getType() + " and [" + typeNamespace + "]" + typeLocalname);
                opdef = new DefaultOperationDefinition(idef, exchange.getInteraction().getOperation());
                idef.getOperations().add(opdef);
                mesgdef = new DefaultMessageDefinition(exchange.getName(), faultNamespace, faultLocalname, typeNamespace, typeLocalname, elemNamespace, elemLocalname, null, mesgType);
                opdef.getMessages().add(mesgdef);
            }
            return;
        } else {
            if (elemLocalname == null) return;
            if (mesgdef.getType() != null) {
                throw new InterfaceException("Invalid exchange '" + exchange.getName() + "' for operation '" + opdef.getOperationName() + "', on role type '" + exchange.getInteraction().getToRoleType().getName() + "', using an 'element' based information type " + "when previously the operation used " + "schema type [" + mesgdef.getTypeNamespace() + "]" + mesgdef.getType());
            }
            if (mesgdef.getElement() == null) {
                if (!(mesgdef instanceof DefaultMessageDefinition) || elemLocalname == null) return;
                ((DefaultMessageDefinition)mesgdef).setElement(elemLocalname);
                ((DefaultMessageDefinition)mesgdef).setElementNamespace(elemNamespace);
                return;
            } else {
                if (elemLocalname.equals(mesgdef.getElement()) && this.compare(elemNamespace, mesgdef.getElementNamespace())) return;
                if (reqFound) throw new InterfaceException("Two or more instances of operation '" + opdef.getOperationName() + "', on role type '" + exchange.getInteraction().getToRoleType().getName() + "', have incompatible schema elements for a '" + (Object)((Object)exchange.getAction()) + "' exchange: [" + mesgdef.getElementNamespace() + "]" + mesgdef.getElement() + " and [" + elemNamespace + "]" + elemLocalname);
                opdef = new DefaultOperationDefinition(idef, exchange.getInteraction().getOperation());
                idef.getOperations().add(opdef);
                mesgdef = new DefaultMessageDefinition(exchange.getName(), faultNamespace, faultLocalname, typeNamespace, typeLocalname, elemNamespace, elemLocalname, null, mesgType);
                opdef.getMessages().add(mesgdef);
            }
        }
    }

    protected boolean compare(String s1, String s2) {
        boolean ret = false;
        if (s1 == null && s2 == null) {
            ret = true;
        } else if (s1 != null && s2 != null && s1.equals(s2)) {
            ret = true;
        }
        return ret;
    }

    public List getRoleTypeDefinitions() {
        return this.m_roleTypeDefinitions;
    }
}

