/*
 * Decompiled with CFR 0.152.
 */
package org.pi4soa.cdl.interfaces.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.pi4soa.cdl.interfaces.EquivalenceChecker;
import org.pi4soa.cdl.interfaces.InterfaceDefinition;
import org.pi4soa.cdl.interfaces.InterfaceException;
import org.pi4soa.cdl.interfaces.MessageDefinition;
import org.pi4soa.cdl.interfaces.OperationDefinition;
import org.pi4soa.common.resource.ResourceLocator;
import org.pi4soa.common.util.NamesUtil;

public class EquivalenceCheckerImpl
implements EquivalenceChecker {
    public String[] checkEquivalence(InterfaceDefinition newdef, InterfaceDefinition olddef) throws InterfaceException {
        Object[] ret = null;
        Vector<String> mesgs = new Vector<String>();
        if (newdef != null && olddef != null) {
            for (OperationDefinition opdef : newdef.getOperations()) {
                String mesg = this.checkEquivalence(opdef.getOperationName(), newdef, olddef);
                if (mesg == null) continue;
                mesgs.add(mesg);
            }
            if (mesgs.size() > 0) {
                ret = new String[mesgs.size()];
                mesgs.copyInto(ret);
            }
        }
        return ret;
    }

    public String checkEquivalence(String operation, InterfaceDefinition newdef, InterfaceDefinition olddef) throws InterfaceException {
        String ret = null;
        if (operation != null && newdef != null && olddef != null) {
            List newopdefs = newdef.getOperations(operation, null, null, null, null);
            int i = 0;
            while (i < newopdefs.size()) {
                OperationDefinition newopdef = (OperationDefinition)newopdefs.get(i);
                String reqNS = null;
                String reqType = null;
                String respNS = null;
                String respType = null;
                MessageDefinition mdef2 = null;
                List mdefs = newopdef.getMessages(0);
                if (mdefs.size() > 0) {
                    mdef2 = (MessageDefinition)mdefs.get(0);
                } else {
                    mdefs = newopdef.getMessages(1);
                    if (mdefs.size() == 1) {
                        mdef2 = (MessageDefinition)mdefs.get(0);
                    }
                }
                if (mdef2 != null) {
                    reqType = mdef2.getType();
                    if (NamesUtil.isSet((String)reqType)) {
                        reqNS = mdef2.getTypeNamespace();
                    } else {
                        reqType = mdef2.getElement();
                        reqNS = mdef2.getElementNamespace();
                    }
                }
                List oldopdefs = olddef.getOperations(operation, reqNS, reqType, respNS, respType);
                if (newopdef == null) {
                    // empty if block
                }
                if (oldopdefs.size() == 0) {
                    ret = EquivalenceCheckerImpl.getMessage("_EXISTING_OPERATION_NOT_FOUND", new String[]{operation});
                } else {
                    if (oldopdefs.size() > 1) {
                        throw new InterfaceException("Operation '" + operation + "' has multiple definitions for the same " + "signature");
                    }
                    OperationDefinition oldopdef = (OperationDefinition)oldopdefs.get(0);
                    for (MessageDefinition mdef2 : newopdef.getMessages()) {
                        String mesg = this.checkMessageEquivalence(mdef2, oldopdef);
                        if (mesg == null) continue;
                        ret = ret == null ? String.valueOf(EquivalenceCheckerImpl.getMessage("_EXISTING_MESSAGE_INCOMPATIBLE", new String[]{operation})) + ": " + mesg : String.valueOf(ret) + "; " + mesg;
                    }
                }
                ++i;
            }
        }
        return ret;
    }

    public String checkMessageEquivalence(MessageDefinition mdef, OperationDefinition oldopdef) {
        String ret = null;
        if (mdef.getClassification() == 0) {
            List list = oldopdef.getMessages(mdef.getClassification());
            if (list.size() == 0) {
                ret = EquivalenceCheckerImpl.getMessage("_EXISTING_INPUT_MESSAGE_NOT_FOUND", new String[]{oldopdef.getOperationName()});
            } else {
                Iterator iter = list.iterator();
                boolean f_found = false;
                while (iter.hasNext()) {
                    MessageDefinition oldmdef = (MessageDefinition)iter.next();
                    if (mdef.getType() != null && mdef.getType().equals(oldmdef.getType()) && mdef.getTypeNamespace().equals(oldmdef.getTypeNamespace())) {
                        f_found = true;
                        continue;
                    }
                    if (mdef.getElement() == null || !mdef.getElement().equals(oldmdef.getElement()) || !mdef.getElementNamespace().equals(oldmdef.getElementNamespace())) continue;
                    f_found = true;
                }
                if (!f_found) {
                    ret = EquivalenceCheckerImpl.getMessage("_EXISTING_INPUT_MESSAGE_INCOMPATIBLE_TYPE", new String[]{oldopdef.getOperationName()});
                }
            }
        } else if (mdef.getClassification() == 1) {
            List list = oldopdef.getMessages(mdef.getClassification());
            if (list.size() == 0) {
                ret = EquivalenceCheckerImpl.getMessage("_EXISTING_OUTPUT_MESSAGE_NOT_FOUND", new String[]{oldopdef.getOperationName()});
            } else {
                Iterator iter = list.iterator();
                boolean f_found = false;
                while (iter.hasNext()) {
                    MessageDefinition oldmdef = (MessageDefinition)iter.next();
                    if (!mdef.getType().equals(oldmdef.getType()) || !mdef.getTypeNamespace().equals(oldmdef.getTypeNamespace())) continue;
                    f_found = true;
                }
                if (!f_found) {
                    ret = EquivalenceCheckerImpl.getMessage("_EXISTING_OUTPUT_MESSAGE_INCOMPATIBLE_TYPE", new String[]{oldopdef.getOperationName()});
                }
            }
        } else if (mdef.getClassification() == 2 || mdef.getClassification() == 3) {
            MessageDefinition oldmdef = oldopdef.getMessage(mdef.getFaultNamespace(), mdef.getFaultName(), mdef.getClassification());
            if (oldmdef == null) {
                ret = EquivalenceCheckerImpl.getMessage("_EXISTING_FAULT_NOT_FOUND", new String[]{mdef.getFaultName(), oldopdef.getOperationName()});
            } else if (!(oldmdef.getType() == null || oldmdef.getTypeNamespace() == null || mdef.getType().equals(oldmdef.getType()) && mdef.getTypeNamespace().equals(oldmdef.getTypeNamespace()))) {
                ret = EquivalenceCheckerImpl.getMessage("_EXISTING_FAULT_INCOMPATIBLE_TYPE", new String[]{mdef.getFaultName(), oldopdef.getOperationName()});
            }
        }
        return ret;
    }

    public static String getMessage(String id, String[] info) {
        return ResourceLocator.getMessage((String)"cdl", (String)id, (Object[])info);
    }
}

